/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v7;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.jasig.cas.client.tomcat.AuthenticatorDelegate;
import org.jasig.cas.client.tomcat.CasRealm;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticator
extends AuthenticatorBase
implements LifecycleListener {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AuthenticatorDelegate delegate = new AuthenticatorDelegate();
    private String casServerUrlPrefix;
    private String encoding;
    private boolean encode;
    private boolean renew;

    protected abstract String getAuthenticationMethod();

    protected String getAuthMethod() {
        return this.getAuthenticationMethod();
    }

    protected abstract String getArtifactParameterName();

    protected abstract String getServiceParameterName();

    protected abstract TicketValidator getTicketValidator();

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.logger.debug("{} starting.", (Object)this.getName());
        Realm realm = this.context.getRealm();
        try {
            CommonUtils.assertTrue((boolean)(realm instanceof CasRealm), (String)("Expected CasRealm but got " + realm.getInfo()));
            CommonUtils.assertNotNull((Object)this.casServerUrlPrefix, (String)"casServerUrlPrefix cannot be null.");
            CommonUtils.assertNotNull((Object)this.delegate.getCasServerLoginUrl(), (String)"casServerLoginUrl cannot be null.");
            CommonUtils.assertTrue((this.delegate.getServerName() != null || this.delegate.getServiceUrl() != null ? 1 : 0) != 0, (String)"either serverName or serviceUrl must be set.");
            this.delegate.setRealm((CasRealm)realm);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        this.addLifecycleListener(this);
    }

    protected final String getCasServerUrlPrefix() {
        return this.casServerUrlPrefix;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.delegate.setCasServerLoginUrl(casServerLoginUrl);
    }

    public final boolean isEncode() {
        return this.encode;
    }

    public final void setEncode(boolean encode) {
        this.encode = encode;
    }

    protected final boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setServerName(String serverName) {
        this.delegate.setServerName(serverName);
    }

    public final void setServiceUrl(String serviceUrl) {
        this.delegate.setServiceUrl(serviceUrl);
    }

    protected final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final boolean authenticate(Request request, HttpServletResponse response, LoginConfig loginConfig) throws IOException {
        Principal principal = request.getUserPrincipal();
        boolean result = false;
        if (principal == null) {
            principal = this.delegate.authenticate(request.getRequest(), response);
            if (principal != null) {
                this.register(request, response, principal, this.getAuthenticationMethod(), null, null);
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("after_start".equals(event.getType())) {
            this.logger.debug("{} processing lifecycle event {}", (Object)this.getName(), (Object)"after_start");
            this.delegate.setTicketValidator(this.getTicketValidator());
            this.delegate.setArtifactParameterName(this.getArtifactParameterName());
            this.delegate.setServiceParameterName(this.getServiceParameterName());
        }
    }

    public String getInfo() {
        return this.getName() + "/1.0";
    }

    protected synchronized void setState(LifecycleState state, Object data) {
        super.setState(state, data);
        if (LifecycleState.STARTED.equals((Object)state)) {
            this.logger.info("{} started.", (Object)this.getName());
        }
    }

    protected abstract String getName();
}

