/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.x509.authentication.handler.support.NoOpRevocationChecker;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationChecker;
import org.jasig.cas.adaptors.x509.authentication.principal.X509CertificateCredentials;
import org.jasig.cas.adaptors.x509.util.CertUtils;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CredentialsAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final int DEFAULT_MAXPATHLENGTH = 1;
    private static final boolean DEFAULT_MAXPATHLENGTH_ALLOW_UNSPECIFIED = false;
    private static final boolean DEFAULT_CHECK_KEYUSAGE = false;
    private static final boolean DEFAULT_REQUIRE_KEYUSAGE = false;
    private static final Pattern DEFAULT_SUBJECT_DN_PATTERN = Pattern.compile(".*");
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Pattern regExTrustedIssuerDnPattern;
    private int maxPathLength = 1;
    private boolean maxPathLengthAllowUnspecified = false;
    private boolean checkKeyUsage = false;
    private boolean requireKeyUsage = false;
    @NotNull
    private Pattern regExSubjectDnPattern = DEFAULT_SUBJECT_DN_PATTERN;
    @NotNull
    private RevocationChecker revocationChecker = new NoOpRevocationChecker();

    public boolean supports(Credentials credentials) {
        return credentials != null && X509CertificateCredentials.class.isAssignableFrom(credentials.getClass());
    }

    protected final boolean doAuthentication(Credentials credentials) throws AuthenticationException {
        X509CertificateCredentials x509Credentials = (X509CertificateCredentials)credentials;
        X509Certificate[] certificates = x509Credentials.getCertificates();
        X509Certificate clientCert = null;
        boolean valid = true;
        boolean hasTrustedIssuer = false;
        int i = certificates.length - 1;
        while (i >= 0) {
            X509Certificate certificate = certificates[i];
            try {
                int pathLength;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Evaluating " + CertUtils.toString(certificate));
                }
                this.validate(certificate);
                if (!hasTrustedIssuer) {
                    hasTrustedIssuer = this.isCertificateFromTrustedIssuer(certificate);
                }
                if ((pathLength = certificate.getBasicConstraints()) < 0) {
                    this.log.debug("Found valid client certificate");
                    clientCert = certificate;
                } else {
                    this.log.debug("Found valid CA certificate");
                }
            }
            catch (GeneralSecurityException e) {
                this.log.warn("Failed to validate " + CertUtils.toString(certificate), (Throwable)e);
                valid = false;
            }
            --i;
        }
        if (valid && hasTrustedIssuer && clientCert != null) {
            x509Credentials.setCertificate(clientCert);
            this.log.info("Successfully authenticated " + credentials);
            return true;
        }
        this.log.info("Failed to authenticate " + credentials);
        return false;
    }

    public void setTrustedIssuerDnPattern(String trustedIssuerDnPattern) {
        this.regExTrustedIssuerDnPattern = Pattern.compile(trustedIssuerDnPattern);
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setMaxPathLengthAllowUnspecified(boolean allowed) {
        this.maxPathLengthAllowUnspecified = allowed;
    }

    public void setCheckKeyUsage(boolean checkKeyUsage) {
        this.checkKeyUsage = checkKeyUsage;
    }

    public void setRequireKeyUsage(boolean requireKeyUsage) {
        this.requireKeyUsage = requireKeyUsage;
    }

    public void setSubjectDnPattern(String subjectDnPattern) {
        this.regExSubjectDnPattern = Pattern.compile(subjectDnPattern);
    }

    public void setRevocationChecker(RevocationChecker checker) {
        this.revocationChecker = checker;
    }

    private void validate(X509Certificate cert) throws GeneralSecurityException {
        cert.checkValidity();
        this.revocationChecker.check(cert);
        int pathLength = cert.getBasicConstraints();
        if (pathLength < 0) {
            if (!this.isCertificateAllowed(cert)) {
                throw new GeneralSecurityException("Certificate subject does not match pattern " + this.regExSubjectDnPattern.pattern());
            }
            if (this.checkKeyUsage && !this.isValidKeyUsage(cert)) {
                throw new GeneralSecurityException("Certificate keyUsage constraint forbids SSL client authentication.");
            }
        } else {
            if (pathLength == Integer.MAX_VALUE && !this.maxPathLengthAllowUnspecified) {
                throw new GeneralSecurityException("Unlimited certificate path length not allowed by configuration.");
            }
            if (pathLength > this.maxPathLength && pathLength < Integer.MAX_VALUE) {
                throw new GeneralSecurityException(String.format("Certificate path length %s exceeds maximum value %s.", pathLength, this.maxPathLength));
            }
        }
    }

    private boolean isValidKeyUsage(X509Certificate certificate) {
        boolean valid;
        this.log.debug("Checking certificate keyUsage extension");
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage == null) {
            this.log.warn("Configuration specifies checkKeyUsage but keyUsage extension not found in certificate.");
            return !this.requireKeyUsage;
        }
        if (this.isCritical(certificate, KEY_USAGE_OID) || this.requireKeyUsage) {
            this.log.debug("KeyUsage extension is marked critical or required by configuration.");
            valid = keyUsage[0];
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("KeyUsage digitalSignature=%s.");
                this.log.debug("Returning true since keyUsage validation not required by configuration.");
            }
            valid = true;
        }
        return valid;
    }

    private boolean isCritical(X509Certificate certificate, String extensionOid) {
        Set<String> criticalOids = certificate.getCriticalExtensionOIDs();
        if (criticalOids == null || criticalOids.isEmpty()) {
            return false;
        }
        return criticalOids.contains(extensionOid);
    }

    private boolean isCertificateAllowed(X509Certificate cert) {
        return this.doesNameMatchPattern(cert.getSubjectDN(), this.regExSubjectDnPattern);
    }

    private boolean isCertificateFromTrustedIssuer(X509Certificate cert) {
        return this.doesNameMatchPattern(cert.getIssuerDN(), this.regExTrustedIssuerDnPattern);
    }

    private boolean doesNameMatchPattern(Principal principal, Pattern pattern) {
        String name = principal.getName();
        boolean result = pattern.matcher(name).matches();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("%s matches %s == %s", pattern.pattern(), name, result));
        }
        return result;
    }
}

