/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.utils;

import org.apache.cassandra.service.CassandraDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemonWrapper {
    private static final Logger log = LoggerFactory.getLogger(CassandraDaemonWrapper.class);
    private static String activeConfig;
    private static boolean started;

    public static synchronized void start(String config) {
        if (started) {
            if (null != config && !config.equals(activeConfig)) {
                log.warn("Can't start in-process Cassandra instance with yaml path {} because an instance was previously started with yaml path {}", (Object)config, (Object)activeConfig);
            }
            return;
        }
        started = true;
        log.debug("Current working directory: {}", (Object)System.getProperty("user.dir"));
        System.setProperty("cassandra.config", config);
        System.setProperty("cassandra-foreground", "yes");
        System.setProperty("log4j.defaultInitOverride", "false");
        log.info("Starting cassandra with {}", (Object)config);
        CassandraDaemon.main((String[])new String[0]);
        activeConfig = config;
    }

    public static synchronized boolean isStarted() {
        return started;
    }

    public static void stop() {
    }
}

