/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.thrift.thriftpool;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTConnectionFactory
implements KeyedPoolableObjectFactory<String, CTConnection> {
    private static final Logger log = LoggerFactory.getLogger(CTConnectionFactory.class);
    private static final long SCHEMA_WAIT_MAX = 5000L;
    private static final long SCHEMA_WAIT_INCREMENT = 25L;
    private final AtomicReference<Config> cfgRef;

    private CTConnectionFactory(Config config) {
        this.cfgRef = new AtomicReference<Config>(config);
    }

    public void activateObject(String key, CTConnection c) throws Exception {
    }

    public void destroyObject(String key, CTConnection c) throws Exception {
        TTransport t = c.getTransport();
        if (t.isOpen()) {
            t.close();
            log.trace("Closed transport {}", (Object)t);
        } else {
            log.trace("Not closing transport {} (already closed)", (Object)t);
        }
    }

    public CTConnection makeObject(String key) throws Exception {
        CTConnection conn = this.makeRawConnection();
        Cassandra.Client client = conn.getClient();
        client.set_keyspace(key);
        return conn;
    }

    public CTConnection makeRawConnection() throws TTransportException {
        TSocket socket;
        final Config cfg = this.cfgRef.get();
        String hostname = cfg.getRandomHost();
        log.debug("Creating TSocket({}, {}, {}, {}, {})", new Object[]{hostname, cfg.port, cfg.username, cfg.password, cfg.timeoutMS});
        if (null != cfg.sslTruststoreLocation && !cfg.sslTruststoreLocation.isEmpty()) {
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(){
                {
                    this.setTrustStore(cfg.sslTruststoreLocation, cfg.sslTruststorePassword);
                }
            };
            socket = TSSLTransportFactory.getClientSocket((String)hostname, (int)cfg.port, (int)cfg.timeoutMS, (TSSLTransportFactory.TSSLTransportParameters)params);
        } else {
            socket = new TSocket(hostname, cfg.port, cfg.timeoutMS);
        }
        TFramedTransport transport = new TFramedTransport((TTransport)socket, cfg.frameSize);
        log.trace("Created transport {}", (Object)transport);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        Cassandra.Client client = new Cassandra.Client((TProtocol)protocol);
        if (!transport.isOpen()) {
            transport.open();
        }
        if (cfg.username != null) {
            HashMap<String, String> credentials = new HashMap<String, String>(){
                {
                    this.put("username", cfg.username);
                    this.put("password", cfg.password);
                }
            };
            try {
                client.login(new AuthenticationRequest((Map)credentials));
            }
            catch (Exception e) {
                throw new TTransportException((Throwable)e);
            }
        }
        return new CTConnection((TTransport)transport, client, cfg);
    }

    public void passivateObject(String key, CTConnection o) throws Exception {
    }

    public boolean validateObject(String key, CTConnection c) {
        Config curCfg = this.cfgRef.get();
        boolean isSameConfig = c.getConfig().equals(curCfg);
        if (log.isDebugEnabled()) {
            if (isSameConfig) {
                log.trace("Validated {} by configuration {}", (Object)c, (Object)curCfg);
            } else {
                log.trace("Rejected {}; current config is {}; rejected connection config is {}", new Object[]{c, curCfg, c.getConfig()});
            }
        }
        return isSameConfig && c.isOpen();
    }

    public static class Config {
        private final String[] hostnames;
        private final int port;
        private final String username;
        private final String password;
        private final Random random;
        private int timeoutMS;
        private int frameSize;
        private String sslTruststoreLocation;
        private String sslTruststorePassword;
        private boolean isBuilt;

        public Config(String[] hostnames, int port, String username, String password) {
            this.hostnames = hostnames;
            this.port = port;
            this.username = username;
            this.password = password;
            this.random = new Random();
        }

        public String getHostname() {
            return this.hostnames[0];
        }

        public int getPort() {
            return this.port;
        }

        public String getRandomHost() {
            return this.hostnames.length == 1 ? this.hostnames[0] : this.hostnames[this.random.nextInt(this.hostnames.length)];
        }

        public Config setTimeoutMS(int timeoutMS) {
            this.checkIfAlreadyBuilt();
            this.timeoutMS = timeoutMS;
            return this;
        }

        public Config setFrameSize(int frameSize) {
            this.checkIfAlreadyBuilt();
            this.frameSize = frameSize;
            return this;
        }

        public Config setSSLTruststoreLocation(String location) {
            this.checkIfAlreadyBuilt();
            this.sslTruststoreLocation = location;
            return this;
        }

        public Config setSSLTruststorePassword(String password) {
            this.checkIfAlreadyBuilt();
            this.sslTruststorePassword = password;
            return this;
        }

        public CTConnectionFactory build() {
            this.isBuilt = true;
            return new CTConnectionFactory(this);
        }

        public void checkIfAlreadyBuilt() {
            if (this.isBuilt) {
                throw new IllegalStateException("Can't accept modifications when used with built factory.");
            }
        }

        public String toString() {
            return "Config[hostnames=" + StringUtils.join((Object[])this.hostnames, (char)',') + ", port=" + this.port + ", timeoutMS=" + this.timeoutMS + ", frameSize=" + this.frameSize + "]";
        }
    }
}

