/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.AbstractByteOrderedPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.thrift.TException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.cassandra.CassandraTransaction;
import org.janusgraph.diskstorage.cassandra.thrift.CassandraThriftStoreManager;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnectionPool;
import org.janusgraph.diskstorage.cassandra.utils.CassandraHelper;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.ByteBufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraThriftKeyColumnValueStore
implements KeyColumnValueStore {
    private static final Logger logger = LoggerFactory.getLogger(CassandraThriftKeyColumnValueStore.class);
    private static final Pattern BROKEN_BYTE_TOKEN_PATTERN = Pattern.compile("^Token\\(bytes\\[(.+)\\]\\)$");
    private final CassandraThriftStoreManager storeManager;
    private final String keyspace;
    private final String columnFamily;
    private final CTConnectionPool pool;
    private final ThriftGetter entryGetter;

    public CassandraThriftKeyColumnValueStore(String keyspace, String columnFamily, CassandraThriftStoreManager storeManager, CTConnectionPool pool) {
        this.storeManager = storeManager;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.pool = pool;
        this.entryGetter = new ThriftGetter(storeManager.getMetaDataSchema(columnFamily));
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        Map<StaticBuffer, EntryList> result = this.getNamesSlice(query.getKey(), (SliceQuery)query, txh);
        return (EntryList)Iterables.getOnlyElement(result.values(), (Object)EntryList.EMPTY_LIST);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.getNamesSlice(keys, query, txh);
    }

    public Map<StaticBuffer, EntryList> getNamesSlice(StaticBuffer key, SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.getNamesSlice((List<StaticBuffer>)ImmutableList.of((Object)key), query, txh);
    }

    public Map<StaticBuffer, EntryList> getNamesSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        ColumnParent parent = new ColumnParent(this.columnFamily);
        if (query.getSliceStart().compareTo((Object)query.getSliceEnd()) >= 0) {
            if (query.getSliceEnd().compareTo((Object)query.getSliceStart()) < 0) {
                throw new PermanentBackendException("columnStart=" + query.getSliceStart() + " is greater than columnEnd=" + query.getSliceEnd() + ". columnStart must be less than or equal to columnEnd");
            }
            if (0 != query.getSliceStart().length() && 0 != query.getSliceEnd().length()) {
                logger.debug("Return empty list due to columnEnd==columnStart and neither empty");
                return KCVSUtil.emptyResults(keys);
            }
        }
        assert (query.getSliceStart().compareTo((Object)query.getSliceEnd()) < 0);
        ConsistencyLevel consistency = CassandraTransaction.getTx(txh).getReadConsistencyLevel().getThrift();
        SlicePredicate predicate = new SlicePredicate();
        SliceRange range = new SliceRange();
        range.setCount(query.getLimit() + (query.hasLimit() ? 1 : 0));
        range.setStart(query.getSliceStart().asByteBuffer());
        range.setFinish(query.getSliceEnd().asByteBuffer());
        predicate.setSlice_range(range);
        CTConnection conn = null;
        try {
            conn = (CTConnection)this.pool.borrowObject(this.keyspace);
            Cassandra.Client client = conn.getClient();
            Map rows = client.multiget_slice(CassandraHelper.convert(keys), parent, predicate, consistency);
            HashMap<StaticArrayBuffer, EntryList> results = new HashMap<StaticArrayBuffer, EntryList>();
            for (ByteBuffer key : rows.keySet()) {
                results.put(StaticArrayBuffer.of((ByteBuffer)key), CassandraHelper.makeEntryList((Iterable)rows.get(key), this.entryGetter, query.getSliceEnd(), query.getLimit()));
            }
            HashMap<StaticArrayBuffer, EntryList> hashMap = results;
            return hashMap;
        }
        catch (Exception e) {
            throw CassandraThriftKeyColumnValueStore.convertException(e);
        }
        finally {
            this.pool.returnObjectUnsafe(this.keyspace, conn);
        }
    }

    public void close() {
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(@Nullable SliceQuery sliceQuery, StoreTransaction txh) throws BackendException {
        IPartitioner partitioner = this.storeManager.getCassandraPartitioner();
        if (!(partitioner instanceof RandomPartitioner) && !(partitioner instanceof Murmur3Partitioner)) {
            throw new PermanentBackendException("This operation is only allowed when random partitioner (md5 or murmur3) is used.");
        }
        try {
            return new AllTokensIterator(partitioner, sliceQuery, this.storeManager.getPageSize());
        }
        catch (Exception e) {
            throw CassandraThriftKeyColumnValueStore.convertException(e);
        }
    }

    public KeyIterator getKeys(KeyRangeQuery keyRangeQuery, StoreTransaction txh) throws BackendException {
        IPartitioner partitioner = this.storeManager.getCassandraPartitioner();
        if (!(partitioner instanceof AbstractByteOrderedPartitioner)) {
            throw new PermanentBackendException("This operation is only allowed when byte-ordered partitioner is used.");
        }
        try {
            return new KeyRangeIterator(partitioner, (SliceQuery)keyRangeQuery, this.storeManager.getPageSize(), keyRangeQuery.getKeyStart().asByteBuffer(), keyRangeQuery.getKeyEnd().asByteBuffer());
        }
        catch (Exception e) {
            throw CassandraThriftKeyColumnValueStore.convertException(e);
        }
    }

    public String getName() {
        return this.columnFamily;
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        ImmutableMap mutations = ImmutableMap.of((Object)key, (Object)new KCVMutation(additions, deletions));
        this.mutateMany((Map<StaticBuffer, KCVMutation>)mutations, txh);
    }

    public void mutateMany(Map<StaticBuffer, KCVMutation> mutations, StoreTransaction txh) throws BackendException {
        this.storeManager.mutateMany((Map<String, Map<StaticBuffer, KCVMutation>>)ImmutableMap.of((Object)this.columnFamily, mutations), txh);
    }

    static BackendException convertException(Throwable e) {
        if (e instanceof TException) {
            return new PermanentBackendException(e);
        }
        if (e instanceof TimedOutException) {
            return new TemporaryBackendException(e);
        }
        if (e instanceof UnavailableException) {
            return new TemporaryBackendException(e);
        }
        if (e instanceof InvalidRequestException) {
            return new PermanentBackendException(e);
        }
        return new PermanentBackendException(e);
    }

    public String toString() {
        return "CassandraThriftKeyColumnValueStore[ks=" + this.keyspace + ", cf=" + this.columnFamily + "]";
    }

    private List<KeySlice> getKeySlice(ByteBuffer startKey, ByteBuffer endKey, SliceQuery columnSlice, int count) throws BackendException {
        return this.getRangeSlices(new KeyRange().setStart_key(startKey).setEnd_key(endKey).setCount(count), columnSlice);
    }

    private <T extends Token> List<KeySlice> getTokenSlice(T startToken, T endToken, SliceQuery sliceQuery, int count) throws BackendException {
        String st = this.sanitizeBrokenByteToken(startToken);
        String et = this.sanitizeBrokenByteToken(endToken);
        KeyRange kr = new KeyRange().setStart_token(st).setEnd_token(et).setCount(count);
        return this.getRangeSlices(kr, sliceQuery);
    }

    private String sanitizeBrokenByteToken(Token tok) {
        String st = tok.toString();
        if (!(tok instanceof BytesToken)) {
            return st;
        }
        if (st.startsWith("T")) {
            Matcher m = BROKEN_BYTE_TOKEN_PATTERN.matcher(st);
            if (!m.matches()) {
                logger.warn("Unknown token string format: \"{}\"", (Object)st);
            } else {
                String old = st;
                st = m.group(1);
                logger.debug("Rewrote token string: \"{}\" -> \"{}\"", (Object)old, (Object)st);
            }
        }
        return st;
    }

    private List<KeySlice> getRangeSlices(KeyRange keyRange, @Nullable SliceQuery sliceQuery) throws BackendException {
        SliceRange sliceRange = new SliceRange();
        if (sliceQuery == null) {
            sliceRange.setStart(ArrayUtils.EMPTY_BYTE_ARRAY).setFinish(ArrayUtils.EMPTY_BYTE_ARRAY).setCount(5);
        } else {
            sliceRange.setStart(sliceQuery.getSliceStart().asByteBuffer()).setFinish(sliceQuery.getSliceEnd().asByteBuffer()).setCount(sliceQuery.hasLimit() ? sliceQuery.getLimit() : Integer.MAX_VALUE);
        }
        CTConnection connection = null;
        try {
            connection = (CTConnection)this.pool.borrowObject(this.keyspace);
            List slices = connection.getClient().get_range_slices(new ColumnParent(this.columnFamily), new SlicePredicate().setSlice_range(sliceRange), keyRange, ConsistencyLevel.QUORUM);
            for (KeySlice s : slices) {
                logger.debug("Key {}", (Object)ByteBufferUtil.toString((ByteBuffer)s.key, (String)"-"));
            }
            ArrayList<KeySlice> result = new ArrayList<KeySlice>(slices.size());
            KeyIterationPredicate pred = new KeyIterationPredicate();
            for (KeySlice ks : slices) {
                if (!pred.apply(ks)) continue;
                result.add(ks);
            }
            ArrayList<KeySlice> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw CassandraThriftKeyColumnValueStore.convertException(e);
        }
        finally {
            if (connection != null) {
                this.pool.returnObjectUnsafe(this.keyspace, connection);
            }
        }
    }

    private final class KeyRangeIterator
    extends AbstractBufferedRowIter {
        public KeyRangeIterator(IPartitioner partitioner, SliceQuery columnSlice, int pageSize, ByteBuffer startKey, ByteBuffer endKey) throws BackendException {
            super(partitioner, columnSlice, pageSize, partitioner.getToken(startKey), partitioner.getToken(endKey), true);
            Preconditions.checkArgument((boolean)(partitioner instanceof AbstractByteOrderedPartitioner));
            List ks = CassandraThriftKeyColumnValueStore.this.getKeySlice(startKey, endKey, columnSlice, pageSize);
            this.ksIter = this.checkFreshSlices(ks).iterator();
        }
    }

    private final class AllTokensIterator
    extends AbstractBufferedRowIter {
        public AllTokensIterator(IPartitioner partitioner, SliceQuery columnSlice, int pageSize) {
            super(partitioner, columnSlice, pageSize, partitioner.getMinimumToken(), partitioner.getMinimumToken(), false);
        }
    }

    public class AbstractBufferedRowIter
    implements KeyIterator {
        private final int pageSize;
        private final SliceQuery columnSlice;
        private boolean isClosed;
        private boolean seenEnd;
        protected Iterator<KeySlice> ksIter;
        private KeySlice mostRecentRow;
        private final IPartitioner partitioner;
        private Token nextStartToken;
        private final Token endToken;
        private ByteBuffer nextStartKey;
        private boolean omitEndToken;

        public AbstractBufferedRowIter(IPartitioner partitioner, SliceQuery columnSlice, int pageSize, Token startToken, Token endToken, boolean omitEndToken) {
            this.pageSize = pageSize;
            this.partitioner = partitioner;
            this.nextStartToken = startToken;
            this.endToken = endToken;
            this.columnSlice = columnSlice;
            this.seenEnd = false;
            this.isClosed = false;
            this.ksIter = Iterators.emptyIterator();
            this.mostRecentRow = null;
            this.omitEndToken = omitEndToken;
        }

        public boolean hasNext() {
            this.ensureOpen();
            if (!this.ksIter.hasNext() && !this.seenEnd) {
                try {
                    this.ksIter = this.rebuffer().iterator();
                }
                catch (BackendException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.ksIter.hasNext();
        }

        public StaticBuffer next() {
            this.ensureOpen();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mostRecentRow = this.ksIter.next();
            Preconditions.checkNotNull((Object)this.mostRecentRow);
            return StaticArrayBuffer.of((ByteBuffer)this.mostRecentRow.bufferForKey());
        }

        public void close() {
            this.closeIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            return new RecordIterator<Entry>(){
                final Iterator<Entry> columns;
                {
                    this.columns = CassandraHelper.makeEntryIterator(AbstractBufferedRowIter.this.mostRecentRow.getColumns(), CassandraThriftKeyColumnValueStore.this.entryGetter, AbstractBufferedRowIter.this.columnSlice.getSliceEnd(), AbstractBufferedRowIter.this.columnSlice.getLimit());
                }

                public boolean hasNext() {
                    AbstractBufferedRowIter.this.ensureOpen();
                    return this.columns.hasNext();
                }

                public Entry next() {
                    AbstractBufferedRowIter.this.ensureOpen();
                    return this.columns.next();
                }

                public void close() {
                    AbstractBufferedRowIter.this.closeIterator();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }

        private void closeIterator() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        private List<KeySlice> rebuffer() throws BackendException {
            Preconditions.checkArgument((!this.seenEnd ? 1 : 0) != 0);
            return this.checkFreshSlices(this.getNextKeySlices());
        }

        protected List<KeySlice> checkFreshSlices(List<KeySlice> ks) {
            if (0 == ks.size()) {
                this.seenEnd = true;
                return Collections.emptyList();
            }
            this.nextStartKey = ks.get(ks.size() - 1).bufferForKey();
            this.nextStartToken = this.partitioner.getToken(this.nextStartKey);
            if (this.nextStartToken.equals(this.endToken)) {
                this.seenEnd = true;
                if (this.omitEndToken) {
                    ks.remove(ks.size() - 1);
                }
            }
            return ks;
        }

        protected final List<KeySlice> getNextKeySlices() throws BackendException {
            return CassandraThriftKeyColumnValueStore.this.getTokenSlice(this.nextStartToken, this.endToken, this.columnSlice, this.pageSize);
        }
    }

    private static class KeyIterationPredicate
    implements Predicate<KeySlice> {
        private KeyIterationPredicate() {
        }

        public boolean apply(@Nullable KeySlice row) {
            return row != null && row.getColumns().size() > 0;
        }
    }

    private static class ThriftGetter
    implements StaticArrayEntry.GetColVal<ColumnOrSuperColumn, ByteBuffer> {
        private final EntryMetaData[] schema;

        private ThriftGetter(EntryMetaData[] schema) {
            this.schema = schema;
        }

        public ByteBuffer getColumn(ColumnOrSuperColumn element) {
            return element.getColumn().bufferForName();
        }

        public ByteBuffer getValue(ColumnOrSuperColumn element) {
            return element.getColumn().bufferForValue();
        }

        public EntryMetaData[] getMetaSchema(ColumnOrSuperColumn element) {
            return this.schema;
        }

        public Object getMetaData(ColumnOrSuperColumn element, EntryMetaData meta) {
            switch (meta) {
                case TIMESTAMP: {
                    return element.getColumn().getTimestamp();
                }
                case TTL: {
                    return element.getColumn().getTtl();
                }
            }
            throw new UnsupportedOperationException("Unsupported meta data: " + meta);
        }
    }
}

