/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.diskstorage.cassandra.CassandraTransaction;
import org.janusgraph.diskstorage.cassandra.embedded.CassandraEmbeddedKeyColumnValueStore;
import org.janusgraph.diskstorage.cassandra.utils.CassandraDaemonWrapper;
import org.janusgraph.diskstorage.cassandra.utils.CassandraHelper;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.ByteBufferUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEmbeddedStoreManager
extends AbstractCassandraStoreManager {
    private static final Logger log = LoggerFactory.getLogger(CassandraEmbeddedStoreManager.class);
    public static final String CASSANDRA_YAML_DEFAULT = "./conf/cassandra.yaml";
    private final Map<String, CassandraEmbeddedKeyColumnValueStore> openStores;
    private final IRequestScheduler requestScheduler;

    public CassandraEmbeddedStoreManager(Configuration config) throws BackendException {
        super(config);
        String cassandraConfig = CASSANDRA_YAML_DEFAULT;
        if (config.has(GraphDatabaseConfiguration.STORAGE_CONF_FILE, new String[0])) {
            cassandraConfig = (String)config.get(GraphDatabaseConfiguration.STORAGE_CONF_FILE, new String[0]);
        }
        assert (cassandraConfig != null && !cassandraConfig.isEmpty());
        File ccf = new File(cassandraConfig);
        if (ccf.exists() && ccf.isAbsolute()) {
            cassandraConfig = "file://" + cassandraConfig;
            log.debug("Set cassandra config string \"{}\"", (Object)cassandraConfig);
        }
        CassandraDaemonWrapper.start(cassandraConfig);
        this.openStores = new HashMap<String, CassandraEmbeddedKeyColumnValueStore>(8);
        this.requestScheduler = DatabaseDescriptor.getRequestScheduler();
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return DistributedStoreManager.Deployment.EMBEDDED;
    }

    @Override
    public IPartitioner getCassandraPartitioner() throws BackendException {
        try {
            return StorageService.getPartitioner();
        }
        catch (Exception e) {
            log.warn("Could not read local token range: {}", (Throwable)e);
            throw new PermanentBackendException("Could not read partitioner information on cluster", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "embeddedCassandra" + super.toString();
    }

    public void close() {
        this.openStores.clear();
        CassandraDaemonWrapper.stop();
    }

    public synchronized KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        if (this.openStores.containsKey(name)) {
            return this.openStores.get(name);
        }
        this.ensureKeyspaceExists(this.keySpaceName);
        this.ensureColumnFamilyExists(this.keySpaceName, name);
        CassandraEmbeddedKeyColumnValueStore store = new CassandraEmbeddedKeyColumnValueStore(this.keySpaceName, name, this);
        this.openStores.put(name, store);
        return store;
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        this.ensureKeyspaceExists(this.keySpaceName);
        Collection ranges = StorageService.instance.getPrimaryRanges(this.keySpaceName);
        ArrayList<KeyRange> keyRanges = new ArrayList<KeyRange>(ranges.size());
        for (Range range : ranges) {
            keyRanges.add(CassandraHelper.transformRange((Range<Token>)range));
        }
        return keyRanges;
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        Preconditions.checkNotNull(mutations);
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp(txh);
        int size = 0;
        for (Map<StaticBuffer, KCVMutation> mutation : mutations.values()) {
            size += mutation.size();
        }
        HashMap<StaticBuffer, Mutation> rowMutations = new HashMap<StaticBuffer, Mutation>(size);
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> mutEntry : mutations.entrySet()) {
            String columnFamily = mutEntry.getKey();
            for (Map.Entry<StaticBuffer, KCVMutation> janusgraphMutation : mutEntry.getValue().entrySet()) {
                StaticBuffer key = janusgraphMutation.getKey();
                KCVMutation mut = janusgraphMutation.getValue();
                Mutation rm = (Mutation)rowMutations.get(key);
                if (rm == null) {
                    rm = new Mutation(this.keySpaceName, key.asByteBuffer());
                    rowMutations.put(key, rm);
                }
                if (mut.hasAdditions()) {
                    for (Entry e : mut.getAdditions()) {
                        Integer ttl = (Integer)e.getMetaData().get(EntryMetaData.TTL);
                        if (null != ttl && ttl > 0) {
                            rm.add(columnFamily, CellNames.simpleDense((ByteBuffer)((ByteBuffer)e.getColumnAs(StaticBuffer.BB_FACTORY))), (ByteBuffer)e.getValueAs(StaticBuffer.BB_FACTORY), commitTime.getAdditionTime(this.times), ttl.intValue());
                            continue;
                        }
                        rm.add(columnFamily, CellNames.simpleDense((ByteBuffer)((ByteBuffer)e.getColumnAs(StaticBuffer.BB_FACTORY))), (ByteBuffer)e.getValueAs(StaticBuffer.BB_FACTORY), commitTime.getAdditionTime(this.times));
                    }
                }
                if (!mut.hasDeletions()) continue;
                for (StaticBuffer col : mut.getDeletions()) {
                    rm.delete(columnFamily, CellNames.simpleDense((ByteBuffer)((ByteBuffer)col.as(StaticBuffer.BB_FACTORY))), commitTime.getDeletionTime(this.times));
                }
            }
        }
        this.mutate(new ArrayList<Mutation>(rowMutations.values()), CassandraTransaction.getTx(txh).getWriteConsistencyLevel().getDB());
        this.sleepAfterWrite(txh, commitTime);
    }

    private void mutate(List<Mutation> cmds, ConsistencyLevel clvl) throws BackendException {
        try {
            this.schedule(DatabaseDescriptor.getRpcTimeout());
            try {
                if (this.atomicBatch) {
                    StorageProxy.mutateAtomically(cmds, (ConsistencyLevel)clvl);
                } else {
                    StorageProxy.mutate(cmds, (ConsistencyLevel)clvl);
                }
            }
            catch (RequestExecutionException e) {
                throw new TemporaryBackendException((Throwable)e);
            }
            finally {
                this.release();
            }
        }
        catch (TimeoutException ex) {
            log.debug("Cassandra TimeoutException", (Throwable)ex);
            throw new TemporaryBackendException((Throwable)ex);
        }
    }

    private void schedule(long timeoutMS) throws TimeoutException {
        this.requestScheduler.queue(Thread.currentThread(), "default", DatabaseDescriptor.getRpcTimeout());
    }

    private void release() {
        this.requestScheduler.release();
    }

    public void clearStorage() throws BackendException {
        this.openStores.clear();
        try {
            KSMetaData ksMetaData = Schema.instance.getKSMetaData(this.keySpaceName);
            if (ksMetaData == null) {
                return;
            }
            for (String cfName : ksMetaData.cfMetaData().keySet()) {
                StorageService.instance.truncate(this.keySpaceName, cfName);
            }
        }
        catch (Exception e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private void ensureKeyspaceExists(String keyspaceName) throws BackendException {
        KSMetaData ksm;
        if (null != Schema.instance.getKeyspaceInstance(keyspaceName)) {
            return;
        }
        String strategyName = (String)this.storageConfig.get(REPLICATION_STRATEGY, new String[0]);
        try {
            ksm = KSMetaData.newKeyspace((String)keyspaceName, (String)strategyName, (Map)this.strategyOptions, (boolean)true);
        }
        catch (ConfigurationException e) {
            throw new PermanentBackendException("Failed to instantiate keyspace metadata for " + keyspaceName, (Throwable)e);
        }
        try {
            MigrationManager.announceNewKeyspace((KSMetaData)ksm);
            log.info("Created keyspace {}", (Object)keyspaceName);
        }
        catch (ConfigurationException e) {
            throw new PermanentBackendException("Failed to create keyspace " + keyspaceName, (Throwable)e);
        }
    }

    private void ensureColumnFamilyExists(String ksName, String cfName) throws BackendException {
        this.ensureColumnFamilyExists(ksName, cfName, (AbstractType<?>)BytesType.instance);
    }

    private void ensureColumnFamilyExists(String keyspaceName, String columnfamilyName, AbstractType<?> comparator) throws BackendException {
        CompressionParameters cp;
        if (null != Schema.instance.getCFMetaData(keyspaceName, columnfamilyName)) {
            return;
        }
        CFMetaData cfm = new CFMetaData(keyspaceName, columnfamilyName, ColumnFamilyType.Standard, CellNames.fromAbstractType(comparator, (boolean)true));
        try {
            if (this.storageConfig.has(COMPACTION_STRATEGY, new String[0])) {
                cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy((String)((String)this.storageConfig.get(COMPACTION_STRATEGY, new String[0]))));
            }
            if (!this.compactionOptions.isEmpty()) {
                cfm.compactionStrategyOptions(this.compactionOptions);
            }
        }
        catch (ConfigurationException e) {
            throw new PermanentBackendException("Failed to create column family metadata for " + keyspaceName + ":" + columnfamilyName, (Throwable)e);
        }
        if (columnfamilyName.startsWith("edgestore")) {
            cfm.caching(CachingOptions.KEYS_ONLY);
        } else if (columnfamilyName.startsWith("graphindex")) {
            cfm.caching(CachingOptions.ROWS_ONLY);
        }
        if (this.compressionEnabled) {
            try {
                cp = new CompressionParameters(this.compressionClass, Integer.valueOf(this.compressionChunkSizeKB * 1024), Collections.emptyMap());
                log.debug("Creating CF {}: setting {}={} and {}={} on {}", new Object[]{columnfamilyName, "sstable_compression", this.compressionClass, "chunk_length_kb", this.compressionChunkSizeKB, cp});
            }
            catch (ConfigurationException ce) {
                throw new PermanentBackendException((Throwable)ce);
            }
        } else {
            cp = new CompressionParameters(null);
            log.debug("Creating CF {}: setting {} to null to disable compression", (Object)columnfamilyName, (Object)"sstable_compression");
        }
        cfm.compressionParameters(cp);
        try {
            cfm.addDefaultIndexNames();
        }
        catch (ConfigurationException e) {
            throw new PermanentBackendException("Failed to create column family metadata for " + keyspaceName + ":" + columnfamilyName, (Throwable)e);
        }
        try {
            MigrationManager.announceNewColumnFamily((CFMetaData)cfm);
            log.info("Created CF {} in KS {}", (Object)columnfamilyName, (Object)keyspaceName);
        }
        catch (ConfigurationException e) {
            throw new PermanentBackendException("Failed to create column family " + keyspaceName + ":" + columnfamilyName, (Throwable)e);
        }
        this.retryDummyRead(keyspaceName, columnfamilyName);
    }

    @Override
    public Map<String, String> getCompressionOptions(String cf) throws BackendException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keySpaceName, cf);
        if (cfm == null) {
            return null;
        }
        return ImmutableMap.copyOf((Map)cfm.compressionParameters().asThriftOptions());
    }

    private void retryDummyRead(String ks, String cf) throws PermanentBackendException {
        long limit = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < limit) {
            try {
                TreeSet<CellName> names = new TreeSet<CellName>(new Comparator<CellName>(){

                    @Override
                    public int compare(CellName o1, CellName o2) {
                        return 0;
                    }
                });
                names.add(CellNames.simpleDense((ByteBuffer)ByteBufferUtil.zeroByteBuffer((int)1)));
                NamesQueryFilter nqf = new NamesQueryFilter(names);
                SliceByNamesReadCommand cmd = new SliceByNamesReadCommand(ks, ByteBufferUtil.zeroByteBuffer((int)1), cf, 1L, nqf);
                StorageProxy.read((List)ImmutableList.of((Object)cmd), (ConsistencyLevel)ConsistencyLevel.QUORUM);
                log.info("Read on CF {} in KS {} succeeded", (Object)cf, (Object)ks);
                return;
            }
            catch (Throwable t) {
                log.warn("Failed to read CF {} in KS {} following creation", new Object[]{cf, ks, t});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new PermanentBackendException((Throwable)e);
                }
            }
        }
        throw new PermanentBackendException("Timed out while attempting to read CF " + cf + " in KS " + ks + " following creation");
    }
}

