/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jamon.compiler.RecompilingTemplateManager;
import org.jamon.util.ExternalJavaCompiler;
import org.jamon.util.InternalJavaCompiler;
import org.jamon.util.Java6Compiler;
import org.jamon.util.JavaCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompilerFactory {
    public static JavaCompiler makeCompiler(RecompilingTemplateManager.Data p_data, String p_workDir, ClassLoader p_classLoader) {
        String javac = p_data.getJavaCompiler();
        List<String> compilerArgs = JavaCompilerFactory.getCompilerArgs(p_data, p_workDir, p_classLoader);
        if (javac == null) {
            try {
                Class.forName("javax.tools.JavaCompiler");
                return new Java6Compiler(compilerArgs);
            }
            catch (Exception e1) {
                try {
                    return new InternalJavaCompiler(compilerArgs);
                }
                catch (Exception e2) {
                    javac = JavaCompilerFactory.getDefaultJavac();
                }
            }
        }
        return new ExternalJavaCompiler(javac, compilerArgs);
    }

    private static List<String> getCompilerArgs(RecompilingTemplateManager.Data p_data, String p_workDir, ClassLoader p_classLoader) {
        return Collections.unmodifiableList(Arrays.asList("-classpath", JavaCompilerFactory.getClasspath(p_workDir, p_data.getClasspath(), p_classLoader)));
    }

    static String getDefaultJavac() {
        String bindir = "Mac OS X".equals(System.getProperty("os.name")) ? "Commands" : "bin";
        String javaHomeParent = new File(System.getProperty("java.home")).getParent();
        return new File(new File(javaHomeParent, bindir), "javac").getAbsolutePath();
    }

    private static void extractClasspath(ClassLoader p_classLoader, StringBuilder p_classpath) {
        if (p_classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)p_classLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i].toExternalForm();
                if (!url.startsWith("file:")) continue;
                p_classpath.append(File.pathSeparator);
                p_classpath.append(url.substring(5));
            }
        }
        if (p_classLoader.getParent() != null) {
            JavaCompilerFactory.extractClasspath(p_classLoader.getParent(), p_classpath);
        }
    }

    private static String getClasspath(String p_start, String p_classpath, ClassLoader p_classLoader) {
        StringBuilder cp = new StringBuilder(p_start);
        if (p_classpath != null) {
            cp.append(File.pathSeparator);
            cp.append(p_classpath);
        }
        JavaCompilerFactory.extractClasspath(p_classLoader, cp);
        cp.append(File.pathSeparator);
        cp.append(System.getProperty("sun.boot.class.path"));
        cp.append(File.pathSeparator);
        cp.append(System.getProperty("java.class.path"));
        JavaCompilerFactory.pruneJniLibs(cp);
        if (RecompilingTemplateManager.TRACE) {
            RecompilingTemplateManager.trace("Jamon compilation CLASSPATH is " + cp);
        }
        return cp.toString();
    }

    private static void pruneJniLibs(StringBuilder cp) {
        String[] components = cp.toString().split(File.pathSeparator);
        cp.delete(0, cp.length());
        boolean first = true;
        for (String c : components) {
            if (c.endsWith(".jnilib") || c.endsWith(".dylib")) continue;
            if (!first) {
                cp.append(File.pathSeparator);
            }
            first = false;
            cp.append(c);
        }
    }
}

