/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jamon.util.JavaCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalJavaCompiler
implements JavaCompiler {
    private final List<String> m_compilerArgs;
    private final Method m_compile;
    private final Class<? extends Object> m_compilerClass;
    private Object m_compiler;

    public InternalJavaCompiler(List<String> p_compilerArgs) throws Exception {
        this.m_compilerArgs = p_compilerArgs;
        this.m_compilerClass = this.getClass().getClassLoader().loadClass("com.sun.tools.javac.Main");
        this.m_compiler = this.m_compilerClass.newInstance();
        this.m_compile = this.m_compilerClass.getMethod("compile", new String[0].getClass());
        this.m_compile.invoke(this.m_compiler, new Object[]{new String[]{"-version"}});
    }

    @Override
    public String compile(String[] p_javaFiles) {
        String[] cmdline = new String[p_javaFiles.length + this.m_compilerArgs.size()];
        this.m_compilerArgs.toArray(cmdline);
        System.arraycopy(p_javaFiles, 0, cmdline, this.m_compilerArgs.size(), p_javaFiles.length);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream pErr = new PrintStream(err);
        PrintStream oldErr = System.err;
        try {
            if (this.m_compiler == null) {
                this.m_compiler = this.m_compilerClass.newInstance();
            }
            System.setErr(new PrintStream(err));
            int code = (Integer)this.m_compile.invoke(this.m_compiler, new Object[]{cmdline});
            pErr.close();
            String string = code == 0 ? null : new String(err.toByteArray());
            return string;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.m_compiler = null;
            throw new RuntimeException(e.getTargetException());
        }
        finally {
            System.setErr(oldErr);
        }
    }
}

