/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jamon.api.TemplateLocation;
import org.jamon.api.TemplateSource;
import org.jamon.compiler.TemplateFileLocation;

public class FileTemplateSource
implements TemplateSource {
    private final File m_templateSourceDir;
    private final String m_extension;

    public FileTemplateSource(String p_templateSourceDir) {
        this(new File(p_templateSourceDir));
    }

    public FileTemplateSource(File p_templateSourceDir) {
        this(p_templateSourceDir, "jamon");
    }

    public FileTemplateSource(File p_templateSourceDir, String p_extension) {
        this.m_templateSourceDir = p_templateSourceDir;
        this.m_extension = p_extension == null || p_extension.length() == 0 ? "" : "." + p_extension;
    }

    public long lastModified(String p_templatePath) {
        return this.getTemplateFile(p_templatePath).lastModified();
    }

    public boolean available(String p_templatePath) {
        return this.getTemplateFile(p_templatePath).exists();
    }

    public InputStream getStreamFor(String p_templatePath) throws IOException {
        return new FileInputStream(this.getTemplateFile(p_templatePath));
    }

    public String getExternalIdentifier(String p_templatePath) {
        return this.getTemplateFile(p_templatePath).getAbsolutePath();
    }

    private File getTemplateFile(String p_templatePath) {
        return new File(this.m_templateSourceDir, FileTemplateSource.templatePathToFilePath(p_templatePath) + this.m_extension);
    }

    private static String templatePathToFilePath(String p_path) {
        if (File.separatorChar == '/') {
            return p_path;
        }
        StringTokenizer tokenizer = new StringTokenizer(p_path, "/");
        StringBuilder path = new StringBuilder(p_path.length());
        while (tokenizer.hasMoreTokens()) {
            path.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            path.append(File.separator);
        }
        return path.toString();
    }

    public TemplateLocation getTemplateLocation(String p_templatePath) {
        return new TemplateFileLocation(this.getExternalIdentifier(p_templatePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String p_path, Properties p_properties) throws IOException {
        File propertiesFile = new File(this.m_templateSourceDir, FileTemplateSource.templatePathToFilePath(p_path + "/jamon.properties"));
        if (propertiesFile.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(propertiesFile);
            try {
                p_properties.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
    }
}

