/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.statistics.support;

import java.util.Date;
import javax.sql.DataSource;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.statistics.StatisticActionContext;
import org.inspektr.statistics.annotation.Statistic;
import org.inspektr.statistics.support.AbstractThreadExecutorBasedStatisticManager;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public final class JdbcStatisticManager
extends AbstractThreadExecutorBasedStatisticManager {
    private static final String UPDATE_STATISTIC = "Update COM_STATISTICS Set STAT_COUNT = STAT_COUNT + 1 WHERE STAT_SERVER_IP = ? AND STAT_DATE = ? AND APPLIC_CD = ? AND STAT_PRECISION = ? AND STAT_NAME = ?";
    private static final String INSERT_STATISTIC = "Insert into COM_STATISTICS(STAT_SERVER_IP, STAT_DATE, APPLIC_CD, STAT_PRECISION, STAT_COUNT, STAT_NAME) VALUES(?, ?, ?, ?, 1, ?)";
    @NotNull
    private final SimpleJdbcTemplate jdbcTemplate;
    @NotNull
    private final TransactionTemplate transactionTemplate;

    public JdbcStatisticManager(DataSource dataSource, TransactionTemplate transactionTemplate) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.transactionTemplate = transactionTemplate;
    }

    protected Runnable newTask(StatisticActionContext statisticActionContext) {
        return new JdbcStatisticGatheringTask(this.jdbcTemplate, this.transactionTemplate, statisticActionContext);
    }

    protected static final class JdbcStatisticGatheringTask
    implements Runnable {
        private final TransactionTemplate transactionTemplate;
        private final SimpleJdbcTemplate jdbcTemplate;
        private final StatisticActionContext statisticActionContext;

        public JdbcStatisticGatheringTask(SimpleJdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, StatisticActionContext context) {
            this.transactionTemplate = transactionTemplate;
            this.jdbcTemplate = jdbcTemplate;
            this.statisticActionContext = context;
        }

        public void run() {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    for (Statistic.Precision precision : JdbcStatisticGatheringTask.this.statisticActionContext.getRequiredPrecision()) {
                        Date date = precision.normalize(JdbcStatisticGatheringTask.this.statisticActionContext.getWhen());
                        String name = JdbcStatisticGatheringTask.this.statisticActionContext.getWhat();
                        String applicationCode = JdbcStatisticGatheringTask.this.statisticActionContext.getApplicationCode();
                        String serverIpAddress = JdbcStatisticGatheringTask.this.statisticActionContext.getServerIpAddress();
                        int updateCount = JdbcStatisticGatheringTask.this.jdbcTemplate.update(JdbcStatisticManager.UPDATE_STATISTIC, new Object[]{serverIpAddress, date, applicationCode, precision.name(), name});
                        if (updateCount != 0) continue;
                        JdbcStatisticGatheringTask.this.jdbcTemplate.update(JdbcStatisticManager.INSERT_STATISTIC, new Object[]{serverIpAddress, date, applicationCode, precision.name(), name});
                    }
                }
            });
        }
    }
}

