/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.statistics.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.statistics.StatisticActionContext;
import org.inspektr.statistics.annotation.Statistic;
import org.inspektr.statistics.support.AbstractThreadExecutorBasedStatisticManager;

public final class InMemoryStatisticManager
extends AbstractThreadExecutorBasedStatisticManager {
    private static final Log LOG = LogFactory.getLog(InMemoryStatisticManager.class);
    @NotNull
    private final List<StatisticValue> values = new ArrayList<StatisticValue>();

    protected Runnable newTask(StatisticActionContext statisticActionContext) {
        return new StatisticGatheringTask(statisticActionContext, this.values);
    }

    protected static final class StatisticValue {
        private final Statistic.Precision precision;
        private final Date date;
        private int count;
        private final String name;

        public StatisticValue(Statistic.Precision precision, Date date, String name) {
            this.precision = precision;
            this.date = precision.normalize(date);
            this.name = name;
            this.count = 1;
        }

        public void increment() {
            ++this.count;
        }

        public boolean matches(Date date, Statistic.Precision precision, String name) {
            return precision.same(this.date, date) && this.precision == precision && this.name.equals(name);
        }

        public Statistic.Precision getPrecision() {
            return this.precision;
        }

        public Date getDate() {
            return this.date;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "name=[" + this.name + "],date=[" + this.date + "],precision=[" + (Object)((Object)this.precision) + "],count=[" + this.count + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class StatisticGatheringTask
    implements Runnable {
        private final StatisticActionContext context;
        private final List<StatisticValue> values;

        public StatisticGatheringTask(StatisticActionContext context, List<StatisticValue> values) {
            this.context = context;
            this.values = values;
        }

        @Override
        public void run() {
            for (Statistic.Precision precision : this.context.getRequiredPrecision()) {
                boolean matched = false;
                for (StatisticValue value : this.values) {
                    if (!value.matches(this.context.getWhen(), precision, this.context.getWhat())) continue;
                    value.increment();
                    matched = true;
                    LOG.info((Object)value.toString());
                    break;
                }
                if (matched) continue;
                StatisticValue value = new StatisticValue(precision, this.context.getWhen(), this.context.getWhat());
                LOG.info((Object)value.toString());
                this.values.add(value);
            }
        }
    }
}

