/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.error.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.error.ErrorReporter;

public final class CommonsLoggingErrorReporter
implements ErrorReporter {
    private final Log log = LogFactory.getLog(this.getClass());

    public void reportError(String applicationCode, String principal, String description) {
        this.logErrorRecord(applicationCode, principal, description);
    }

    public void reportError(String applicationCode, String principal, Throwable throwable) {
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        StringBuilder builder = new StringBuilder(512);
        builder.append("\n\t").append(throwable.toString());
        for (StackTraceElement element : stackTraceElements) {
            builder.append("\n\tat ").append(element.toString());
        }
        this.logErrorRecord(applicationCode, principal, builder.toString());
    }

    private void logErrorRecord(String applicationCode, String principal, String details) {
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        StringBuilder builder = new StringBuilder(512);
        builder.append("\n\n===ERROR LOG record BEGIN==========================================").append("\nAPPLICATION CODE: " + applicationCode).append("\nPRINCIPAL: " + principal).append("\nWHEN: " + datetimeFormat.format(new Date())).append("\nDESCRIPTION: " + details).append("\n===ERROR LOG record END============================================").append("\n\n");
        this.log.error((Object)builder.toString());
    }
}

