/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.audit;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.inspektr.audit.AuditTrailManager;
import org.inspektr.audit.AuditableActionContext;
import org.inspektr.audit.annotation.Auditable;
import org.inspektr.audit.spi.AuditableActionResolver;
import org.inspektr.audit.spi.AuditablePrincipalResolver;
import org.inspektr.audit.spi.AuditableResourceResolver;
import org.inspektr.audit.spi.support.BooleanAuditableActionResolver;
import org.inspektr.audit.spi.support.DefaultAuditableActionResolver;
import org.inspektr.audit.spi.support.ObjectCreationAuditableActionResolver;
import org.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.common.spi.ClientInfoResolver;
import org.inspektr.common.spi.support.DefaultClientInfoResolver;
import org.inspektr.common.web.ClientInfo;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public final class AuditTrailManagementAspect {
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private final AuditablePrincipalResolver auditablePrincipalResolver;
    @NotEmpty
    private final Map<Class<? extends AuditableActionResolver>, AuditableActionResolver> auditableActionResolvers = new HashMap<Class<? extends AuditableActionResolver>, AuditableActionResolver>();
    @NotEmpty
    private final Map<Class<? extends AuditableResourceResolver>, AuditableResourceResolver> auditableResourceResolvers = new HashMap<Class<? extends AuditableResourceResolver>, AuditableResourceResolver>();
    @NotEmpty
    private final List<AuditTrailManager> auditTrailManagers;
    @NotNull
    private final String applicationCode;
    @NotNull
    private ClientInfoResolver clientInfoResolver = new DefaultClientInfoResolver();

    public AuditTrailManagementAspect(AuditablePrincipalResolver auditablePrincipalResolver, List<AuditableResourceResolver> auditableResourceResolvers, List<AuditTrailManager> auditTrailManagers, String applicationCode) {
        this.auditablePrincipalResolver = auditablePrincipalResolver;
        this.auditTrailManagers = auditTrailManagers;
        this.auditableActionResolvers.put(DefaultAuditableActionResolver.class, new DefaultAuditableActionResolver());
        this.auditableActionResolvers.put(BooleanAuditableActionResolver.class, new BooleanAuditableActionResolver());
        this.auditableActionResolvers.put(ObjectCreationAuditableActionResolver.class, new ObjectCreationAuditableActionResolver());
        this.applicationCode = applicationCode;
        for (AuditableResourceResolver resolver : auditableResourceResolvers) {
            this.auditableResourceResolvers.put(resolver.getClass(), resolver);
        }
        this.auditableResourceResolvers.put(ReturnValueAsStringResourceResolver.class, new ReturnValueAsStringResourceResolver());
    }

    @Around(value="@annotation(auditable)", argNames="auditable")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Auditable auditable) throws Throwable {
        Object object;
        block15: {
            Object retVal;
            String action;
            String auditableResource;
            String currentPrincipal;
            block14: {
                currentPrincipal = null;
                auditableResource = null;
                action = null;
                retVal = null;
                try {
                    retVal = joinPoint.proceed();
                    currentPrincipal = this.auditablePrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                    if (currentPrincipal != null) {
                        auditableResource = this.auditableResourceResolvers.get(auditable.resourceResolverClass()).resolveFrom((JoinPoint)joinPoint, retVal);
                        action = this.auditableActionResolvers.get(auditable.actionResolverClass()).resolveFrom((JoinPoint)joinPoint, retVal, auditable);
                    }
                    object = retVal;
                    Object var9_9 = null;
                    if (currentPrincipal != null) break block14;
                }
                catch (Exception e) {
                    try {
                        currentPrincipal = this.auditablePrincipalResolver.resolveFrom((JoinPoint)joinPoint, e);
                        if (currentPrincipal != null) {
                            auditableResource = this.auditableResourceResolvers.get(auditable.resourceResolverClass()).resolveFrom((JoinPoint)joinPoint, e);
                            action = this.auditableActionResolvers.get(auditable.actionResolverClass()).resolveFrom((JoinPoint)joinPoint, e, auditable);
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (currentPrincipal == null) {
                            this.log.warn((Object)"Recording of audit trail information did not succeed: cannot resolve the principal.");
                        } else if (auditableResource == null) {
                            this.log.warn((Object)"Recording of audit trail information did not succeed: cannot resolve the auditable resource.");
                        } else {
                            String applicationCode = StringUtils.hasText((String)auditable.applicationCode()) ? auditable.applicationCode() : this.applicationCode;
                            ClientInfo clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                            AuditableActionContext auditContext = new AuditableActionContext(currentPrincipal, auditableResource, action, applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
                            for (AuditTrailManager manager : this.auditTrailManagers) {
                                manager.record(auditContext);
                            }
                        }
                        throw throwable;
                    }
                }
                this.log.warn((Object)"Recording of audit trail information did not succeed: cannot resolve the principal.");
                break block15;
            }
            if (auditableResource == null) {
                this.log.warn((Object)"Recording of audit trail information did not succeed: cannot resolve the auditable resource.");
            } else {
                String applicationCode = StringUtils.hasText((String)auditable.applicationCode()) ? auditable.applicationCode() : this.applicationCode;
                ClientInfo clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                AuditableActionContext auditContext = new AuditableActionContext(currentPrincipal, auditableResource, action, applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
                for (AuditTrailManager manager : this.auditTrailManagers) {
                    manager.record(auditContext);
                }
            }
        }
        return object;
    }

    public void setAdditionalAuditableActionResolvers(List<AuditableActionResolver> auditableActionResolvers) {
        for (AuditableActionResolver resolver : auditableActionResolvers) {
            this.auditableActionResolvers.put(resolver.getClass(), resolver);
        }
    }

    public void setClientInfoResolver(ClientInfoResolver factory) {
        this.clientInfoResolver = factory;
    }
}

