/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.expands.compress.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.commons.IOUtils;

public class ZIPWriter {
    private List<ZipFileSteam> zipFileDatas = new ArrayList<ZipFileSteam>();
    private List<ZipFileFile> zipFileFiles = new ArrayList<ZipFileFile>();
    private int compressLevel = -1;

    public ZIPWriter level(int compressLevel) {
        this.compressLevel = compressLevel;
        return this;
    }

    public ZIPWriter addTextFile(String fileName, String text) {
        this.zipFileDatas.add(new ZipFileSteam(fileName, new ByteArrayInputStream(text.getBytes())));
        return this;
    }

    private void addDir(String prefix, String rootName, File dir) throws FileNotFoundException {
        for (File file : dir.listFiles()) {
            String fileName = file.getAbsolutePath();
            fileName = fileName.substring(fileName.indexOf(prefix) + prefix.length(), fileName.length());
            if (file.isDirectory()) {
                this.addDir(prefix, rootName, file);
                continue;
            }
            this.addFile(rootName + fileName, file);
        }
    }

    public ZIPWriter addDir(File dir) throws FileNotFoundException {
        this.addDir(dir.getAbsolutePath(), dir.getName(), dir);
        return this;
    }

    public ZIPWriter addFile(String fileName, File file) throws FileNotFoundException {
        this.zipFileFiles.add(new ZipFileFile(fileName, file));
        return this;
    }

    public ZIPWriter addFile(String fileName, InputStream inputStream) {
        this.zipFileDatas.add(new ZipFileSteam(fileName, inputStream));
        return this;
    }

    public void write(OutputStream outputStream) {
        try (ZipOutputStream out = new ZipOutputStream(outputStream);){
            out.setLevel(this.compressLevel);
            ArrayList zipEntrySources = this.zipFileDatas.isEmpty() ? new ArrayList() : this.zipFileDatas.stream().map(ZipFileSteam::create).collect(Collectors.toList());
            for (ZipEntrySource zipEntrySource : zipEntrySources) {
                this.addEntry(zipEntrySource, out);
            }
            out.flush();
            out.finish();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(ZipEntrySource entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry.getEntry());
        InputStream in = entry.getInputStream();
        if (in != null) {
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        out.closeEntry();
    }

    class ZipFileFile {
        private String name;
        private File file;

        public ZipFileFile(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public ZipEntrySource create() {
            FileSource zipEntrySource = new FileSource(this.name, this.file);
            return zipEntrySource;
        }
    }

    class ZipFileSteam {
        private String name;
        private InputStream inputStream;

        public ZipFileSteam(String name, InputStream inputStream) {
            this.name = name;
            this.inputStream = inputStream;
        }

        public ZipEntrySource create() {
            ByteSource zipEntrySource;
            try (InputStream in = this.inputStream;){
                zipEntrySource = new ByteSource(this.name, IOUtils.toByteArray((InputStream)in));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return zipEntrySource;
        }
    }
}

