/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.server;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.NodeManager;
import org.hornetq.utils.UUIDGenerator;

public class InVMNodeManager
extends NodeManager {
    private final Semaphore liveLock;
    private final Semaphore backupLock;
    public State state = State.NOT_STARTED;

    public InVMNodeManager(boolean replicatedBackup, String directory) {
        super(replicatedBackup, directory);
        this.liveLock = new Semaphore(1);
        this.backupLock = new Semaphore(1);
        this.setUUID(UUIDGenerator.getInstance().generateUUID());
    }

    public void awaitLiveNode() throws Exception {
        while (true) {
            if (this.state == State.NOT_STARTED) {
                Thread.sleep(2000L);
                continue;
            }
            this.liveLock.acquire();
            if (this.state == State.PAUSED) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.FAILING_BACK) {
                this.liveLock.release();
                Thread.sleep(2000L);
                continue;
            }
            if (this.state == State.LIVE) break;
        }
    }

    public void startBackup() throws Exception {
        this.backupLock.acquire();
    }

    public void startLiveNode() throws Exception {
        this.state = State.FAILING_BACK;
        this.liveLock.acquire();
        this.state = State.LIVE;
    }

    public void pauseLiveServer() throws Exception {
        this.state = State.PAUSED;
        this.liveLock.release();
    }

    public void crashLiveServer() throws Exception {
        this.state = State.LIVE;
        this.liveLock.release();
    }

    public void releaseBackup() {
        if (this.backupLock != null) {
            this.backupLock.release();
        }
    }

    public boolean isAwaitingFailback() throws Exception {
        return this.state == State.FAILING_BACK;
    }

    public boolean isBackupLive() throws Exception {
        return this.liveLock.availablePermits() == 0;
    }

    public void interrupt() {
    }

    public SimpleString readNodeId() throws HornetQIllegalStateException, IOException {
        return this.getNodeId();
    }

    public static enum State {
        LIVE,
        PAUSED,
        FAILING_BACK,
        NOT_STARTED;

    }
}

