/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.server;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.hornetq.maven.InVMNodeManagerServer;
import org.hornetq.server.InVMNodeManager;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.spi.core.security.HornetQSecurityManagerImpl;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;
import org.jnp.server.NamingBeanImpl;

public class HornetQBootstrap {
    private final Boolean useJndi;
    private final String jndiHost;
    private final int jndiPort;
    private final int jndiRmiPort;
    private final String hornetqConfigurationDir;
    private final Boolean waitOnStart;
    private final String nodeId;
    private static Map<String, NodeManager> managerMap = new HashMap<String, NodeManager>();
    private boolean spawned = false;
    private Main main;
    private NamingBeanImpl namingBean;
    private HornetQServer server;
    private Configuration configuration;
    private JMSServerManager manager;
    private HornetQSecurityManager securityManager;

    public HornetQBootstrap(Boolean useJndi, String jndiHost, int jndiPort, int jndiRmiPort, String hornetqConfigurationDir, Boolean waitOnStart, String nodeId, HornetQSecurityManager securityManager) {
        this.useJndi = useJndi;
        this.jndiHost = jndiHost;
        this.jndiPort = jndiPort;
        this.jndiRmiPort = jndiRmiPort;
        this.hornetqConfigurationDir = hornetqConfigurationDir;
        this.waitOnStart = waitOnStart;
        this.nodeId = nodeId;
        this.securityManager = securityManager;
    }

    public HornetQBootstrap(String[] args) {
        this.useJndi = Boolean.valueOf(args[0]);
        this.jndiHost = args[1];
        this.jndiPort = Integer.valueOf(args[2]);
        this.jndiRmiPort = Integer.valueOf(args[3]);
        this.hornetqConfigurationDir = args[4];
        this.waitOnStart = Boolean.valueOf(args[5]);
        this.nodeId = args[6];
        this.spawned = true;
    }

    public void execute() throws Exception {
        try {
            String dirName;
            System.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            System.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            if (this.useJndi.booleanValue()) {
                this.createNamingServer();
            }
            if (this.hornetqConfigurationDir != null) {
                this.configuration = new FileConfiguration();
                File file = new File(this.hornetqConfigurationDir + "/" + "hornetq-configuration.xml");
                ((FileConfiguration)this.configuration).setConfigurationUrl(file.toURI().toURL().toExternalForm());
                ((FileConfiguration)this.configuration).start();
            } else {
                this.configuration = new ConfigurationImpl();
                this.configuration.setJournalType(JournalType.NIO);
            }
            this.createServer(this.configuration);
            if (this.waitOnStart.booleanValue()) {
                dirName = System.getProperty("hornetq.config.dir", ".");
                File file = new File(dirName + "/STOP_ME");
                if (file.exists()) {
                    file.delete();
                }
                while (!file.exists()) {
                    Thread.sleep(500L);
                }
                this.manager.stop();
                if (this.main != null) {
                    this.main.stop();
                }
                file.delete();
            } else {
                File restartFile;
                File killFile;
                dirName = this.hornetqConfigurationDir != null ? this.hornetqConfigurationDir : ".";
                File stopFile = new File(dirName + "/STOP_ME");
                if (stopFile.exists()) {
                    stopFile.delete();
                }
                if ((killFile = new File(dirName + "/KILL_ME")).exists()) {
                    killFile.delete();
                }
                if ((restartFile = new File(dirName + "/RESTART_ME")).exists()) {
                    restartFile.delete();
                }
                Timer timer = new Timer("HornetQ Server Shutdown Timer", true);
                timer.scheduleAtFixedRate((TimerTask)new ServerStopTimerTask(stopFile, killFile, restartFile, timer), 500L, 500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void createServer(Configuration configuration) throws Exception {
        if (this.nodeId != null && !this.nodeId.equals("") && !this.nodeId.equals("null")) {
            InVMNodeManager nodeManager = (InVMNodeManager)managerMap.get(this.nodeId);
            if (nodeManager == null) {
                boolean replicatedBackup = configuration.isBackup() && !configuration.isSharedStore();
                nodeManager = new InVMNodeManager(replicatedBackup, configuration.getJournalDirectory());
                managerMap.put(this.nodeId, nodeManager);
            }
            this.server = new InVMNodeManagerServer(configuration, ManagementFactory.getPlatformMBeanServer(), (HornetQSecurityManager)(this.securityManager != null ? this.securityManager : new HornetQSecurityManagerImpl()), nodeManager);
        } else {
            this.server = new HornetQServerImpl(configuration, ManagementFactory.getPlatformMBeanServer(), (HornetQSecurityManager)(this.securityManager != null ? this.securityManager : new HornetQSecurityManagerImpl()));
        }
        this.manager = new JMSServerManagerImpl(this.server);
        this.manager.start();
    }

    private void createNamingServer() throws Exception {
        this.main = new Main();
        this.namingBean = new NamingBeanImpl();
        this.namingBean.start();
        this.main.setNamingInfo((NamingBean)this.namingBean);
        this.main.setBindAddress(this.jndiHost);
        this.main.setPort(this.jndiPort);
        this.main.setRmiBindAddress(this.jndiHost);
        this.main.setRmiPort(this.jndiRmiPort);
        this.main.start();
    }

    private class ServerStopTimerTask
    extends TimerTask {
        private final File stopFile;
        private final Timer timer;
        private final File killFile;
        private final File restartFile;

        public ServerStopTimerTask(File stopFile, File killFile, File restartFile, Timer timer) {
            this.stopFile = stopFile;
            this.killFile = killFile;
            this.restartFile = restartFile;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.stopFile.exists()) {
                try {
                    this.timer.cancel();
                }
                finally {
                    try {
                        if (HornetQBootstrap.this.manager != null) {
                            HornetQBootstrap.this.manager.stop();
                            HornetQBootstrap.this.manager = null;
                        }
                        HornetQBootstrap.this.server = null;
                        if (HornetQBootstrap.this.main != null) {
                            HornetQBootstrap.this.main.stop();
                            HornetQBootstrap.this.main = null;
                        }
                        this.stopFile.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (HornetQBootstrap.this.spawned) {
                    Runtime.getRuntime().halt(666);
                }
            } else if (this.killFile.exists()) {
                try {
                    HornetQBootstrap.this.manager.getHornetQServer().stop(true);
                    HornetQBootstrap.this.manager.stop();
                    HornetQBootstrap.this.manager = null;
                    HornetQBootstrap.this.server = null;
                    HornetQBootstrap.this.main.stop();
                    HornetQBootstrap.this.main = null;
                    HornetQBootstrap.this.namingBean.stop();
                    HornetQBootstrap.this.namingBean = null;
                    this.killFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.restartFile.exists()) {
                try {
                    if (HornetQBootstrap.this.useJndi.booleanValue()) {
                        HornetQBootstrap.this.createNamingServer();
                    }
                    HornetQBootstrap.this.createServer(HornetQBootstrap.this.configuration);
                    this.restartFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

