/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.javafx;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PackageTranslator;

public class JavaFXType
implements ClientType {
    public static final JavaFXType BOOLEAN = new JavaFXType(null, "boolean", false);
    public static final JavaFXType INT = new JavaFXType(null, "int", 0);
    public static final JavaFXType LONG = new JavaFXType(null, "long", 0L);
    public static final JavaFXType FLOAT = new JavaFXType(null, "float", Float.valueOf(0.0f));
    public static final JavaFXType DOUBLE = new JavaFXType(null, "double", 0.0);
    public static final JavaFXType STRING = new JavaFXType(null, "String", null);
    public static final JavaFXType LOCALDATE = new JavaFXType("java.time", "LocalDate", null);
    public static final JavaFXType LOCALDATETIME = new JavaFXType("java.time", "LocalDateTime", null);
    public static final JavaFXType LOCALTIME = new JavaFXType("java.time", "LocalTime", null);
    public static final JavaFXType PAGE_INFO = new JavaFXType("org.granite.tide.data.model", "PageInfo", null);
    public static final JavaFXType SORT_INFO = new JavaFXType("org.granite.tide.data.model", "SortInfo", null);
    public static final JavaFXType LAZY = new JavaFXType("org.granite.client.persistence", "Lazy", null);
    public static final JavaFXType BOOLEAN_PROPERTY = new JavaFXType(null, "boolean", "javafx.beans.property.BooleanProperty", "javafx.beans.property.SimpleBooleanProperty", Boolean.FALSE);
    public static final JavaFXType INT_PROPERTY = new JavaFXType(null, "int", "javafx.beans.property.IntegerProperty", "javafx.beans.property.SimpleIntegerProperty", 0);
    public static final JavaFXType LONG_PROPERTY = new JavaFXType(null, "long", "javafx.beans.property.LongProperty", "javafx.beans.property.SimpleLongProperty", 0L);
    public static final JavaFXType FLOAT_PROPERTY = new JavaFXType(null, "float", "javafx.beans.property.FloatProperty", "javafx.beans.property.SimpleFloatProperty", Float.valueOf(0.0f));
    public static final JavaFXType DOUBLE_PROPERTY = new JavaFXType(null, "double", "javafx.beans.property.DoubleProperty", "javafx.beans.property.SimpleDoubleProperty", 0.0);
    public static final JavaFXType STRING_PROPERTY = new JavaFXType(null, "String", "javafx.beans.property.StringProperty", "javafx.beans.property.SimpleStringProperty", null);
    public static final JavaFXType LOCALDATE_PROPERTY = new JavaFXType("java.time", "LocalDate", "javafx.beans.property.ObjectProperty<LocalDate>", "javafx.beans.property.SimpleObjectProperty<LocalDate>", null);
    public static final JavaFXType LOCALDATETIME_PROPERTY = new JavaFXType("java.time", "LocalDateTime", "javafx.beans.property.ObjectProperty<LocalDateTime>", "javafx.beans.property.SimpleObjectProperty<LocalDateTime>", null);
    public static final JavaFXType LOCALTIME_PROPERTY = new JavaFXType("java.time", "LocalTime", "javafx.beans.property.ObjectProperty<LocalTime>", "javafx.beans.property.SimpleObjectProperty<LocalTime>", null);
    public static final JavaFXType BOOLEAN_READONLY_PROPERTY = new JavaFXType(null, "boolean", "javafx.beans.property.ReadOnlyBooleanProperty", "javafx.beans.property.ReadOnlyBooleanWrapper", null, Boolean.FALSE, true);
    public static final JavaFXType INT_READONLY_PROPERTY = new JavaFXType(null, "int", "javafx.beans.property.ReadOnlyIntegerProperty", "javafx.beans.property.ReadOnlyIntegerWrapper", null, 0, true);
    public static final JavaFXType LONG_READONLY_PROPERTY = new JavaFXType(null, "long", "javafx.beans.property.ReadOnlyLongProperty", "javafx.beans.property.ReadOnlyLongWrapper", null, 0L, true);
    public static final JavaFXType FLOAT_READONLY_PROPERTY = new JavaFXType(null, "float", "javafx.beans.property.ReadOnlyFloatProperty", "javafx.beans.property.ReadOnlyFloatWrapper", null, Float.valueOf(0.0f), true);
    public static final JavaFXType DOUBLE_READONLY_PROPERTY = new JavaFXType(null, "double", "javafx.beans.property.ReadOnlyDoubleProperty", "javafx.beans.property.ReadOnlyDoubleWrapper", null, 0.0, true);
    public static final JavaFXType STRING_READONLY_PROPERTY = new JavaFXType(null, "String", "javafx.beans.property.ReadOnlyStringProperty", "javafx.beans.property.ReadOnlyStringWrapper", null, null, true);
    public static final JavaFXType LOCALDATE_READONLY_PROPERTY = new JavaFXType("java.time", "LocalDate", "javafx.beans.property.ReadOnlyObjectProperty<LocalDate>", "javafx.beans.property.ReadOnlyObjectWrapper<LocalDate>", null);
    public static final JavaFXType LOCALDATETIME_READONLY_PROPERTY = new JavaFXType("java.time", "LocalDateTime", "javafx.beans.property.ReadOnlyObjectProperty<LocalDateTime>", "javafx.beans.property.ReadOnlyObjectWrapper<LocalDateTime>", null);
    public static final JavaFXType LOCALTIME_READONLY_PROPERTY = new JavaFXType("java.time", "LocalTime", "javafx.beans.property.ReadOnlyObjectProperty<LocalTime>", "javafx.beans.property.ReadOnlyObjectWrapper<LocalTime>", null);
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final String propertyTypeName;
    private final String propertyImplTypeName;
    private final String propertyFactoryName;
    private final Object nullValue;
    private final boolean readOnly;
    private final Set<String> imports = new HashSet<String>();

    public JavaFXType(String packageName, String simpleName) {
        this(packageName, simpleName, null);
    }

    public JavaFXType(String packageName, String name, Object nullValue) {
        this(packageName, name, null, null, nullValue);
    }

    public JavaFXType(String packageName, String name, String propertyTypeName, String propertyImplTypeName, Object nullValue) {
        this(packageName, name, propertyTypeName, propertyImplTypeName, null, nullValue, false);
    }

    public JavaFXType(String packageName, String name, String propertyTypeName, String propertyImplTypeName, String propertyFactoryName, Object nullValue, boolean readOnly) {
        this.packageName = packageName != null ? packageName : "";
        this.name = name;
        this.qualifiedName = this.hasPackage() ? packageName + '.' + name : name;
        this.nullValue = nullValue;
        this.propertyTypeName = propertyTypeName;
        this.propertyImplTypeName = propertyImplTypeName;
        this.propertyFactoryName = propertyFactoryName;
        this.readOnly = readOnly;
        if (this.hasPackage()) {
            this.imports.add(this.ungenerify(this.qualifiedName));
        }
        if (propertyTypeName != null) {
            this.imports.add(this.ungenerify(propertyTypeName));
        }
        if (propertyImplTypeName != null) {
            this.imports.add(this.ungenerify(propertyImplTypeName));
        }
    }

    @Override
    public boolean hasPackage() {
        return this.packageName.length() > 0;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPropertyTypeName() {
        return this.propertyTypeName;
    }

    public String getSimplePropertyTypeName() {
        return this.propertyTypeName != null && this.propertyTypeName.indexOf(".") >= 0 ? this.propertyTypeName.substring(this.propertyTypeName.lastIndexOf(".") + 1) : this.propertyTypeName;
    }

    public String getPropertyImplTypeName() {
        return this.propertyImplTypeName;
    }

    public String getSimplePropertyImplTypeName() {
        return this.propertyImplTypeName != null && this.propertyImplTypeName.indexOf(".") >= 0 ? this.propertyImplTypeName.substring(this.propertyImplTypeName.lastIndexOf(".") + 1) : this.propertyImplTypeName;
    }

    public String getPropertyFactoryName() {
        return this.propertyFactoryName != null ? this.propertyFactoryName : "new " + this.getSimplePropertyImplTypeName();
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public void addImports(Set<String> classNames) {
        for (String className : classNames) {
            if (className.indexOf(".") < 0 || className.startsWith("java.lang")) continue;
            this.imports.add(this.ungenerify(className));
        }
    }

    private String ungenerify(String className) {
        if (className.indexOf("<") >= 0) {
            return className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    @Override
    public JavaFXType toArrayType() {
        return new JavaFXType(this.packageName, this.name + "[]", null);
    }

    @Override
    public JavaFXType translatePackage(PackageTranslator translator) {
        return new JavaFXType(translator.translate(this.packageName), this.getName(), this.getPropertyTypeName(), this.getPropertyImplTypeName(), this.getPropertyFactoryName(), this.getNullValue(), this.isReadOnly());
    }

    @Override
    public JavaFXType translatePackages(List<PackageTranslator> translators) {
        boolean translate = false;
        PackageTranslator translator = PackageTranslator.forPackage(translators, this.packageName);
        String translatedPackageName = this.packageName;
        if (translator != null) {
            translate = true;
            translatedPackageName = translator.translate(this.packageName);
        }
        HashSet<String> translatedImports = new HashSet<String>();
        for (String imp : this.imports) {
            translator = PackageTranslator.forPackage(translators, imp);
            if (translator != null) {
                translate = true;
                translatedImports.add(translator.translate(imp));
                continue;
            }
            translatedImports.add(imp);
        }
        if (!translate) {
            return this;
        }
        JavaFXType translatedType = new JavaFXType(translatedPackageName, this.getName(), this.getPropertyTypeName(), this.getPropertyImplTypeName(), this.getPropertyFactoryName(), this.getNullValue(), this.isReadOnly());
        translatedType.addImports(translatedImports);
        return translatedType;
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JavaFXType)) {
            return false;
        }
        return this.qualifiedName.equals(((JavaFXType)obj).qualifiedName);
    }

    public String toString() {
        return this.qualifiedName;
    }
}

