/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.java;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PropertyType;
import org.granite.generator.java.JavaType;
import org.granite.generator.util.GenericTypeUtil;
import org.granite.tide.data.Lazy;
import org.granite.util.ClassUtil;

public class DefaultJavaTypeFactory
implements As3TypeFactory {
    private final Map<String, ClientType> simpleJava2JavaType = new HashMap<String, ClientType>();
    private final Map<String, ClientType> propertyJava2JavaType = new HashMap<String, ClientType>();

    public DefaultJavaTypeFactory() {
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Boolean.TYPE), JavaType.BOOLEAN);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Integer.TYPE), JavaType.INT);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Long.TYPE), JavaType.LONG);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Float.TYPE), JavaType.FLOAT);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Double.TYPE), JavaType.DOUBLE);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(String.class), JavaType.STRING);
        this.simpleJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Lazy.class), JavaType.LAZY);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Boolean.TYPE), JavaType.BOOLEAN);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Integer.TYPE), JavaType.INT);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Long.TYPE), JavaType.LONG);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Float.TYPE), JavaType.FLOAT);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(Double.TYPE), JavaType.DOUBLE);
        this.propertyJava2JavaType.put(DefaultJavaTypeFactory.buildCacheKey(String.class), JavaType.STRING);
    }

    @Override
    public void configure(boolean externalizeLong, boolean externalizeBigInteger, boolean externalizeBigDecimal) {
    }

    private static final String buildCacheKey(Type jType) {
        return DefaultJavaTypeFactory.buildCacheKey(jType, null, null);
    }

    private static final String buildCacheKey(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes) {
        String key = jType.toString();
        if (declaringClass != null) {
            key = key + "::" + declaringClass.toString();
        }
        if (declaringTypes != null) {
            for (ParameterizedType dt : declaringTypes) {
                key = key + "::" + dt.toString();
            }
        }
        return key;
    }

    @Override
    public ClientType getClientType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType) {
        String key = DefaultJavaTypeFactory.buildCacheKey(jType, declaringClass, declaringTypes);
        ClientType javaType = this.getFromCache(key, propertyType);
        if (javaType == null) {
            if (jType instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)jType).getGenericComponentType();
                javaType = this.getClientType(componentType, declaringClass, declaringTypes, PropertyType.SIMPLE).toArrayType();
            } else if (jType instanceof Class && ((Class)jType).isArray()) {
                javaType = this.getClientType(((Class)jType).getComponentType(), declaringClass, declaringTypes, PropertyType.SIMPLE).toArrayType();
            } else {
                HashSet<String> imports = new HashSet<String>();
                Class<?> jClass = ClassUtil.classOfType(jType);
                String genericType = "";
                if (jType instanceof ParameterizedType) {
                    genericType = this.buildGenericTypeName((ParameterizedType)jType, declaringClass, declaringTypes, propertyType, imports);
                }
                javaType = propertyType.isProperty() && List.class.isAssignableFrom(jClass) ? this.createJavaType(jType, declaringClass, declaringTypes, "org.granite.client.persistence.collection.PersistentList" + genericType, propertyType) : (propertyType.isProperty() && SortedSet.class.isAssignableFrom(jClass) ? this.createJavaType(jType, declaringClass, declaringTypes, "org.granite.client.persistence.collection.PersistentSortedSet" + genericType, propertyType) : (propertyType.isProperty() && Set.class.isAssignableFrom(jClass) ? this.createJavaType(jType, declaringClass, declaringTypes, "org.granite.client.persistence.collection.PersistentSet" + genericType, propertyType) : (propertyType.isProperty() && SortedMap.class.isAssignableFrom(jClass) ? this.createJavaType(jType, declaringClass, declaringTypes, "org.granite.client.persistence.collection.PersistentSortedMap" + genericType, propertyType) : (propertyType.isProperty() && Map.class.isAssignableFrom(jClass) ? this.createJavaType(jType, declaringClass, declaringTypes, "org.granite.client.persistence.collection.PersistentMap" + genericType, propertyType) : (jClass.getName().equals("com.google.appengine.api.datastore.Key") ? JavaType.STRING : (jClass.getName().equals("org.springframework.data.domain.Page") ? new JavaType("org.granite.tide.data.model", "Page" + genericType, null) : (jClass.getName().equals("org.springframework.data.domain.Pageable") ? JavaType.PAGE_INFO : (jClass.getName().equals("org.springframework.data.domain.Sort") ? JavaType.SORT_INFO : this.createJavaType(jType, declaringClass, declaringTypes, null, propertyType)))))))));
                if (!imports.isEmpty()) {
                    javaType.addImports(imports);
                }
            }
            this.putInCache(key, propertyType, javaType);
        }
        return javaType;
    }

    @Override
    public ClientType getAs3Type(Class<?> jType) {
        return this.getClientType(jType, null, null, PropertyType.SIMPLE);
    }

    protected JavaType createJavaType(Type jType, Class<?> declaringClass, ParameterizedType[] declaringTypes, String propertyImplTypeName, PropertyType propertyType) {
        HashSet<String> imports = new HashSet<String>();
        Class<?> jClass = ClassUtil.classOfType(jType);
        String name = jClass.getSimpleName();
        if (jClass.isMemberClass()) {
            name = jClass.getEnclosingClass().getSimpleName() + '$' + jClass.getSimpleName();
        } else if (jType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)jType;
            name = name + this.buildGenericTypeName(type, declaringClass, declaringTypes, propertyType, imports);
        }
        JavaType javaType = new JavaType(ClassUtil.getPackageName(jClass), name, propertyImplTypeName, null);
        javaType.addImports(imports);
        return javaType;
    }

    protected ClientType getFromCache(String key, PropertyType propertyType) {
        if (key == null) {
            throw new NullPointerException("jType must be non null");
        }
        if (propertyType == PropertyType.PROPERTY) {
            return this.propertyJava2JavaType.get(key);
        }
        return this.simpleJava2JavaType.get(key);
    }

    protected void putInCache(String key, PropertyType propertyType, ClientType javaType) {
        if (key == null || javaType == null) {
            throw new NullPointerException("jType and JavaType must be non null");
        }
        if (propertyType == PropertyType.PROPERTY) {
            this.propertyJava2JavaType.put(key, javaType);
        } else {
            this.simpleJava2JavaType.put(key, javaType);
        }
    }

    private String buildGenericTypeName(ParameterizedType type, Class<?> declaringClass, ParameterizedType[] declaringTypes, PropertyType propertyType, Set<String> imports) {
        StringBuilder sb = new StringBuilder("<");
        boolean first = true;
        for (Type ata : type.getActualTypeArguments()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (ata instanceof TypeVariable) {
                Type resolved = GenericTypeUtil.resolveTypeVariable(ata, declaringClass, declaringTypes);
                if (resolved instanceof TypeVariable) {
                    sb.append("?");
                    continue;
                }
                sb.append(ClassUtil.classOfType(resolved).getSimpleName());
                imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                continue;
            }
            if (ata instanceof WildcardType) {
                Type resolved;
                String bounds;
                sb.append("?");
                if (((WildcardType)ata).getLowerBounds().length > 0) {
                    bounds = "";
                    for (Type t : ((WildcardType)ata).getLowerBounds()) {
                        resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                        if (resolved instanceof TypeVariable) {
                            bounds = "";
                            break;
                        }
                        if (bounds.length() > 0) {
                            bounds = bounds + ", ";
                        }
                        bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                        imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                    }
                    if (bounds.length() > 0) {
                        sb.append(" super ").append(bounds);
                    }
                }
                if (((WildcardType)ata).getUpperBounds().length <= 0) continue;
                bounds = "";
                for (Type t : ((WildcardType)ata).getUpperBounds()) {
                    resolved = GenericTypeUtil.resolveTypeVariable(t, declaringClass, declaringTypes);
                    if (resolved instanceof TypeVariable) {
                        bounds = "";
                        break;
                    }
                    if (bounds.length() > 0) {
                        bounds = bounds + ", ";
                    }
                    bounds = bounds + ClassUtil.classOfType(resolved).getSimpleName();
                    imports.add(this.getClientType(resolved, declaringClass, declaringTypes, propertyType).getQualifiedName());
                }
                if (bounds.length() <= 0) continue;
                sb.append(" extends ").append(bounds);
                continue;
            }
            sb.append(ClassUtil.classOfType(ata).getSimpleName());
            imports.add(this.getClientType(ata, declaringClass, declaringTypes, propertyType).getQualifiedName());
        }
        sb.append(">");
        return sb.toString();
    }
}

