/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.gsp;

import java.io.FileNotFoundException;
import java.net.URI;
import org.granite.generator.Input;
import org.granite.generator.Listener;
import org.granite.generator.Output;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.exception.TemplateUriException;
import org.granite.generator.gsp.GroovyConfiguration;
import org.granite.generator.gsp.GroovyTemplate;
import org.granite.generator.gsp.GroovyTemplateFactory;
import org.granite.util.URIUtil;

public abstract class AbstractGroovyTransformer<I extends Input<?>, O extends Output<?>, C extends GroovyConfiguration>
extends Transformer<I, O, C> {
    public AbstractGroovyTransformer() {
    }

    public AbstractGroovyTransformer(GroovyConfiguration config, Listener listener) {
        super(config, listener);
    }

    protected GroovyTemplateFactory getTemplateFactory() {
        return ((GroovyConfiguration)this.getConfig()).getGroovyTemplateFactory();
    }

    protected GroovyTemplate getTemplate(TemplateUri templateUri) throws TemplateUriException {
        return this.getTemplate(templateUri.getUri(), templateUri.isBase());
    }

    protected GroovyTemplate getTemplate(String path, boolean base) throws TemplateUriException {
        GroovyTemplateFactory factory = this.getTemplateFactory();
        try {
            URI parent;
            path = URIUtil.normalize(path);
            URI uri = new URI(path);
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            if (schemeSpecificPart == null || schemeSpecificPart.length() == 0) {
                throw new FileNotFoundException("Template path cannot be empty: " + uri);
            }
            if (URIUtil.isFileURI(uri) && !URIUtil.isAbsolute(uri) && (parent = ((GroovyConfiguration)this.getConfig()).getWorkingDirectory().toURI()) != null) {
                uri = parent.resolve(uri.getRawSchemeSpecificPart());
            }
            return factory.getTemplate(uri, base);
        }
        catch (Exception e) {
            throw new TemplateUriException(path, e);
        }
    }
}

