/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.granite.generator.as3.reflect.JavaConstraint;
import org.granite.generator.as3.reflect.JavaProperty;

public class ValidatableBean {
    private final Class<?> type;
    private final String metaAnnotationName;
    private final List<String> specialAnnotationNames;
    private final Map<String, String> nameConversions;

    public ValidatableBean(Class<?> type, String metaAnnotationName, List<String> specialAnnotationNames, Map<String, String> nameConversions) {
        this.type = type;
        this.metaAnnotationName = metaAnnotationName;
        this.specialAnnotationNames = specialAnnotationNames;
        this.nameConversions = nameConversions;
    }

    public void buildConstraints(Map<String, JavaProperty> properties, Map<JavaProperty, List<JavaConstraint>> constraints) {
        Class<? extends Annotation> metaAnnotationClass = ValidatableBean.loadMetaAnnotationClass(this.type, this.metaAnnotationName);
        if (metaAnnotationClass == null) {
            return;
        }
        for (JavaProperty property : properties.values()) {
            ArrayList<JavaConstraint> javaConstraints = new ArrayList<JavaConstraint>();
            ArrayList<Annotation> constraintAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : property.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (annotationClass.isAnnotationPresent(metaAnnotationClass) || this.specialAnnotationNames.contains(annotationClass.getName())) {
                    constraintAnnotations.add(annotation);
                    continue;
                }
                Method value = null;
                try {
                    value = annotationClass.getMethod("value", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (value == null || !value.getReturnType().isArray() || !value.getReturnType().getComponentType().isAnnotation() || !value.getReturnType().getComponentType().isAnnotationPresent(metaAnnotationClass)) continue;
                try {
                    Annotation[] annotationList = (Annotation[])value.invoke((Object)annotation, new Object[0]);
                    constraintAnnotations.addAll(Arrays.asList(annotationList));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (Annotation constraint : constraintAnnotations) {
                ArrayList<String[]> attributes = new ArrayList<String[]>();
                for (Method attribute : constraint.annotationType().getDeclaredMethods()) {
                    if (!Modifier.isPublic(attribute.getModifiers()) || Modifier.isStatic(attribute.getModifiers()) || attribute.getParameterTypes().length != 0) continue;
                    Object value = null;
                    try {
                        value = attribute.invoke((Object)constraint, new Object[0]);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (value == null || value.getClass().isArray() && Array.getLength(value) <= 0) continue;
                    attributes.add(new String[]{attribute.getName(), ValidatableBean.escape(value), attribute.getReturnType().getName()});
                }
                String constraintName = constraint.annotationType().getName();
                if (this.nameConversions.containsKey(constraintName)) {
                    constraintName = this.nameConversions.get(constraintName);
                }
                String packageName = constraintName.indexOf(".") > 0 ? constraintName.substring(0, constraintName.lastIndexOf(".")) : "";
                String string = constraintName = constraintName.indexOf(".") > 0 ? constraintName.substring(constraintName.lastIndexOf(".") + 1) : constraintName;
                if (this.nameConversions.containsKey(packageName)) {
                    packageName = this.nameConversions.get(packageName);
                }
                javaConstraints.add(new JavaConstraint(packageName, constraintName, attributes));
            }
            if (javaConstraints.isEmpty()) continue;
            constraints.put(property, javaConstraints);
        }
    }

    private static Class<? extends Annotation> loadMetaAnnotationClass(Class<?> type, String metaAnnotationName) {
        try {
            return type.getClassLoader().loadClass(metaAnnotationName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String escape(Object value) {
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            int length = Array.getLength(value);
            boolean first = true;
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                if (item == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(ValidatableBean.escape(item, true));
            }
            return sb.toString();
        }
        return ValidatableBean.escape(value, false);
    }

    private static String escape(Object value, boolean array) {
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        value = value.toString().replace("&", "&amp;").replace("\"", "&quot;");
        if (array) {
            value = ((String)value).replace(",", ",,");
        }
        return (String)value;
    }
}

