/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaMethodProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.util.PropertyDescriptor;

public class JavaInterface
extends JavaAbstractType {
    protected final Set<JavaType> imports;
    protected final List<JavaInterface> interfaces;
    protected final List<JavaProperty> properties;

    public JavaInterface(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        if (!type.isInterface()) {
            throw new IllegalArgumentException("type should be an interface: " + type);
        }
        this.interfaces = Collections.unmodifiableList(provider.getJavaTypeInterfaces(type));
        this.properties = this.getSortedUnmodifiableList(this.initProperties());
        HashSet<JavaImport> tmpImports = new HashSet<JavaImport>();
        for (JavaInterface interfaze : this.interfaces) {
            tmpImports.add(provider.getJavaImport(interfaze.getType()));
        }
        for (JavaProperty property : this.properties) {
            tmpImports.add(provider.getJavaImport(property.getType()));
        }
        this.imports = Collections.unmodifiableSet(this.removeNull(tmpImports));
    }

    public Set<JavaType> getImports() {
        return this.imports;
    }

    public boolean hasSuperInterfaces() {
        return this.interfaces != null && !this.interfaces.isEmpty();
    }

    public List<JavaInterface> getSuperInterfaces() {
        return this.interfaces;
    }

    public Collection<JavaProperty> getProperties() {
        return this.properties;
    }

    protected Collection<JavaProperty> initProperties() {
        ArrayList<JavaProperty> properties = new ArrayList<JavaProperty>();
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors(this.getType())) {
            String name = propertyDescriptor.getName();
            JavaMethod readMethod = null;
            JavaMethod writeMethod = null;
            Method method = propertyDescriptor.getReadMethod();
            if (method != null) {
                readMethod = new JavaMethod(method, JavaMethod.MethodType.GETTER);
            }
            if ((method = propertyDescriptor.getWriteMethod()) != null) {
                writeMethod = new JavaMethod(method, JavaMethod.MethodType.SETTER);
            }
            if (readMethod == null && writeMethod == null) continue;
            properties.add(new JavaMethodProperty(this.provider, name, readMethod, writeMethod));
        }
        return properties;
    }
}

