/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.PropertyType;
import org.granite.generator.as3.reflect.JavaMember;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaMethodProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaTypeFactory;

public class JavaFieldProperty
extends JavaMember<Field>
implements JavaProperty {
    private final JavaMethod readMethod;
    private final JavaMethod writeMethod;
    private final JavaTypeFactory provider;
    private final ParameterizedType declaringType;

    public JavaFieldProperty(JavaTypeFactory provider, Field field, JavaMethod readMethod, JavaMethod writeMethod) {
        this(provider, field, readMethod, writeMethod, null);
    }

    public JavaFieldProperty(JavaTypeFactory provider, Field field, JavaMethod readMethod, JavaMethod writeMethod, ParameterizedType declaringType) {
        super(field);
        this.provider = provider;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.declaringType = declaringType;
    }

    @Override
    public String getCapitalizedName() {
        return this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
    }

    @Override
    public Class<?> getType() {
        Type type = ((Field)this.getMember()).getGenericType();
        if (type instanceof TypeVariable && this.declaringType != null) {
            int index = -1;
            for (int i = 0; i < ((Field)this.getMember()).getDeclaringClass().getTypeParameters().length; ++i) {
                if (((Field)this.getMember()).getDeclaringClass().getTypeParameters()[i] != type) continue;
                index = i;
                break;
            }
            if (index >= 0 && index < this.declaringType.getActualTypeArguments().length) {
                return (Class)this.declaringType.getActualTypeArguments()[index];
            }
        }
        return ((Field)this.getMember()).getType();
    }

    public Type getGenericType() {
        Type type = ((Field)this.getMember()).getGenericType();
        if (type instanceof TypeVariable && this.declaringType != null) {
            int index = -1;
            for (int i = 0; i < ((Field)this.getMember()).getDeclaringClass().getTypeParameters().length; ++i) {
                if (((Field)this.getMember()).getDeclaringClass().getTypeParameters()[i] != type) continue;
                index = i;
                break;
            }
            if (index >= 0 && index < this.declaringType.getActualTypeArguments().length) {
                return this.declaringType.getActualTypeArguments()[index];
            }
        }
        return ((Field)this.getMember()).getGenericType();
    }

    @Override
    public Type[] getGenericTypes() {
        Type type = ((Field)this.getMember()).getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public boolean hasTypePackage() {
        return this.getTypePackageName().length() > 0;
    }

    public String getTypePackageName() {
        Package p = this.getType().getPackage();
        return p != null ? p.getName() : "";
    }

    public String getTypeName() {
        return this.getType().getSimpleName();
    }

    @Override
    public boolean isReadable() {
        return Modifier.isPublic(((Field)this.getMember()).getModifiers()) || this.readMethod != null;
    }

    @Override
    public boolean isWritable() {
        return Modifier.isPublic(((Field)this.getMember()).getModifiers()) || this.writeMethod != null;
    }

    @Override
    public boolean isExternalizedProperty() {
        return false;
    }

    @Override
    public boolean isEnum() {
        Class<?> type = this.getType();
        return type.isEnum() || Enum.class.getName().equals(type.getName());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return ((Field)this.getMember()).isAnnotationPresent(annotationClass) || this.readMethod != null && ((Method)this.readMethod.getMember()).isAnnotationPresent(annotationClass) || this.writeMethod != null && ((Method)this.writeMethod.getMember()).isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = ((Field)this.getMember()).getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (this.readMethod != null && (annotation = ((Method)this.readMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        if (this.writeMethod != null && (annotation = ((Method)this.writeMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList<Annotation> annos = new ArrayList<Annotation>(Arrays.asList(((Field)this.getMember()).getDeclaredAnnotations()));
        if (this.readMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.readMethod.getMember()).getDeclaredAnnotations()));
        }
        if (this.writeMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.writeMethod.getMember()).getDeclaredAnnotations()));
        }
        return annos.toArray(new Annotation[0]);
    }

    @Override
    public boolean isReadOverride() {
        return this.readMethod != null && this.readMethod.isOverride();
    }

    @Override
    public boolean isWriteOverride() {
        return this.writeMethod != null && this.writeMethod.isOverride();
    }

    @Override
    public JavaMethod getReadMethod() {
        return this.readMethod;
    }

    @Override
    public JavaMethod getWriteMethod() {
        return this.writeMethod;
    }

    public ClientType getAs3Type() {
        ClientType clientType = this.provider.getClientType(this.getGenericType(), null, null, this.isWritable() ? PropertyType.PROPERTY : PropertyType.READONLY_PROPERTY);
        if (clientType == null) {
            return this.provider.getAs3Type(this.getType());
        }
        return clientType;
    }

    @Override
    public ClientType getClientType() {
        return this.provider.getClientType(this.getGenericType(), null, null, this.isWritable() ? PropertyType.PROPERTY : PropertyType.READONLY_PROPERTY);
    }

    @Override
    public int compareTo(JavaProperty o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaMethodProperty) {
            return ((JavaMethodProperty)obj).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {name=" + this.getName() + ", readable=" + (this.readMethod != null) + ", writable=" + (this.writeMethod != null) + "}";
    }
}

