/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.ClientType;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaFieldProperty;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaMethodProperty;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.annotations.Exclude;
import org.granite.messaging.annotations.Include;
import org.granite.tide.annotations.TideEvent;
import org.granite.util.ClassUtil;
import org.granite.util.PropertyDescriptor;

public class JavaBean
extends JavaAbstractType {
    protected final Set<JavaImport> imports = new HashSet<JavaImport>();
    protected final JavaType superclass;
    protected final ClientType clientSuperclass;
    protected final List<JavaInterface> interfaces;
    protected final List<JavaProperty> interfacesProperties;
    protected final Map<String, JavaProperty> properties;
    protected final JavaProperty uid;
    protected final List<JavaProperty> lazyProperties;

    public JavaBean(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        this.superclass = provider.getJavaTypeSuperclass(type);
        this.clientSuperclass = this.superclass == null && type.isAnnotationPresent(TideEvent.class) ? new As3Type("org.granite.tide.events", "AbstractTideEvent") : null;
        this.interfaces = Collections.unmodifiableList(provider.getJavaTypeInterfaces(type));
        LinkedHashMap<String, JavaProperty> properties = new LinkedHashMap<String, JavaProperty>();
        if (this.superclass == null) {
            ArrayList superclasses = new ArrayList();
            Type gsup = type.getGenericSuperclass();
            Class<?> c = type.getSuperclass();
            while (c.getGenericSuperclass() != null && !c.getName().equals(Object.class.getName())) {
                superclasses.add(0, c);
                c = c.getSuperclass();
            }
            for (Class clazz : superclasses) {
                properties.putAll(this.initProperties(clazz, gsup instanceof ParameterizedType ? (ParameterizedType)gsup : null));
            }
        }
        properties.putAll(this.initProperties());
        this.properties = Collections.unmodifiableMap(properties);
        ArrayList<JavaProperty> tmpLazyProperties = new ArrayList<JavaProperty>();
        for (JavaProperty property : properties.values()) {
            if (!provider.isLazy(property)) continue;
            tmpLazyProperties.add(property);
        }
        this.lazyProperties = tmpLazyProperties.isEmpty() ? null : Collections.unmodifiableList(tmpLazyProperties);
        HashMap<String, JavaProperty> allProperties = new HashMap<String, JavaProperty>(this.properties);
        JavaType supertype = this.superclass;
        while (supertype instanceof JavaBean) {
            allProperties.putAll(((JavaBean)supertype).properties);
            supertype = ((JavaBean)supertype).superclass;
        }
        HashMap<String, JavaProperty> iPropertyMap = new HashMap<String, JavaProperty>();
        this.addImplementedInterfacesProperties(this.interfaces, iPropertyMap, allProperties);
        this.interfacesProperties = this.getSortedUnmodifiableList(iPropertyMap.values());
        JavaProperty tmpUid = null;
        for (JavaProperty property : properties.values()) {
            if (!provider.isUid(property)) continue;
            tmpUid = property;
            break;
        }
        this.uid = tmpUid;
        if (this.superclass != null) {
            this.addToImports(provider.getJavaImport(this.superclass.getType()));
        }
        for (JavaInterface interfaze : this.interfaces) {
            this.addToImports(provider.getJavaImport(interfaze.getType()));
        }
        for (JavaProperty property : properties.values()) {
            this.addToImports(provider.getJavaImports(property.getClientType(), true));
        }
    }

    private void addImplementedInterfacesProperties(List<JavaInterface> interfaces, Map<String, JavaProperty> iPropertyMap, Map<String, JavaProperty> allProperties) {
        for (JavaInterface interfaze : interfaces) {
            for (JavaProperty property : interfaze.getProperties()) {
                String name = property.getName();
                if (iPropertyMap.containsKey(name) || allProperties.containsKey(name)) continue;
                iPropertyMap.put(name, property);
            }
            this.addImplementedInterfacesProperties(interfaze.interfaces, iPropertyMap, allProperties);
        }
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    protected void addToImports(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.add(javaImport);
        }
    }

    protected void addToImports(Set<JavaImport> javaImports) {
        if (javaImports != null) {
            this.imports.addAll(javaImports);
        }
    }

    public boolean hasSuperclass() {
        return this.superclass != null;
    }

    public JavaType getSuperclass() {
        return this.superclass;
    }

    public ClientType getAs3Superclass() {
        return this.clientSuperclass;
    }

    public ClientType getClientSuperclass() {
        return this.clientSuperclass;
    }

    public boolean hasInterfaces() {
        return this.interfaces != null && !this.interfaces.isEmpty();
    }

    public List<JavaInterface> getInterfaces() {
        return this.interfaces;
    }

    public boolean hasInterfacesProperties() {
        return this.interfacesProperties != null && !this.interfacesProperties.isEmpty();
    }

    public List<JavaProperty> getInterfacesProperties() {
        return this.interfacesProperties;
    }

    public Collection<JavaProperty> getProperties() {
        return this.properties.values();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.type.isAnnotationPresent(annotation);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public JavaProperty getUid() {
        return this.uid;
    }

    public boolean isLazy(JavaProperty property) {
        return this.lazyProperties != null && this.lazyProperties.contains(property);
    }

    public boolean hasEnumProperty() {
        for (JavaProperty property : this.properties.values()) {
            if (!property.isEnum()) continue;
            return true;
        }
        return false;
    }

    protected SortedMap<String, JavaProperty> initProperties() {
        return this.initProperties(this.type, null);
    }

    protected SortedMap<String, JavaProperty> initProperties(Class<?> type, ParameterizedType parentGenericType) {
        PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors(type);
        TreeMap<String, JavaProperty> propertyMap = new TreeMap<String, JavaProperty>();
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || "jdoDetachedState".equals(field.getName()) || field.isAnnotationPresent(Exclude.class)) continue;
            String name = field.getName();
            JavaMethod readMethod = null;
            JavaMethod writeMethod = null;
            if (field.getType().isMemberClass() && !field.getType().isEnum()) {
                throw new UnsupportedOperationException("Inner classes are not supported (except enums): " + field.getType());
            }
            if (propertyDescriptors != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (!name.equals(propertyDescriptor.getName())) continue;
                    if (propertyDescriptor.getReadMethod() != null) {
                        readMethod = new JavaMethod(propertyDescriptor.getReadMethod(), JavaMethod.MethodType.GETTER);
                    }
                    if (propertyDescriptor.getWriteMethod() == null) break;
                    writeMethod = new JavaMethod(propertyDescriptor.getWriteMethod(), JavaMethod.MethodType.SETTER);
                    break;
                }
            }
            JavaFieldProperty property = new JavaFieldProperty(this.provider, field, readMethod, writeMethod, parentGenericType);
            propertyMap.put(name, property);
        }
        if (propertyDescriptors != null) {
            for (PropertyDescriptor property : propertyDescriptors) {
                ClassUtil.DeclaredAnnotation<Include> annotation;
                Method getter = property.getReadMethod();
                if (getter == null || !getter.getDeclaringClass().equals(type) || propertyMap.containsKey(property.getName()) || (annotation = ClassUtil.getAnnotation(getter, Include.class)) == null || annotation.declaringClass != type && !annotation.declaringClass.isInterface()) continue;
                JavaMethod readMethod = new JavaMethod(getter, JavaMethod.MethodType.GETTER);
                JavaMethodProperty methodProperty = new JavaMethodProperty(this.provider, property.getName(), readMethod, null, parentGenericType);
                propertyMap.put(property.getName(), methodProperty);
            }
        }
        return propertyMap;
    }
}

