/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wmts.bindings;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.DatasetDescriptionSummaryBaseType;
import net.opengis.ows11.MetadataType;
import net.opengis.wmts.v_1.DimensionType;
import net.opengis.wmts.v_1.LayerType;
import net.opengis.wmts.v_1.StyleType;
import net.opengis.wmts.v_1.TileMatrixSetLinkType;
import net.opengis.wmts.v_1.URLTemplateType;
import net.opengis.wmts.v_1.wmtsv_1Factory;
import org.geotools.wmts.WMTS;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class LayerTypeBinding
extends AbstractComplexBinding {
    wmtsv_1Factory factory;

    public LayerTypeBinding(wmtsv_1Factory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return WMTS.LayerType;
    }

    public Class<LayerType> getType() {
        return LayerType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LayerType layer = this.factory.createLayerType();
        List children = node.getChildren("Abstract");
        for (Node c : children) {
            layer.getAbstract().add(c.getValue());
        }
        children = node.getChildren("BoundingBox");
        for (Node c : children) {
            layer.getBoundingBox().add(c.getValue());
        }
        children = node.getChildren("WGS84BoundingBox");
        for (Node c : children) {
            layer.getWGS84BoundingBox().add(c.getValue());
        }
        layer.getDatasetDescriptionSummary().addAll((Collection)node.getChildren(DatasetDescriptionSummaryBaseType.class));
        layer.getDimension().addAll((Collection)node.getChildValues(DimensionType.class));
        children = node.getChildren("Format");
        for (Node c : children) {
            layer.getFormat().add((Object)((String)c.getValue()));
        }
        children = node.getChildren("InfoFormat");
        for (Node c : children) {
            layer.getInfoFormat().add((Object)((String)c.getValue()));
        }
        layer.setIdentifier((CodeType)node.getChildValue("Identifier"));
        children = node.getChildren("Keyword");
        for (Node c : children) {
            layer.getKeywords().add(c.getValue());
        }
        children = node.getChildren(MetadataType.class);
        for (Node c : children) {
            layer.getMetadata().add(c.getValue());
        }
        children = node.getChildren("ResourceURL");
        for (Node c : children) {
            layer.getResourceURL().add((Object)((URLTemplateType)c.getValue()));
        }
        children = node.getChildren("Style");
        for (Node c : children) {
            layer.getStyle().add((Object)((StyleType)c.getValue()));
        }
        children = node.getChildren("TileMatrixSetLink");
        for (Node c : children) {
            layer.getTileMatrixSetLink().add((Object)((TileMatrixSetLinkType)c.getValue()));
        }
        children = node.getChildren("Title");
        for (Node c : children) {
            layer.getTitle().add(c.getValue());
        }
        return layer;
    }
}

