/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Fill;
import org.geotools.styling.Mark;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Stroke;
import org.picocontainer.MutablePicoContainer;

public class SLDMarkBinding
extends AbstractComplexBinding {
    static final Logger LOGGER = Logging.getLogger(SLDMarkBinding.class);
    protected FilterFactory filterFactory;
    protected StyleFactory styleFactory;
    ResourceLocator resourceLocator;

    public SLDMarkBinding(StyleFactory styleFactory, FilterFactory filterFactory, ResourceLocator resourceLocator) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
        this.resourceLocator = resourceLocator;
    }

    public QName getTarget() {
        return SLD.MARK;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Mark.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String wkName = (String)node.getChildValue("WellKnownName");
        org.geotools.styling.Stroke stroke = (org.geotools.styling.Stroke)node.getChildValue("Stroke");
        Fill fill = (Fill)node.getChildValue("Fill");
        Mark mark = this.styleFactory.createMark();
        if (wkName != null) {
            if (wkName.startsWith("file://")) {
                URL url = this.resourceLocator.locateResource(wkName);
                if (url != null) {
                    wkName = url.toExternalForm();
                } else {
                    LOGGER.log(Level.WARNING, "Could not resolve location of " + wkName);
                }
            }
            mark.setWellKnownName((Expression)this.filterFactory.literal((Object)wkName));
        }
        mark.setStroke((Stroke)stroke);
        mark.setFill((org.opengis.style.Fill)fill);
        return mark;
    }
}

