/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.gml3.bindings.ext;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Polygon;

public class SurfacePatchArrayPropertyTypeBinding
        extends org.geotools.gml3.bindings.SurfacePatchArrayPropertyTypeBinding {

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    public Class getType() {
        return Polygon[].class;
    }

    /**
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated modifiable
     */
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List l = node.getChildValues(Polygon.class);
        return l.toArray(new Polygon[l.size()]);
    }

    @Override
    public Object getProperty(Object object, QName name) {
        if ("_SurfacePatch".equals(name.getLocalPart())
                || "AbstractSurfacePatch".equals(name.getLocalPart())) {
            Polygon[] patches = (Polygon[]) object;
            return patches;
        }

        return null;
    }
}
