package org.geotools.gml3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.feature.type.ProfileImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.gml3.smil.SMIL20LANGSchema;
import org.geotools.xlink.XLINKSchema;
import org.geotools.xs.XSSchema;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;

public class GMLSchema extends SchemaImpl {

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCurveSegmentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Curve segment defines a homogeneous segment of a curve.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence/&gt;
     *      &lt;attribute default="0" name="numDerivativesAtStart" type="integer" use="optional"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;The attribute "numDerivativesAtStart" specifies the type of continuity between this curve segment and its predecessor. If this is the first curve segment in the curve, one of these values, as appropriate, is ignored. The default value of "0" means simple continuity, which is a mandatory minimum level of continuity. This level is referred to as "C 0 " in mathematical texts. A value of 1 means that the function and its first derivative are continuous at the appropriate end point: "C 1 " continuity. A value of "n" for any integer means the function and its first n derivatives are continuous: "C n " continuity.
     *  NOTE: Use of these values is only appropriate when the basic curve definition is an underdetermined system. For example, line string segments cannot support continuity above C 0 , since there is no spare control parameter to adjust the incoming angle at the end points of the segment. Spline functions on the other hand often have extra degrees of freedom on end segments that allow them to adjust the values of the derivatives to support C 1 or higher continuity.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attribute&gt;
     *      &lt;attribute default="0" name="numDerivativesAtEnd" type="integer" use="optional"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;The attribute "numDerivativesAtEnd" specifies the type of continuity between this curve segment and its successor. If this is the last curve segment in the curve, one of these values, as appropriate, is ignored. The default value of "0" means simple continuity, which is a mandatory minimum level of continuity. This level is referred to as "C 0 " in mathematical texts. A value of 1 means that the function and its first derivative are continuous at the appropriate end point: "C 1 " continuity. A value of "n" for any integer means the function and its first n derivatives are continuous: "C n " continuity.
     *  NOTE: Use of these values is only appropriate when the basic curve definition is an underdetermined system. For example, line string segments cannot support continuity above C 0 , since there is no spare control parameter to adjust the incoming angle at the end points of the segment. Spline functions on the other hand often have extra degrees of freedom on end segments that allow them to adjust the values of the derivatives to support C 1 or higher continuity.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attribute&gt;
     *      &lt;attribute default="0" name="numDerivativeInterior" type="integer" use="optional"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;The attribute "numDerivativesInterior" specifies the type of continuity that is guaranteed interior to the curve. The default value of "0" means simple continuity, which is a mandatory minimum level of continuity. This level is referred to as "C 0 " in mathematical texts. A value of 1 means that the function and its first derivative are continuous at the appropriate end point: "C 1 " continuity. A value of "n" for any integer means the function and its first n derivatives are continuous: "C n " continuity.
     *  NOTE: Use of these values is only appropriate when the basic curve definition is an underdetermined system. For example, line string segments cannot support continuity above C 0 , since there is no spare control parameter to adjust the incoming angle at the end points of the segment. Spline functions on the other hand often have extra degrees of freedom on end segments that allow them to adjust the values of the derivatives to support C 1 or higher continuity.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attribute&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCURVESEGMENTTYPE_TYPE =
            build_ABSTRACTCURVESEGMENTTYPE_TYPE();

    private static ComplexType build_ABSTRACTCURVESEGMENTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numDerivativesAtStart"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numDerivativesAtEnd"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numDerivativeInterior"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractCurveSegmentType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="doubleList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on XML Schema double type.  An element of this type contains a space-separated list of double values&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="double"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DOUBLELIST_TYPE = build_DOUBLELIST_TYPE();

    private static AttributeType build_DOUBLELIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "doubleList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="NCNameList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A set of values, representing a list of token with the lexical value space of NCName. The tokens are seperated by whitespace.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="NCName"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType NCNAMELIST_TYPE = build_NCNAMELIST_TYPE();

    private static AttributeType build_NCNAMELIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NCNameList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectPositionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;DirectPosition instances hold the coordinates for a position within some coordinate reference system (CRS). Since
     *  			DirectPositions, as data types, will often be included in larger objects (such as geometry elements) that have references to CRS, the
     *  			"srsName" attribute will in general be missing, if this particular DirectPosition is included in a larger element with such a reference to a
     *  			CRS. In this case, the CRS is implicitly assumed to take on the value of the containing object's CRS.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:doubleList"&gt;
     *              &lt;attributeGroup ref="gml:SRSReferenceGroup"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTPOSITIONTYPE_TYPE = build_DIRECTPOSITIONTYPE_TYPE();

    private static ComplexType build_DIRECTPOSITIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisLabels"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsDimension"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsName"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uomLabels"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectPositionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOUBLELIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VectorType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Vector instances hold the compoents for a (usually spatial) vector within some coordinate reference system (CRS).
     *  			Since Vectors will often be included in larger objects that have references to CRS, the "srsName" attribute may be missing.
     *  			In this case, the CRS is implicitly assumed to take on the value of the containing object's CRS.
     *
     *  			Note that this content model is the same as DirectPositionType, but is defined separately to reflect the distinct semantics, and to avoid validation problems. SJDC 2004-12-02&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:doubleList"&gt;
     *              &lt;attributeGroup ref="gml:SRSReferenceGroup"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VECTORTYPE_TYPE = build_VECTORTYPE_TYPE();

    private static ComplexType build_VECTORTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisLabels"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsDimension"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsName"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uomLabels"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VectorType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOUBLELIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AffinePlacementType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A placement takes a standard geometric
     *     construction and places it in geographic space. It defines a
     *     transformation from a constructive parameter space to the
     *     co-ordinate space of the co-ordinate reference system being used.
     *     Parameter spaces in formulae in this International Standard are
     *     given as (u, v) in 2D and(u, v, w) in 3D. Co-ordinate reference
     *     systems positions are given in formulae, in this International
     *     Standard, by either (x, y) in 2D, or (x, y, z) in 3D.
     *
     *     Affine placements are defined by linear transformations from
     *     parameter space to the target co-ordiante space. 2-dimensional
     *     Cartesian parameter space,(u,v) transforms into 3-dimensional co-
     *     ordinate reference systems,(x,y,z) by using an affine
     *     transformation,(u,v)-&gt;(x,y,z) which is defined :
     *
     *  	x	ux vx  	x0
     *  			 u
     *  	y =	uy vy   + y0
     *  			 v
     *  	x	uz vz	z0
     *
     *     Then, given this equation, the location element of the
     *     AffinePlacement is the direct position (x0, y0, z0), which is the
     *     target position of the origin in (u, v). The two reference
     *     directions (ux, uy, uz) and (vx, vy, vz) are the target
     *     directions of the unit vectors at the origin in (u, v).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="location" type="gml:DirectPositionType"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The location property gives
     *       the target of the parameter space origin. This is the vector
     *      (x0, y0, z0) in the formulae above.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element maxOccurs="unbounded" name="refDirection" type="gml:VectorType"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The attribute refDirection gives the
     *  target directions for the co-ordinate basis vectors of the
     *  parameter space. These are the columns of the matrix in the
     *  formulae given above. The number of directions given shall be
     *  inDimension. The dimension of the directions shall be
     *  outDimension.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element name="inDimension" type="positiveInteger"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Dimension of the constructive parameter
     *       space.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element name="outDimension" type="positiveInteger"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Dimension of the co-ordinate space.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType AFFINEPLACEMENTTYPE_TYPE = build_AFFINEPLACEMENTTYPE_TYPE();

    private static ComplexType build_AFFINEPLACEMENTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "location"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "refDirection"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "inDimension"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "outDimension"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AffinePlacementType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ClothoidType_refLocation"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:AffinePlacement"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The "refLocation" is an affine mapping
     *            that places  the curve defined by the Fresnel Integrals
     *            into the co-ordinate reference system of this object.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CLOTHOIDTYPE_REFLOCATION_TYPE =
            build_CLOTHOIDTYPE_REFLOCATION_TYPE();

    private static ComplexType build_CLOTHOIDTYPE_REFLOCATION_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        AFFINEPLACEMENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "AffinePlacement"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ClothoidType_refLocation"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ClothoidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A clothoid, or Cornu's spiral, is plane
     *     curve whose curvature is a fixed function of its length.
     *     In suitably chosen co-ordinates it is given by Fresnel's
     *     integrals.
     *
     *      x(t) = 0-integral-t cos(AT*T/2)dT
     *
     *      y(t) = 0-integral-t sin(AT*T/2)dT
     *
     *     This geometry is mainly used as a transition curve between
     *     curves of type straight line to circular arc or circular arc
     *     to circular arc. With this curve type it is possible to
     *     achieve a C2-continous transition between the above mentioned
     *     curve types. One formula for the Clothoid is A*A = R*t where
     *     A is constant, R is the varying radius of curvature along the
     *     the curve and t is the length along and given in the Fresnel
     *     integrals.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="refLocation"&gt;
     *                      &lt;complexType name="ClothoidType_refLocation"&gt;
     *                          &lt;sequence&gt;
     *                              &lt;element ref="gml:AffinePlacement"&gt;
     *                                  &lt;annotation&gt;
     *                                      &lt;documentation&gt;The "refLocation" is an affine mapping
     *            that places  the curve defined by the Fresnel Integrals
     *            into the co-ordinate reference system of this object.&lt;/documentation&gt;
     *                                  &lt;/annotation&gt;
     *                              &lt;/element&gt;
     *                          &lt;/sequence&gt;
     *                      &lt;/complexType&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="scaleFactor" type="decimal"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The element gives the value for the
     *         constant in the Fresnel's integrals.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="startParameter" type="double"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The startParameter is the arc length
     *         distance from the inflection point that will be the start
     *         point for this curve segment. This shall be lower limit
     *         used in the Fresnel integral and is the value of the
     *         constructive parameter of this curve segment at its start
     *         point. The startParameter can either be positive or
     *         negative.
     *         NOTE! If 0.0 (zero), lies between the startParameter and
     *         the endParameter of the clothoid, then the curve goes
     *         through the clothoid's inflection point, and the direction
     *         of its radius of curvature, given by the second
     *         derivative vector, changes sides with respect to the
     *         tangent vector. The term length distance for the&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="endParameter" type="double"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The endParameter is the arc length
     *         distance from the inflection point that will be the end
     *         point for this curve segment. This shall be upper limit
     *         used in the Fresnel integral and is the value of the
     *         constructive parameter of this curve segment at its
     *         start point. The startParameter can either be positive
     *         or negative.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CLOTHOIDTYPE_TYPE = build_CLOTHOIDTYPE_TYPE();

    private static ComplexType build_CLOTHOIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CLOTHOIDTYPE_REFLOCATION_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "refLocation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DECIMAL_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scaleFactor"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "startParameter"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "endParameter"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ClothoidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MetaDataPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Base type for complex metadata property types.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;any processContents="lax"/&gt;
     *          &lt;!-- &lt;element ref="gml:_MetaData"/&gt; --&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType METADATAPROPERTYTYPE_TYPE = build_METADATAPROPERTYTYPE_TYPE();

    private static ComplexType build_METADATAPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MetaDataPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="StringOrRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This type is available wherever there is a need for a "text" type property. It is of string type, so the text can be included inline, but the value can also be referenced remotely via xlinks from the AssociationAttributeGroup. If the remote reference is present, then the value obtained by traversing the link should be used, and the string content of the element can be used for an annotation.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="string"&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType STRINGORREFTYPE_TYPE = build_STRINGORREFTYPE_TYPE();

    private static ComplexType build_STRINGORREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "StringOrRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CodeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Name or code with an (optional) authority.  Text token.
     *        If the codeSpace attribute is present, then its value should identify a dictionary, thesaurus
     *        or authority for the term, such as the organisation who assigned the value,
     *        or the dictionary from which it is taken.
     *        A text string with an optional codeSpace attribute. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="string"&gt;
     *              &lt;attribute name="codeSpace" type="anyURI" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CODETYPE_TYPE = build_CODETYPE_TYPE();

    private static ComplexType build_CODETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CodeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGMLType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;All complexContent GML elements are directly or indirectly derived from this abstract supertype
     *  	to establish a hierarchy of GML types that may be distinguished from other XML types by their ancestry.
     *  	Elements in this hierarchy may have an ID and are thus referenceable.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;group ref="gml:StandardObjectProperties"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute ref="gml:id" use="optional"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGMLTYPE_TYPE = build_ABSTRACTGMLTYPE_TYPE();

    private static ComplexType build_ABSTRACTGMLTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractGMLType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeometryType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;All geometry elements are derived directly or indirectly from this abstract supertype. A geometry element may
     *  			have an identifying attribute ("gml:id"), a name (attribute "name") and a description (attribute "description"). It may be associated
     *  			with a spatial reference system (attribute "srsName"). The following rules shall be adhered: - Every geometry type shall derive
     *  			from this abstract type. - Every geometry element (i.e. an element of a geometry type) shall be directly or indirectly in the
     *  			substitution group of _Geometry.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"&gt;
     *              &lt;attribute name="gid" type="string" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;This attribute is included for backward compatibility with GML 2 and is deprecated with GML 3.
     *  						This identifer is superceded by "gml:id" inherited from AbstractGMLType. The attribute "gid" should not be used
     *  						anymore and may be deleted in future versions of GML without further notice.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attributeGroup ref="gml:SRSReferenceGroup"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType ABSTRACTGEOMETRYTYPE_TYPE = build_ABSTRACTGEOMETRYTYPE_TYPE();

    private static AttributeType build_ABSTRACTGEOMETRYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractGeometryType"),
                        org.locationtech.jts.geom.Geometry.class,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeometricPrimitiveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This is the abstract root type of the geometric primitives. A geometric primitive is a geometric object that is not
     *  			decomposed further into other primitives in the system. All primitives are oriented in the direction implied by the sequence of their
     *  			coordinate tuples.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometryType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE =
            build_ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE();

    private static ComplexType build_ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractGeometricPrimitiveType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinatesType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Tables or arrays of tuples.
     *          May be used for text-encoding of values from a table.
     *          Actually just a string, but allows the user to indicate which characters are used as separators.
     *          The value of the 'cs' attribute is the separator for coordinate values,
     *          and the value of the 'ts' attribute gives the tuple separator (a single space by default);
     *          the default values may be changed to reflect local usage.
     *          Defaults to CSV within a tuple, space between tuples.
     *          However, any string content will be schema-valid.  &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="string"&gt;
     *              &lt;attribute default="." name="decimal" type="string"/&gt;
     *              &lt;attribute default="," name="cs" type="string"/&gt;
     *              &lt;attribute default=" " name="ts" type="string"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATESTYPE_TYPE = build_COORDINATESTYPE_TYPE();

    private static ComplexType build_COORDINATESTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "decimal"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "cs"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "ts"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinatesType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Represents a coordinate tuple in one, two, or three dimensions. Deprecated with GML 3.0 and replaced by
     *  			DirectPositionType.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="X" type="decimal"/&gt;
     *          &lt;element minOccurs="0" name="Y" type="decimal"/&gt;
     *          &lt;element minOccurs="0" name="Z" type="decimal"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDTYPE_TYPE = build_COORDTYPE_TYPE();

    private static ComplexType build_COORDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DECIMAL_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "X"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DECIMAL_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Y"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DECIMAL_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Z"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PointType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Point is defined by a single coordinate tuple.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the direct poisiton of a point. 1. The "pos" element is of type
     *  							DirectPositionType.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;element ref="gml:pos"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0 for coordinates with ordinate values that are numbers. Use "pos"
     *  								instead. The "coordinates" element shall only be used for coordinates with ordinates that require a string
     *  								representation, e.g. DMS representations.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                      &lt;element ref="gml:coord"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.0. Use "pos" instead. The "coord" element is included for
     *  								backwards compatibility with GML 2.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType POINTTYPE_TYPE = build_POINTTYPE_TYPE();

    private static AttributeType build_POINTTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PointType"),
                        org.locationtech.jts.geom.Point.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PointPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a point as its value domain can either be an appropriate geometry element encapsulated in an
     *  			element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located
     *  			elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Point"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote
     *  				resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific
     *  				set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium.
     *  				XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be
     *  				used to reference remote properties. A simple link element can be used to implement pointer functionality, and this functionality has
     *  				been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType POINTPROPERTYTYPE_TYPE = build_POINTPROPERTYTYPE_TYPE();

    private static AttributeType build_POINTPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PointPropertyType"),
                        org.locationtech.jts.geom.Point.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectPositionListType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;DirectPositionList instances hold the coordinates for a sequence of direct positions within the same coordinate
     *  			reference system (CRS).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:doubleList"&gt;
     *              &lt;attributeGroup ref="gml:SRSReferenceGroup"/&gt;
     *              &lt;attribute name="count" type="positiveInteger" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;"count" allows to specify the number of direct positions in the list. If the attribute count is present then
     *  						the attribute srsDimension shall be present, too.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTPOSITIONLISTTYPE_TYPE =
            build_DIRECTPOSITIONLISTTYPE_TYPE();

    private static ComplexType build_DIRECTPOSITIONLISTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisLabels"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsDimension"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsName"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uomLabels"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "count"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectPositionListType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOUBLELIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MeasureType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Number with a scale.
     *        The value of uom (Units Of Measure) attribute is a reference to a Reference System for the amount, either a ratio or position scale. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="double"&gt;
     *              &lt;attribute name="uom" type="anyURI" use="required"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MEASURETYPE_TYPE = build_MEASURETYPE_TYPE();

    private static ComplexType build_MEASURETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uom"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MeasureType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.DOUBLE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LengthType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a length (or distance) quantity, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a length, such as metres or feet.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LENGTHTYPE_TYPE = build_LENGTHTYPE_TYPE();

    private static ComplexType build_LENGTHTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LengthType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AngleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of an angle quantity recorded as a single number, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for an angle, such as degrees or radians.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ANGLETYPE_TYPE = build_ANGLETYPE_TYPE();

    private static ComplexType build_ANGLETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AngleType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="CurveInterpolationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an
     *  application schema.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="linear"/&gt;
     *          &lt;enumeration value="geodesic"/&gt;
     *          &lt;enumeration value="circularArc3Points"/&gt;
     *          &lt;enumeration value="circularArc2PointWithBulge"/&gt;
     *          &lt;enumeration value="circularArcCenterPointWithRadius"/&gt;
     *          &lt;enumeration value="elliptical"/&gt;
     *          &lt;enumeration value="clothoid"/&gt;
     *          &lt;enumeration value="conic"/&gt;
     *          &lt;enumeration value="polynomialSpline"/&gt;
     *          &lt;enumeration value="cubicSpline"/&gt;
     *          &lt;enumeration value="rationalSpline"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType CURVEINTERPOLATIONTYPE_TYPE =
            build_CURVEINTERPOLATIONTYPE_TYPE();

    private static AttributeType build_CURVEINTERPOLATIONTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CurveInterpolationType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ArcByCenterPointType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This variant of the arc requires that the points on the arc have to be computed instead of storing the coordinates directly. The control point is the center point of the arc plus the radius and the bearing at start and end. This represenation can be used only in 2D.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) element. The "pos" element contains a center point that is only part of this curve segment, a "pointProperty" element contains a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element can be used to specifiy the coordinates of the center point, too. The number of direct positions in the list must be one.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element name="radius" type="gml:LengthType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The radius of the arc.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" name="startAngle" type="gml:AngleType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The bearing of the arc at the start.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" name="endAngle" type="gml:AngleType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The bearing of the arc at the end.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="circularArcCenterPointWithRadius"
     *                  name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For an ArcByCenterPoint the interpolation is fixed as "circularArcCenterPointWithRadius".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute fixed="1" name="numArc" type="integer" use="required"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;Since this type describes always a single arc, the attribute is fixed to "1".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ARCBYCENTERPOINTTYPE_TYPE = build_ARCBYCENTERPOINTTYPE_TYPE();

    private static ComplexType build_ARCBYCENTERPOINTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LENGTHTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "radius"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "startAngle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "endAngle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numArc"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ArcByCenterPointType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CircleByCenterPointType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A CircleByCenterPoint is an ArcByCenterPoint with identical start and end angle to form a full circle. Again, this represenation can be used only in 2D.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:ArcByCenterPointType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CIRCLEBYCENTERPOINTTYPE_TYPE =
            build_CIRCLEBYCENTERPOINTTYPE_TYPE();

    private static ComplexType build_CIRCLEBYCENTERPOINTTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CircleByCenterPointType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ARCBYCENTERPOINTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DefinitionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A definition, which can be included in or referenced by a dictionary. In this extended type, the inherited "description" optional element can hold the definition whenever only text is needed. The inherited "name" elements can provide one or more brief terms for which this is the definition. The inherited "metaDataProperty" elements can be used to reference or include more information about this definition.
     *  The gml:id attribute is required - it must be possible to reference this definition using this handle.  &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractGMLType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:description"/&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:name"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DEFINITIONTYPE_TYPE = build_DEFINITIONTYPE_TYPE();

    private static ComplexType build_DEFINITIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DefinitionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractReferenceSystemBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for reference system objects, simplifying and restricting the DefinitionType as needed.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:srsName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTREFERENCESYSTEMBASETYPE_TYPE =
            build_ABSTRACTREFERENCESYSTEMBASETYPE_TYPE();

    private static ComplexType build_ABSTRACTREFERENCESYSTEMBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractReferenceSystemBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="IdentifierType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An identification of a CRS object. The first use of the IdentifierType for an object, if any, is normally the primary identification code, and any others are aliases.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:name"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The code or name for this Identifier, often from a controlled list or pattern defined by a code space. The optional codeSpace attribute is normally included to identify or reference a code space within which one or more codes are defined. This code space is often defined by some authority organization, where one organization may define multiple code spaces. The range and format of each Code Space identifier is defined by that code space authority. Information about that code space authority can be included as metaDataProperty elements which are optionally allowed in all CRS objects.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element minOccurs="0" ref="gml:version"/&gt;
     *          &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Remarks about this code or alias.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType IDENTIFIERTYPE_TYPE = build_IDENTIFIERTYPE_TYPE();

    private static ComplexType build_IDENTIFIERTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "version"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "IdentifierType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstraction of a surface to support the different levels of complexity. A surface is always a continuous region of a plane.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricPrimitiveType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTSURFACETYPE_TYPE = build_ABSTRACTSURFACETYPE_TYPE();

    private static ComplexType build_ABSTRACTSURFACETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractSurfaceType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractRingType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstraction of a ring to support surface boundaries of different complexity.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometryType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTRINGTYPE_TYPE = build_ABSTRACTRINGTYPE_TYPE();

    private static ComplexType build_ABSTRACTRINGTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractRingType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractRingPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Encapsulates a ring to represent the surface boundary property of a surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:_Ring"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTRINGPROPERTYTYPE_TYPE =
            build_ABSTRACTRINGPROPERTYTYPE_TYPE();

    private static ComplexType build_ABSTRACTRINGPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTRINGTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Ring"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractRingPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PolygonType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Polygon is a special surface that is defined by a single surface patch. The boundary of this patch is coplanar and the polygon uses planar interpolation in its interior. It is backwards compatible with the Polygon of GML 2, GM_Polygon of ISO 19107 is implemented by PolygonPatch.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:exterior"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:interior"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType POLYGONTYPE_TYPE = build_POLYGONTYPE_TYPE();

    private static AttributeType build_POLYGONTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PolygonType"),
                        org.locationtech.jts.geom.Polygon.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EnvelopeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Envelope defines an extent using a pair of positions defining opposite corners in arbitrary dimensions. The first direct
     *  			position is the "lower corner" (a coordinate position consisting of all the minimal ordinates for each dimension for all points within the envelope),
     *  			the second one the "upper corner" (a coordinate position consisting of all the maximal ordinates for each dimension for all points within the
     *  			envelope).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;sequence&gt;
     *              &lt;element name="lowerCorner" type="gml:DirectPositionType"/&gt;
     *              &lt;element name="upperCorner" type="gml:DirectPositionType"/&gt;
     *          &lt;/sequence&gt;
     *          &lt;element maxOccurs="2" minOccurs="2" ref="gml:coord"&gt;
     *              &lt;annotation&gt;
     *                  &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                  &lt;documentation&gt;deprecated with GML version 3.0&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element maxOccurs="2" minOccurs="2" ref="gml:pos"&gt;
     *              &lt;annotation&gt;
     *                  &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                  &lt;documentation&gt;Deprecated with GML version 3.1. Use the explicit properties "lowerCorner" and "upperCorner" instead.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element ref="gml:coordinates"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use the explicit properties "lowerCorner" and "upperCorner" instead.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/choice&gt;
     *      &lt;attributeGroup ref="gml:SRSReferenceGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENVELOPETYPE_TYPE = build_ENVELOPETYPE_TYPE();

    private static ComplexType build_ENVELOPETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "lowerCorner"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "upperCorner"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coord"),
                        2,
                        2,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        2,
                        2,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisLabels"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsDimension"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsName"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NCNAMELIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uomLabels"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EnvelopeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimeObjectType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The abstract supertype for temporal objects.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMEOBJECTTYPE_TYPE =
            build_ABSTRACTTIMEOBJECTTYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMEOBJECTTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractTimeObjectType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimePrimitiveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The abstract supertype for temporal primitives.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeObjectType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element name="relatedTime" type="gml:RelatedTimeType" minOccurs="0" maxOccurs="unbounded"/--&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMEPRIMITIVETYPE_TYPE =
            build_ABSTRACTTIMEPRIMITIVETYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMEPRIMITIVETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractTimePrimitiveType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEOBJECTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimeGeometricPrimitiveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The abstract supertype for temporal geometric primitives.
     *         A temporal geometry must be associated with a temporal reference system via URI.
     *         The Gregorian calendar with UTC is the default reference system, following ISO
     *         8601. Other reference systems in common use include the GPS calendar and the
     *         Julian calendar.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimePrimitiveType"&gt;
     *              &lt;attribute default="#ISO-8601" name="frame" type="anyURI" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMEGEOMETRICPRIMITIVETYPE_TYPE =
            build_ABSTRACTTIMEGEOMETRICPRIMITIVETYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMEGEOMETRICPRIMITIVETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "frame"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractTimeGeometricPrimitiveType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="TimePositionUnion"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The ISO 19108:2002 hierarchy of subtypes for temporal position are collapsed
     *        by defining a union of XML Schema simple types for indicating temporal position relative
     *        to a specific reference system.
     *
     *        Dates and dateTime may be indicated with varying degrees of precision.
     *        dateTime by itself does not allow right-truncation, except for fractions of seconds.
     *        When used with non-Gregorian calendars based on years, months, days,
     *        the same lexical representation should still be used, with leading zeros added if the
     *        year value would otherwise have fewer than four digits.
     *
     *        An ordinal position may be referenced via URI identifying the definition of an ordinal era.
     *
     *        A time coordinate value is indicated as a decimal (e.g. UNIX time, GPS calendar).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="gml:CalDate time dateTime anyURI decimal"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType TIMEPOSITIONUNION_TYPE = build_TIMEPOSITIONUNION_TYPE();

    private static AttributeType build_TIMEPOSITIONUNION_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimePositionUnion"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="TimeIndeterminateValueType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;This enumerated data type specifies values for indeterminate positions.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="after"/&gt;
     *          &lt;enumeration value="before"/&gt;
     *          &lt;enumeration value="now"/&gt;
     *          &lt;enumeration value="unknown"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType TIMEINDETERMINATEVALUETYPE_TYPE =
            build_TIMEINDETERMINATEVALUETYPE_TYPE();

    private static AttributeType build_TIMEINDETERMINATEVALUETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeIndeterminateValueType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType final="#all" name="TimePositionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Direct representation of a temporal position.
     *        Indeterminate time values are also allowed, as described in ISO 19108. The indeterminatePosition
     *        attribute can be used alone or it can qualify a specific value for temporal position (e.g. before
     *        2002-12, after 1019624400).
     *        For time values that identify position within a calendar, the calendarEraName attribute provides
     *        the name of the calendar era to which the date is referenced (e.g. the Meiji era of the Japanese calendar).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:TimePositionUnion"&gt;
     *              &lt;attribute default="#ISO-8601" name="frame" type="anyURI" use="optional"/&gt;
     *              &lt;attribute name="calendarEraName" type="string" use="optional"/&gt;
     *              &lt;attribute name="indeterminatePosition"
     *                  type="gml:TimeIndeterminateValueType" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEPOSITIONTYPE_TYPE = build_TIMEPOSITIONTYPE_TYPE();

    private static ComplexType build_TIMEPOSITIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "frame"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "calendarEraName"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINDETERMINATEVALUETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "indeterminatePosition"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimePositionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        TIMEPOSITIONUNION_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeInstantType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Omit back-pointers begunBy, endedBy.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeGeometricPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:timePosition"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEINSTANTTYPE_TYPE = build_TIMEINSTANTTYPE_TYPE();

    private static ComplexType build_TIMEINSTANTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "timePosition"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeInstantType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeInstantPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeInstant"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEINSTANTPROPERTYTYPE_TYPE =
            build_TIMEINSTANTPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMEINSTANTPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINSTANTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeInstant"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeInstantPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="TimeUnitType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Standard units for measuring time intervals (see ISO 31-1).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union&gt;
     *          &lt;simpleType&gt;
     *              &lt;restriction base="string"&gt;
     *                  &lt;enumeration value="year"/&gt;
     *                  &lt;enumeration value="day"/&gt;
     *                  &lt;enumeration value="hour"/&gt;
     *                  &lt;enumeration value="minute"/&gt;
     *                  &lt;enumeration value="second"/&gt;
     *              &lt;/restriction&gt;
     *          &lt;/simpleType&gt;
     *          &lt;simpleType&gt;
     *              &lt;restriction base="string"&gt;
     *                  &lt;pattern value="other:\w{2,}"/&gt;
     *              &lt;/restriction&gt;
     *          &lt;/simpleType&gt;
     *      &lt;/union&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType TIMEUNITTYPE_TYPE = build_TIMEUNITTYPE_TYPE();

    private static AttributeType build_TIMEUNITTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeUnitType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType final="#all" name="TimeIntervalLengthType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;This type extends the built-in xsd:decimal simple type to allow floating-point
     *        values for temporal length. According to  the ISO 11404 model you have to use
     *        positiveInteger together with appropriate values for radix and factor. The
     *        resolution of the time interval is to one radix ^(-factor) of the specified
     *        time unit (e.g. unit="second", radix="10", factor="3" specifies a resolution
     *        of milliseconds). It is a subtype of TimeDurationType.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="decimal"&gt;
     *              &lt;attribute name="unit" type="gml:TimeUnitType" use="required"/&gt;
     *              &lt;attribute name="radix" type="positiveInteger" use="optional"/&gt;
     *              &lt;attribute name="factor" type="integer" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEINTERVALLENGTHTYPE_TYPE =
            build_TIMEINTERVALLENGTHTYPE_TYPE();

    private static ComplexType build_TIMEINTERVALLENGTHTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEUNITTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "unit"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "radix"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "factor"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeIntervalLengthType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.DECIMAL_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimePeriodType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeGeometricPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;element name="beginPosition" type="gml:TimePositionType"/&gt;
     *                      &lt;element name="begin" type="gml:TimeInstantPropertyType"/&gt;
     *                  &lt;/choice&gt;
     *                  &lt;choice&gt;
     *                      &lt;element name="endPosition" type="gml:TimePositionType"/&gt;
     *                      &lt;element name="end" type="gml:TimeInstantPropertyType"/&gt;
     *                  &lt;/choice&gt;
     *                  &lt;group minOccurs="0" ref="gml:timeLength"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEPERIODTYPE_TYPE = build_TIMEPERIODTYPE_TYPE();

    private static ComplexType build_TIMEPERIODTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "beginPosition"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINSTANTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "begin"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "endPosition"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINSTANTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "end"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DURATION_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "duration"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINTERVALLENGTHTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "timeInterval"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimePeriodType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ExtentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Information about the spatial, vertical, and/or temporal extent of a reference system object. Constraints: At least one of the elements "description", "boundingBox", "boundingPolygon", "verticalExtent", and temporalExtent" must be included, but more that one can be included when appropriate. Furthermore, more than one "boundingBox", "boundingPolygon", "verticalExtent", and/or temporalExtent" element can be included, with more than one meaning the union of the individual domains.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:description"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Description of spatial and/or temporal extent of this object.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;choice&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Geographic domain of this reference system object.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *              &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:boundingBox"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;Unordered list of bounding boxes (or envelopes) whose union describes the spatial domain of this object.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/element&gt;
     *              &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:boundingPolygon"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;Unordered list of bounding polygons whose union describes the spatial domain of this object.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/element&gt;
     *          &lt;/choice&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:verticalExtent"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Unordered list of vertical intervals whose union describes the spatial domain of this object.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:temporalExtent"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Unordered list of time periods whose union describes the spatial domain of this object.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType EXTENTTYPE_TYPE = build_EXTENTTYPE_TYPE();

    private static ComplexType build_EXTENTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ENVELOPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundingBox"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POLYGONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundingPolygon"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ENVELOPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "verticalExtent"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPERIODTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "temporalExtent"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ExtentType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractReferenceSystemType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Description of a spatial and/or temporal reference system used by a dataset.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:srsID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alterative identifications of this reference system. The first srsID, if any, is normally the primary identification code, and any others are aliases.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this reference system, including source information.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTREFERENCESYSTEMTYPE_TYPE =
            build_ABSTRACTREFERENCESYSTEMTYPE_TYPE();

    private static ComplexType build_ABSTRACTREFERENCESYSTEMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "srsID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractReferenceSystemType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCoordinateSystemBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for coordinate system objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:csName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCOORDINATESYSTEMBASETYPE_TYPE =
            build_ABSTRACTCOORDINATESYSTEMBASETYPE_TYPE();

    private static ComplexType build_ABSTRACTCOORDINATESYSTEMBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "csName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractCoordinateSystemBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="CoordinateSystemAxisBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for coordinate system axis objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:name"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The name by which this coordinate system axis is identified. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATESYSTEMAXISBASETYPE_TYPE =
            build_COORDINATESYSTEMAXISBASETYPE_TYPE();

    private static ComplexType build_COORDINATESYSTEMAXISBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinateSystemAxisBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinateSystemAxisType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Definition of a coordinate system axis. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:CoordinateSystemAxisBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:axisID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this coordinate system axis. The first axisID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this coordinate system axis, including data source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element ref="gml:axisAbbrev"/&gt;
     *                  &lt;element ref="gml:axisDirection"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:uom" use="required"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATESYSTEMAXISTYPE_TYPE =
            build_COORDINATESYSTEMAXISTYPE_TYPE();

    private static ComplexType build_COORDINATESYSTEMAXISTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisAbbrev"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisDirection"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uom"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinateSystemAxisType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        COORDINATESYSTEMAXISBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinateSystemAxisRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a coordinate system axis, either referencing or containing the definition of that axis. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:CoordinateSystemAxis"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATESYSTEMAXISREFTYPE_TYPE =
            build_COORDINATESYSTEMAXISREFTYPE_TYPE();

    private static ComplexType build_COORDINATESYSTEMAXISREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESYSTEMAXISTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CoordinateSystemAxis"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinateSystemAxisRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCoordinateSystemType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A coordinate system (CS) is the set of coordinate system axes that spans a given coordinate space. A CS is derived from a set of (mathematical) rules for specifying how coordinates in a given space are to be assigned to points. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded, whenever those coordinates use a coordinate reference system that uses this coordinate system. This abstract complexType shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateSystemBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:csID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this coordinate system. The first csID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this coordinate system, including data source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:usesAxis"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Ordered sequence of associations to the coordinate system axes included in this coordinate system. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCOORDINATESYSTEMTYPE_TYPE =
            build_ABSTRACTCOORDINATESYSTEMTYPE_TYPE();

    private static ComplexType build_ABSTRACTCOORDINATESYSTEMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "csID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESYSTEMAXISREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesAxis"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractCoordinateSystemType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATESYSTEMBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EllipsoidalCSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A two- or three-dimensional coordinate system in which position is specified by geodetic latitude, geodetic longitude, and (in the three-dimensional case) ellipsoidal height. An EllipsoidalCS shall have two or three usesAxis associations. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateSystemType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ELLIPSOIDALCSTYPE_TYPE = build_ELLIPSOIDALCSTYPE_TYPE();

    private static ComplexType build_ELLIPSOIDALCSTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidalCSType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EllipsoidalCSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an ellipsoidal coordinate system, either referencing or containing the definition of that coordinate system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:EllipsoidalCS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ELLIPSOIDALCSREFTYPE_TYPE = build_ELLIPSOIDALCSREFTYPE_TYPE();

    private static ComplexType build_ELLIPSOIDALCSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ELLIPSOIDALCSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidalCSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractDatumBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for datum objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:datumName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTDATUMBASETYPE_TYPE = build_ABSTRACTDATUMBASETYPE_TYPE();

    private static ComplexType build_ABSTRACTDATUMBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "datumName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractDatumBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractDatumType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A datum specifies the relationship of a coordinate system to the earth, thus creating a coordinate reference system. A datum uses a parameter or set of parameters that determine the location of the origin of the coordinate reference system. Each datum subtype can be associated with only specific types of coordinate systems. This abstract complexType shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractDatumBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:datumID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this datum. The first datumID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on this reference system, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:anchorPoint"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:realizationEpoch"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTDATUMTYPE_TYPE = build_ABSTRACTDATUMTYPE_TYPE();

    private static ComplexType build_ABSTRACTDATUMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "datumID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "anchorPoint"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DATE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "realizationEpoch"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractDatumType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDATUMBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="PrimeMeridianBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for prime meridian objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:meridianName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType PRIMEMERIDIANBASETYPE_TYPE = build_PRIMEMERIDIANBASETYPE_TYPE();

    private static ComplexType build_PRIMEMERIDIANBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "meridianName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PrimeMeridianBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="DegreeValueType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Integer number of degrees in a degree-minute-second or degree-minute angular value, without indication of direction.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="nonNegativeInteger"&gt;
     *          &lt;maxInclusive value="359"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DEGREEVALUETYPE_TYPE = build_DEGREEVALUETYPE_TYPE();

    private static AttributeType build_DEGREEVALUETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DegreeValueType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DegreesType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Integer number of degrees, plus the angle direction. This element can be used for geographic Latitude and Longitude. For Latitude, the XML attribute direction can take the values "N" or "S", meaning North or South of the equator. For Longitude, direction can take the values "E" or "W", meaning East or West of the prime meridian. This element can also be used for other angles. In that case, the direction can take the values "+" or "-" (of SignType), in the specified rotational direction from a specified reference direction.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:DegreeValueType"&gt;
     *              &lt;attribute name="direction"&gt;
     *                  &lt;simpleType&gt;
     *                      &lt;union&gt;
     *                          &lt;simpleType&gt;
     *                              &lt;restriction base="string"&gt;
     *                                  &lt;enumeration value="N"/&gt;
     *                                  &lt;enumeration value="E"/&gt;
     *                                  &lt;enumeration value="S"/&gt;
     *                                  &lt;enumeration value="W"/&gt;
     *                              &lt;/restriction&gt;
     *                          &lt;/simpleType&gt;
     *                          &lt;simpleType&gt;
     *                              &lt;restriction base="gml:SignType"/&gt;
     *                          &lt;/simpleType&gt;
     *                      &lt;/union&gt;
     *                  &lt;/simpleType&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DEGREESTYPE_TYPE = build_DEGREESTYPE_TYPE();

    private static ComplexType build_DEGREESTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DegreesType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEGREEVALUETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="DecimalMinutesType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Decimal number of arc-minutes in a degree-minute angular value.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="decimal"&gt;
     *          &lt;minInclusive value="0.00"/&gt;
     *          &lt;maxExclusive value="60.00"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DECIMALMINUTESTYPE_TYPE = build_DECIMALMINUTESTYPE_TYPE();

    private static AttributeType build_DECIMALMINUTESTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DecimalMinutesType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.DECIMAL_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="ArcMinutesType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Integer number of arc-minutes in a degree-minute-second angular value.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="nonNegativeInteger"&gt;
     *          &lt;maxInclusive value="59"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType ARCMINUTESTYPE_TYPE = build_ARCMINUTESTYPE_TYPE();

    private static AttributeType build_ARCMINUTESTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ArcMinutesType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="ArcSecondsType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Number of arc-seconds in a degree-minute-second angular value.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="decimal"&gt;
     *          &lt;minInclusive value="0.00"/&gt;
     *          &lt;maxExclusive value="60.00"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType ARCSECONDSTYPE_TYPE = build_ARCSECONDSTYPE_TYPE();

    private static AttributeType build_ARCSECONDSTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ArcSecondsType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.DECIMAL_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DMSAngleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Angle value provided in degree-minute-second or degree-minute format.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:degrees"/&gt;
     *          &lt;choice minOccurs="0"&gt;
     *              &lt;element ref="gml:decimalMinutes"/&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:minutes"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:seconds"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DMSANGLETYPE_TYPE = build_DMSANGLETYPE_TYPE();

    private static ComplexType build_DMSANGLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DEGREESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "degrees"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DECIMALMINUTESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "decimalMinutes"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ARCMINUTESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minutes"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ARCSECONDSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "seconds"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DMSAngleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AngleChoiceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of an angle quantity provided in either degree-minute-second format or single value format.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:angle"/&gt;
     *          &lt;element ref="gml:dmsAngle"/&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ANGLECHOICETYPE_TYPE = build_ANGLECHOICETYPE_TYPE();

    private static ComplexType build_ANGLECHOICETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "angle"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DMSANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dmsAngle"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AngleChoiceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PrimeMeridianType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A prime meridian defines the origin from which longitude values are determined.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:PrimeMeridianBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:meridianID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this prime meridian. The first meridianID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this prime meridian, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element ref="gml:greenwichLongitude"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType PRIMEMERIDIANTYPE_TYPE = build_PRIMEMERIDIANTYPE_TYPE();

    private static ComplexType build_PRIMEMERIDIANTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "meridianID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ANGLECHOICETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "greenwichLongitude"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PrimeMeridianType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        PRIMEMERIDIANBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PrimeMeridianRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a prime meridian, either referencing or containing the definition of that meridian. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:PrimeMeridian"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType PRIMEMERIDIANREFTYPE_TYPE = build_PRIMEMERIDIANREFTYPE_TYPE();

    private static ComplexType build_PRIMEMERIDIANREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        PRIMEMERIDIANTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "PrimeMeridian"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PrimeMeridianRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="EllipsoidBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for ellipsoid objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:ellipsoidName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ELLIPSOIDBASETYPE_TYPE = build_ELLIPSOIDBASETYPE_TYPE();

    private static ComplexType build_ELLIPSOIDBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "ellipsoidName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="_isSphere"&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="sphere"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType _ISSPHERE_TYPE = build__ISSPHERE_TYPE();

    private static AttributeType build__ISSPHERE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "_isSphere"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SecondDefiningParameterType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Definition of the second parameter that defines the shape of an ellipsoid. An ellipsoid requires two defining parameters: semi-major axis and inverse flattening or semi-major axis and semi-minor axis. When the reference body is a sphere rather than an ellipsoid, only a single defining parameter is required, namely the radius of the sphere; in that case, the semi-major axis "degenerates" into the radius of the sphere.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:inverseFlattening"/&gt;
     *          &lt;element ref="gml:semiMinorAxis"/&gt;
     *          &lt;element ref="gml:isSphere"/&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SECONDDEFININGPARAMETERTYPE_TYPE =
            build_SECONDDEFININGPARAMETERTYPE_TYPE();

    private static ComplexType build_SECONDDEFININGPARAMETERTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "inverseFlattening"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "semiMinorAxis"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        _ISSPHERE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "isSphere"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SecondDefiningParameterType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EllipsoidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An ellipsoid is a geometric figure that can be used to describe the approximate shape of the earth. In mathematical terms, it is a surface formed by the rotation of an ellipse about its minor axis.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:EllipsoidBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:ellipsoidID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this ellipsoid. The first ellipsoidID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this ellipsoid, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element ref="gml:semiMajorAxis"/&gt;
     *                  &lt;element ref="gml:secondDefiningParameter"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ELLIPSOIDTYPE_TYPE = build_ELLIPSOIDTYPE_TYPE();

    private static ComplexType build_ELLIPSOIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "ellipsoidID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "semiMajorAxis"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SECONDDEFININGPARAMETERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "secondDefiningParameter"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ELLIPSOIDBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EllipsoidRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an ellipsoid, either referencing or containing the definition of that ellipsoid. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Ellipsoid"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ELLIPSOIDREFTYPE_TYPE = build_ELLIPSOIDREFTYPE_TYPE();

    private static ComplexType build_ELLIPSOIDREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ELLIPSOIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Ellipsoid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EllipsoidRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeodeticDatumType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A geodetic datum defines the precise location and orientation in 3-dimensional space of a defined ellipsoid (or sphere) that approximates the shape of the earth, or of a Cartesian coordinate system centered in this ellipsoid (or sphere). &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractDatumType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesPrimeMeridian"/&gt;
     *                  &lt;element ref="gml:usesEllipsoid"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEODETICDATUMTYPE_TYPE = build_GEODETICDATUMTYPE_TYPE();

    private static ComplexType build_GEODETICDATUMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        PRIMEMERIDIANREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesPrimeMeridian"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ELLIPSOIDREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesEllipsoid"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeodeticDatumType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDATUMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeodeticDatumRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a geodetic datum, either referencing or containing the definition of that datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:GeodeticDatum"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEODETICDATUMREFTYPE_TYPE = build_GEODETICDATUMREFTYPE_TYPE();

    private static ComplexType build_GEODETICDATUMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GEODETICDATUMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GeodeticDatum"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeodeticDatumRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeographicCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A coordinate reference system based on an ellipsoidal approximation of the geoid; this provides an accurate representation of the geometry of geographic features for a large portion of the earth's surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesEllipsoidalCS"/&gt;
     *                  &lt;element ref="gml:usesGeodeticDatum"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEOGRAPHICCRSTYPE_TYPE = build_GEOGRAPHICCRSTYPE_TYPE();

    private static ComplexType build_GEOGRAPHICCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ELLIPSOIDALCSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesEllipsoidalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GEODETICDATUMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesGeodeticDatum"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeographicCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeographicCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a geographic coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:GeographicCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEOGRAPHICCRSREFTYPE_TYPE = build_GEOGRAPHICCRSREFTYPE_TYPE();

    private static ComplexType build_GEOGRAPHICCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GEOGRAPHICCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GeographicCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeographicCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LinearRingType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A LinearRing is defined by four or more coordinate tuples, with linear interpolation between them; the first and last coordinates must be coincident.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractRingType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a linear ring.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this ring, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this ring (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this ring only. The number of direct positions in the list must be at least four.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="4"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                      &lt;element maxOccurs="unbounded" minOccurs="4" ref="gml:coord"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.0 and included for backwards compatibility with GML 2. Use "pos" elements instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType LINEARRINGTYPE_TYPE = build_LINEARRINGTYPE_TYPE();

    private static AttributeType build_LINEARRINGTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LinearRingType"),
                        org.locationtech.jts.geom.LinearRing.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTRINGTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LinearRingPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Encapsulates a ring to represent properties in features or geometry collections.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:LinearRing"/&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType LINEARRINGPROPERTYTYPE_TYPE =
            build_LINEARRINGPROPERTYTYPE_TYPE();

    private static AttributeType build_LINEARRINGPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LinearRingPropertyType"),
                        org.locationtech.jts.geom.LinearRing.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractSolidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstraction of a solid to support the different levels of complexity. A solid is always contiguous.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricPrimitiveType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTSOLIDTYPE_TYPE = build_ABSTRACTSOLIDTYPE_TYPE();

    private static ComplexType build_ABSTRACTSOLIDTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractSolidType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SolidPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a solid as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Solid"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SOLIDPROPERTYTYPE_TYPE = build_SOLIDPROPERTYTYPE_TYPE();

    private static ComplexType build_SOLIDPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTSOLIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Solid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SolidPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeSolidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A composite solid is a geometry type with all the geometric properties of a (primitive) solid.
     *  				Essentially, a composite solid is a collection of solids that join in pairs on common boundary surfaces and which, when considered as a whole, form a single solid.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSolidType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:solidMember"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;appinfo&gt;
     *                              &lt;sch:pattern name="Check either href or content not both"&gt;
     *                                  &lt;sch:rule context="gml:solidMember"&gt;
     *                                      &lt;sch:extends rule="hrefOrContent"/&gt;
     *                                  &lt;/sch:rule&gt;
     *                              &lt;/sch:pattern&gt;
     *                          &lt;/appinfo&gt;
     *                          &lt;documentation&gt;This element references or contains one solid in the composite solid. The solids are contiguous.
     *  NOTE: This definition allows for a nested structure, i.e. a CompositeSolid may use, for example, another CompositeSolid as a member.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITESOLIDTYPE_TYPE = build_COMPOSITESOLIDTYPE_TYPE();

    private static ComplexType build_COMPOSITESOLIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SOLIDPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "solidMember"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeSolidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSOLIDTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeSolidPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:CompositeSolid"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITESOLIDPROPERTYTYPE_TYPE =
            build_COMPOSITESOLIDPROPERTYTYPE_TYPE();

    private static ComplexType build_COMPOSITESOLIDPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOSITESOLIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompositeSolid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeSolidPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="NullType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Utility type for null elements.  The value may be selected from one of the enumerated tokens, or may be a URI in which case this should identify a resource which describes the reason for the null. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="gml:NullEnumeration anyURI"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType NULLTYPE_TYPE = build_NULLTYPE_TYPE();

    private static AttributeType build_NULLTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NullType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BoundingShapeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Bounding shape.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:Envelope"/&gt;
     *              &lt;element ref="gml:Null"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BOUNDINGSHAPETYPE_TYPE = build_BOUNDINGSHAPETYPE_TYPE();

    private static ComplexType build_BOUNDINGSHAPETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ENVELOPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Envelope"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NULLTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Null"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BoundingShapeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LocationPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Convenience property for generalised location.
     *        A representative location for plotting or analysis.
     *        Often augmented by one or more additional geometry properties with more specific semantics.&lt;/documentation&gt;
     *          &lt;documentation&gt;Deprecated in GML 3.1.0&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:_Geometry"/&gt;
     *              &lt;element ref="gml:LocationKeyWord"/&gt;
     *              &lt;element ref="gml:LocationString"/&gt;
     *              &lt;element ref="gml:Null"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LOCATIONPROPERTYTYPE_TYPE = build_LOCATIONPROPERTYTYPE_TYPE();

    private static ComplexType build_LOCATIONPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Geometry"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "LocationKeyWord"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "LocationString"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NULLTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Null"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LocationPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractFeatureType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstract feature provides a set of common properties, including id, metaDataProperty, name and description inherited from AbstractGMLType, plus boundedBy.    A concrete feature type must derive from this type and specify additional  properties in an application schema. A feature must possess an identifying attribute ('id' - 'fid' has been deprecated).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:location"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                          &lt;documentation&gt;deprecated in GML version 3.1&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;!-- additional properties must be specified in an application schema --&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTFEATURETYPE_TYPE = build_ABSTRACTFEATURETYPE_TYPE();

    private static ComplexType build_ABSTRACTFEATURETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LOCATIONPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "location"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractFeatureType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DomainSetType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The spatiotemporal domain of a coverage.
     *    Typically
     *    * a geometry collection,
     *    * an implicit geometry (e.g. a grid),
     *    * an explicit or implicit collection of time instances or periods, or
     *
     *  N.B. Temporal geometric complexes and temporal grids are not yet implemented in GML.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:_Geometry"/&gt;
     *              &lt;element ref="gml:_TimeObject"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DOMAINSETTYPE_TYPE = build_DOMAINSETTYPE_TYPE();

    private static ComplexType build_DOMAINSETTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Geometry"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTTIMEOBJECTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_TimeObject"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DomainSetType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeValueType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Aggregate value built from other Values using the Composite pattern. It contains zero or an arbitrary number of valueComponent elements, and zero or one valueComponents elements.  It may be used for strongly coupled aggregates (vectors, tensors) or for arbitrary collections of values.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element ref="gml:valueComponent" minOccurs="0" maxOccurs="unbounded"/&gt;
     *  					&lt;element ref="gml:valueComponents" minOccurs="0"/--&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITEVALUETYPE_TYPE = build_COMPOSITEVALUETYPE_TYPE();

    private static ComplexType build_COMPOSITEVALUETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeValueType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ValueArrayType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Value Array is used for homogeneous arrays of primitive and aggregate values.  The member values may be scalars, composites, arrays or lists.  ValueArray has the same content model as CompositeValue, but the member values must be homogeneous.  The element declaration contains a Schematron constraint which expresses this restriction precisely.            Since the members are homogeneous, the referenceSystem (uom, codeSpace) may be specified on the ValueArray itself and implicitly inherited by all the members if desired.    Note that a_ScalarValueList is preferred for arrays of Scalar Values since this is a more efficient encoding.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:CompositeValueType"&gt;
     *              &lt;attributeGroup ref="gml:referenceSystem"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VALUEARRAYTYPE_TYPE = build_VALUEARRAYTYPE_TYPE();

    private static ComplexType build_VALUEARRAYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uom"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ValueArrayType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        COMPOSITEVALUETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="booleanOrNullList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on the union type defined above.  An element declared with this type contains a space-separated list of boolean values {0,1,true,false} with null values interspersed as needed&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="gml:booleanOrNull"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType BOOLEANORNULLLIST_TYPE = build_BOOLEANORNULLLIST_TYPE();

    private static AttributeType build_BOOLEANORNULLLIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "booleanOrNullList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="NameOrNullList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on the union type defined above.  An element declared with this type contains a space-separated list of Name values with null values interspersed as needed&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="gml:NameOrNull"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType NAMEORNULLLIST_TYPE = build_NAMEORNULLLIST_TYPE();

    private static AttributeType build_NAMEORNULLLIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NameOrNullList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CodeOrNullListType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of values on a uniform nominal scale.  List of text tokens.
     *        In a list context a token should not include any spaces, so xsd:Name is used instead of xsd:string.
     *        A member of the list may be a typed null.
     *        If a codeSpace attribute is present, then its value is a reference to
     *        a Reference System for the value, a dictionary or code list.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:NameOrNullList"&gt;
     *              &lt;attribute name="codeSpace" type="anyURI" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CODEORNULLLISTTYPE_TYPE = build_CODEORNULLLISTTYPE_TYPE();

    private static ComplexType build_CODEORNULLLISTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CodeOrNullListType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        NAMEORNULLLIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CategoryExtentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Restriction of list type to store a 2-point range of ordinal values. If one member is a null, then this is a single ended interval.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:CodeOrNullListType"&gt;
     *              &lt;length value="2"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CATEGORYEXTENTTYPE_TYPE = build_CATEGORYEXTENTTYPE_TYPE();

    private static ComplexType build_CATEGORYEXTENTTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CategoryExtentType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        CODEORNULLLISTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="doubleOrNullList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on the union type defined above.  An element declared with this type contains a space-separated list of double values with null values interspersed as needed&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="gml:doubleOrNull"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DOUBLEORNULLLIST_TYPE = build_DOUBLEORNULLLIST_TYPE();

    private static AttributeType build_DOUBLEORNULLLIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "doubleOrNullList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MeasureOrNullListType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of numbers with a uniform scale.
     *        A member of the list may be a typed null.
     *        The value of uom (Units Of Measure) attribute is a reference to
     *        a Reference System for the amount, either a ratio or position scale. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:doubleOrNullList"&gt;
     *              &lt;attribute name="uom" type="anyURI" use="required"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MEASUREORNULLLISTTYPE_TYPE = build_MEASUREORNULLLISTTYPE_TYPE();

    private static ComplexType build_MEASUREORNULLLISTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uom"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MeasureOrNullListType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOUBLEORNULLLIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="QuantityExtentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Restriction of list type to store a 2-point range of numeric values. If one member is a null, then this is a single ended interval.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureOrNullListType"&gt;
     *              &lt;length value="2"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType QUANTITYEXTENTTYPE_TYPE = build_QUANTITYEXTENTTYPE_TYPE();

    private static ComplexType build_QUANTITYEXTENTTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "QuantityExtentType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASUREORNULLLISTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="integerOrNullList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on the union type defined above.  An element declared with this type contains a space-separated list of integer values with null values interspersed as needed&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="gml:integerOrNull"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType INTEGERORNULLLIST_TYPE = build_INTEGERORNULLLIST_TYPE();

    private static AttributeType build_INTEGERORNULLLIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "integerOrNullList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="CountExtentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Restriction of list type to store a 2-point range of frequency values. If one member is a null, then this is a single ended interval.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="gml:integerOrNullList"&gt;
     *          &lt;length value="2"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType COUNTEXTENTTYPE_TYPE = build_COUNTEXTENTTYPE_TYPE();

    private static AttributeType build_COUNTEXTENTTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CountExtentType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        INTEGERORNULLLIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RangeParametersType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Metadata about the rangeSet.  Definition of record structure.
     *        This is required if the rangeSet is encoded in a DataBlock.
     *        We use a gml:_Value with empty values as a map of the composite value structure.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;group ref="gml:ValueObject"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RANGEPARAMETERSTYPE_TYPE = build_RANGEPARAMETERSTYPE_TYPE();

    private static ComplexType build_RANGEPARAMETERSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Boolean"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Category"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Quantity"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Count"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOOLEANORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "BooleanList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODEORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CategoryList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASUREORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "QuantityList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CountList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CATEGORYEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CategoryExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        QUANTITYEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "QuantityExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COUNTEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CountExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOSITEVALUETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompositeValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RangeParametersType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DataBlockType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:rangeParameters"/&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:tupleList"/&gt;
     *              &lt;element ref="gml:doubleOrNullTupleList"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DATABLOCKTYPE_TYPE = build_DATABLOCKTYPE_TYPE();

    private static ComplexType build_DATABLOCKTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        RANGEPARAMETERSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeParameters"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "tupleList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DOUBLEORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "doubleOrNullTupleList"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DataBlockType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="FileValueModelType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of codes that identifies the file structure model for records stored in files.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="Record Interleaved"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType FILEVALUEMODELTYPE_TYPE = build_FILEVALUEMODELTYPE_TYPE();

    private static AttributeType build_FILEVALUEMODELTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FileValueModelType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="FileType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:rangeParameters"/&gt;
     *          &lt;element name="fileName" type="anyURI"/&gt;
     *          &lt;element name="fileStructure" type="gml:FileValueModelType"/&gt;
     *          &lt;element minOccurs="0" name="mimeType" type="anyURI"/&gt;
     *          &lt;element minOccurs="0" name="compression" type="anyURI"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType FILETYPE_TYPE = build_FILETYPE_TYPE();

    private static ComplexType build_FILETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        RANGEPARAMETERSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeParameters"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "fileName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        FILEVALUEMODELTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "fileStructure"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "mimeType"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "compression"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FileType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RangeSetType"&gt;
     *      &lt;choice&gt;
     *          &lt;element maxOccurs="unbounded" ref="gml:ValueArray"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;each member _Value holds a tuple or "row" from the equivalent table&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;group maxOccurs="unbounded" ref="gml:ScalarValueList"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;each list holds the complete set of one scalar component from the values - i.e. a "column" from the equivalent table&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/group&gt;
     *          &lt;element ref="gml:DataBlock"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Its tuple list holds the values as space-separated tuples each of which contains comma-separated components, and the tuple structure is specified using the rangeParameters property.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element ref="gml:File"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;a reference to an external source for the data, together with a description of how that external source is structured&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RANGESETTYPE_TYPE = build_RANGESETTYPE_TYPE();

    private static ComplexType build_RANGESETTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VALUEARRAYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "ValueArray"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOOLEANORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "BooleanList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODEORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CategoryList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASUREORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "QuantityList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CountList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DATABLOCKTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DataBlock"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        FILETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "File"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RangeSetType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Abstract element which acts as the head of a substitution group for coverages. Note that a coverage is a GML feature.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractFeatureType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:domainSet"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute name="dimension" type="positiveInteger" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCOVERAGETYPE_TYPE = build_ABSTRACTCOVERAGETYPE_TYPE();

    private static ComplexType build_ABSTRACTCOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DOMAINSETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "domainSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dimension"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractCoverageType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTFEATURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="SequenceRuleNames"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of codes (adopted from ISO 19123 Annex C) that identifies the rule for traversing a grid to correspond with the sequence of members of the rangeSet.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="Linear"/&gt;
     *          &lt;enumeration value="Boustrophedonic"/&gt;
     *          &lt;enumeration value="Cantor-diagonal"/&gt;
     *          &lt;enumeration value="Spiral"/&gt;
     *          &lt;enumeration value="Morton"/&gt;
     *          &lt;enumeration value="Hilbert"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SEQUENCERULENAMES_TYPE = build_SEQUENCERULENAMES_TYPE();

    private static AttributeType build_SEQUENCERULENAMES_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SequenceRuleNames"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="IncrementOrder"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The enumeration value here indicates the incrementation order  to be used on the first 2 axes, i.e. "+x-y" means that the points on the first axis are to be traversed from lowest to highest and  the points on the second axis are to be traversed from highest to lowest. The points on all other axes (if any) beyond the first 2 are assumed to increment from lowest to highest.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="+x+y"/&gt;
     *          &lt;enumeration value="+y+x"/&gt;
     *          &lt;enumeration value="+x-y"/&gt;
     *          &lt;enumeration value="-x-y"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType INCREMENTORDER_TYPE = build_INCREMENTORDER_TYPE();

    private static AttributeType build_INCREMENTORDER_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "IncrementOrder"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SequenceRuleType"&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:SequenceRuleNames"&gt;
     *              &lt;attribute name="order" type="gml:IncrementOrder" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SEQUENCERULETYPE_TYPE = build_SEQUENCERULETYPE_TYPE();

    private static ComplexType build_SEQUENCERULETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        INCREMENTORDER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "order"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SequenceRuleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        SEQUENCERULENAMES_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="integerList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on XML Schema integer type.  An element of this type contains a space-separated list of integer values&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="integer"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType INTEGERLIST_TYPE = build_INTEGERLIST_TYPE();

    private static AttributeType build_INTEGERLIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "integerList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridFunctionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Defines how values in the domain are mapped to the range set. The start point and the sequencing rule are specified here.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" name="sequenceRule" type="gml:SequenceRuleType"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;If absent, the implied value is "Linear".&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element minOccurs="0" name="startPoint" type="gml:integerList"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;Index position of the first grid post, which must lie somwhere in the GridEnvelope.  If absent, the startPoint is equal to the value of gridEnvelope::low from the grid definition.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDFUNCTIONTYPE_TYPE = build_GRIDFUNCTIONTYPE_TYPE();

    private static ComplexType build_GRIDFUNCTIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SEQUENCERULETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "sequenceRule"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "startPoint"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridFunctionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoverageFunctionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The function or rule which defines the map from members of the domainSet to the range.
     *        More functions will be added to this list&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:MappingRule"/&gt;
     *          &lt;element ref="gml:GridFunction"/&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COVERAGEFUNCTIONTYPE_TYPE = build_COVERAGEFUNCTIONTYPE_TYPE();

    private static ComplexType build_COVERAGEFUNCTIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "MappingRule"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GRIDFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GridFunction"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoverageFunctionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractDiscreteCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A discrete coverage consists of a domain set, range set and optionally a coverage function. The domain set consists of either geometry or temporal objects, finite in number. The range set is comprised of a finite number of attribute values each of which is associated to every direct position within any single spatiotemporal object in the domain. In other words, the range values are constant on each spatiotemporal object in the domain. This coverage function maps each element from the coverage domain to an element in its range. This definition conforms to ISO 19123.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTDISCRETECOVERAGETYPE_TYPE =
            build_ABSTRACTDISCRETECOVERAGETYPE_TYPE();

    private static ComplexType build_ABSTRACTDISCRETECOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractDiscreteCoverageType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridEnvelopeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Provides grid coordinate values for the diametrically opposed corners of an envelope that bounds a section of grid. The value of a single coordinate is the number of offsets from the origin of the grid in the direction of a specific axis.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="low" type="gml:integerList"/&gt;
     *          &lt;element name="high" type="gml:integerList"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDENVELOPETYPE_TYPE = build_GRIDENVELOPETYPE_TYPE();

    private static ComplexType build_GRIDENVELOPETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "low"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "high"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridEnvelopeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridLimitsType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="GridEnvelope" type="gml:GridEnvelopeType"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDLIMITSTYPE_TYPE = build_GRIDLIMITSTYPE_TYPE();

    private static ComplexType build_GRIDLIMITSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GRIDENVELOPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GridEnvelope"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridLimitsType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An unrectified grid, which is a network composed of two or more sets of equally spaced parallel lines in which the members of each set intersect the members of the other sets at right angles.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometryType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="limits" type="gml:GridLimitsType"/&gt;
     *                  &lt;element maxOccurs="unbounded" name="axisName" type="string"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute name="dimension" type="positiveInteger" use="required"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDTYPE_TYPE = build_GRIDTYPE_TYPE();

    private static ComplexType build_GRIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GRIDLIMITSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "limits"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "axisName"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dimension"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RectifiedGridType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A rectified grid has an origin and vectors that define its post locations.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:GridType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="origin" type="gml:PointPropertyType"/&gt;
     *                  &lt;element maxOccurs="unbounded" name="offsetVector" type="gml:VectorType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RECTIFIEDGRIDTYPE_TYPE = build_RECTIFIEDGRIDTYPE_TYPE();

    private static ComplexType build_RECTIFIEDGRIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "origin"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "offsetVector"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RectifiedGridType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        GRIDTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RectifiedGridDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:RectifiedGrid"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RECTIFIEDGRIDDOMAINTYPE_TYPE =
            build_RECTIFIEDGRIDDOMAINTYPE_TYPE();

    private static ComplexType build_RECTIFIEDGRIDDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        RECTIFIEDGRIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "RectifiedGrid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RectifiedGridDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RectifiedGridCoverageType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:rectifiedGridDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RECTIFIEDGRIDCOVERAGETYPE_TYPE =
            build_RECTIFIEDGRIDCOVERAGETYPE_TYPE();

    private static ComplexType build_RECTIFIEDGRIDCOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RECTIFIEDGRIDDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rectifiedGridDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RectifiedGridCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:Grid"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDDOMAINTYPE_TYPE = build_GRIDDOMAINTYPE_TYPE();

    private static ComplexType build_GRIDDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GRIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Grid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridCoverageType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:gridDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDCOVERAGETYPE_TYPE = build_GRIDCOVERAGETYPE_TYPE();

    private static ComplexType build_GRIDCOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GRIDDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "gridDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SpeedType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a speed, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a velocity, such as metres per second or miles per hour.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SPEEDTYPE_TYPE = build_SPEEDTYPE_TYPE();

    private static ComplexType build_SPEEDTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SpeedType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeometricAggregateType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This is the abstract root type of the geometric aggregates.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometryType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGEOMETRICAGGREGATETYPE_TYPE =
            build_ABSTRACTGEOMETRICAGGREGATETYPE_TYPE();

    private static ComplexType build_ABSTRACTGEOMETRICAGGREGATETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractGeometricAggregateType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PointArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A container for an array of points. The elements are always contained in the array property, referencing geometry
     *  			elements or arrays of geometry elements is not supported.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:Point"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType POINTARRAYPROPERTYTYPE_TYPE =
            build_POINTARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_POINTARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        POINTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Point"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PointArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiPointType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A MultiPoint is defined by one or more Points, referenced through pointMember elements.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricAggregateType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The members of the geometric aggregate can be specified either using the "standard" property or the array property style. It is also valid to use both the "standard" and the array property style in the same collection.
     *  NOTE: Array properties cannot reference remote geometry elements.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:pointMember"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:pointMembers"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTIPOINTTYPE_TYPE = build_MULTIPOINTTYPE_TYPE();

    private static AttributeType build_MULTIPOINTTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiPointType"),
                        org.locationtech.jts.geom.MultiPoint.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICAGGREGATETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiPointPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a collection of points as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:MultiPoint"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTIPOINTPROPERTYTYPE_TYPE =
            build_MULTIPOINTPROPERTYTYPE_TYPE();

    private static AttributeType build_MULTIPOINTPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiPointPropertyType"),
                        org.locationtech.jts.geom.MultiPoint.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ArcStringByBulgeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This variant of the arc computes the mid points of the arcs instead of storing the coordinates directly. The control point sequence consists of the start and end points of each arc plus the bulge.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only. The number of direct positions in the list must be at least two.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="2"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element maxOccurs="unbounded" name="bulge" type="double"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The bulge controls the offset of each arc's midpoint. The "bulge" is the real number multiplier for the normal that determines the offset direction of the midpoint of each arc. The length of the bulge sequence is exactly 1 less than the length of the control point array, since a bulge is needed for each pair of adjacent points in the control point array. The bulge is not given by a distance, since it is simply a multiplier for the normal.
     *  The midpoint of the resulting arc is given by: midPoint = ((startPoint + endPoint)/2.0) + bulge*normal&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" name="normal" type="gml:VectorType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute "normal" is a vector normal (perpendicular) to the chord of the arc, the line joining the first and last
     *  point of the arc. In a 2D coordinate system, there are only two possible directions for the normal, and it is often given as a signed real, indicating its length, with a positive sign indicating a left turn angle from the chord line, and a negative sign indicating a right turn from the chord. In 3D, the normal determines the plane of the arc, along with the start and endPoint of the arc.
     *  The normal is usually a unit vector, but this is not absolutely necessary. If the normal is a zero vector, the geometric object becomes equivalent to the straight line between the two end points. The length of the normal sequence is exactly the same as for the bulge sequence, 1 less than the control point sequence length.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="circularArc2PointWithBulge"
     *                  name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For an ArcStringByBulge the interpolation is fixed as "circularArc2PointWithBulge".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute name="numArc" type="integer" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The number of arcs in the arc string can be explicitly stated in this attribute. The number of control points in the arc string must be numArc + 1.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ARCSTRINGBYBULGETYPE_TYPE = build_ARCSTRINGBYBULGETYPE_TYPE();

    private static ComplexType build_ARCSTRINGBYBULGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "bulge"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "normal"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numArc"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ArcStringByBulgeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ArcByBulgeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An ArcByBulge is an arc string with only one arc unit, i.e. two control points and one bulge.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:ArcStringByBulgeType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only. The number of direct positions in the list must be two.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="2" minOccurs="2"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element name="bulge" type="double"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The bulge controls the offset of each arc's midpoint. The "bulge" is the real number multiplier for the normal that determines the offset direction of the midpoint of each arc. The length of the bulge sequence is exactly 1 less than the length of the control point array, since a bulge is needed for each pair of adjacent points in the control point array. The bulge is not given by a distance, since it is simply a multiplier for the normal.
     *  The midpoint of the resulting arc is given by: midPoint = ((startPoint + endPoint)/2.0) + bulge*normal&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="normal" type="gml:VectorType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute "normal" is a vector normal (perpendicular) to the chord of the arc, the line joining the first and last
     *  point of the arc. In a 2D coordinate system, there are only two possible directions for the normal, and it is often given as a signed real, indicating its length, with a positive sign indicating a left turn angle from the chord line, and a negative sign indicating a right turn from the chord. In 3D, the normal determines the plane of the arc, along with the start and endPoint of the arc.
     *  The normal is usually a unit vector, but this is not absolutely necessary. If the normal is a zero vector, the geometric object becomes equivalent to the straight line between the two end points. The length of the normal sequence is exactly the same as for the bulge sequence, 1 less than the control point sequence length.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="1" name="numArc" type="integer" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;An arc is an arc string consiting of a single arc, the attribute is fixed to "1".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ARCBYBULGETYPE_TYPE = build_ARCBYBULGETYPE_TYPE();

    private static ComplexType build_ARCBYBULGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "bulge"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "normal"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "numArc"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ArcByBulgeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ARCSTRINGBYBULGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCoordinateOperationBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for coordinate operation objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:coordinateOperationName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCOORDINATEOPERATIONBASETYPE_TYPE =
            build_ABSTRACTCOORDINATEOPERATIONBASETYPE_TYPE();

    private static ComplexType build_ABSTRACTCOORDINATEOPERATIONBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml",
                                "AbstractCoordinateOperationBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractPositionalAccuracyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Position error estimate (or accuracy) data. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:measureDescription"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTPOSITIONALACCURACYTYPE_TYPE =
            build_ABSTRACTPOSITIONALACCURACYTYPE_TYPE();

    private static ComplexType build_ABSTRACTPOSITIONALACCURACYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "measureDescription"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractPositionalAccuracyType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a CRS abstract coordinate reference system, either referencing or containing the definition of that CRS.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_CRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CRSREFTYPE_TYPE = build_CRSREFTYPE_TYPE();

    private static ComplexType build_CRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_CRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCoordinateOperationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A mathematical operation on coordinates that transforms or converts coordinates to another coordinate reference system. Many but not all coordinate operations (from CRS A to CRS B) also uniquely define the inverse operation (from CRS B to CRS A). In some cases, the operation method algorithm for the inverse operation is the same as for the forward algorithm, but the signs of some operation parameter values must be reversed. In other cases, different algorithms are required for the forward and inverse operations, but the same operation parameter values are used. If (some) entirely different parameter values are needed, a different coordinate operation shall be defined.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateOperationBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:coordinateOperationID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this coordinate operation. The first coordinateOperationID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this coordinate operation, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:operationVersion"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:_positionalAccuracy"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Unordered set of estimates of the impact of this coordinate operation on point position accuracy. Gives position error estimates for target coordinates of this coordinate operation, assuming no errors in source coordinates. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:sourceCRS"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:targetCRS"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCOORDINATEOPERATIONTYPE_TYPE =
            build_ABSTRACTCOORDINATEOPERATIONTYPE_TYPE();

    private static ComplexType build_ABSTRACTCOORDINATEOPERATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "operationVersion"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTPOSITIONALACCURACYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_positionalAccuracy"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CRSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "sourceCRS"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CRSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "targetCRS"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractCoordinateOperationType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATEOPERATIONBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeneralTransformationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstract operation on coordinates that usually includes a change of Datum. The parameters of a coordinate transformation are empirically derived from data containing the coordinates of a series of points in both coordinate reference systems. This computational process is usually "over-determined", allowing derivation of error (or accuracy) estimates for the transformation. Also, the stochastic nature of the parameters may result in multiple (different) versions of the same coordinate transformation.
     *
     *  This abstract complexType is expected to be extended for well-known operation methods with many Transformation instances, in Application Schemas that define operation-method-specialized value element names and contents. This transformation uses an operation method with associated parameter values. However, operation methods and parameter values are directly associated with concrete subtypes, not with this abstract type. All concrete types derived from this type shall extend this type to include a "usesMethod" element that references one "OperationMethod" element. Similarly, all concrete types derived from this type shall extend this type to include one or more elements each named "uses...Value" that each use the type of an element substitutable for the "_generalParameterValue" element. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractCoordinateOperationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:coordinateOperationName"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:coordinateOperationID"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"/&gt;
     *                  &lt;element ref="gml:operationVersion"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:_positionalAccuracy"/&gt;
     *                  &lt;element ref="gml:sourceCRS"/&gt;
     *                  &lt;element ref="gml:targetCRS"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALTRANSFORMATIONTYPE_TYPE =
            build_ABSTRACTGENERALTRANSFORMATIONTYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALTRANSFORMATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "operationVersion"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTPOSITIONALACCURACYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_positionalAccuracy"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CRSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "sourceCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CRSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "targetCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractGeneralTransformationType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="OperationMethodBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for operation method objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:methodName"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONMETHODBASETYPE_TYPE =
            build_OPERATIONMETHODBASETYPE_TYPE();

    private static ComplexType build_OPERATIONMETHODBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "methodName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationMethodBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeneralOperationParameterType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Abstract definition of a parameter or group of parameters used by an operation method. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:minimumOccurs"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE =
            build_ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minimumOccurs"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml",
                                "AbstractGeneralOperationParameterType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractGeneralOperationParameterRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an operation parameter or group, either referencing or containing the definition of that parameter or group. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_GeneralOperationParameter"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALOPERATIONPARAMETERREFTYPE_TYPE =
            build_ABSTRACTGENERALOPERATIONPARAMETERREFTYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALOPERATIONPARAMETERREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_GeneralOperationParameter"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml",
                                "AbstractGeneralOperationParameterRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationMethodType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Definition of an algorithm used to perform a coordinate operation. Most operation methods use a number of operation parameters, although some coordinate conversions use none. Each coordinate operation using the method assigns values to these parameters. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:OperationMethodBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:methodID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this operation method. The first methodID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this operation method, including source information.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element ref="gml:methodFormula"/&gt;
     *                  &lt;element ref="gml:sourceDimensions"/&gt;
     *                  &lt;element ref="gml:targetDimensions"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:usesParameter"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Unordered list of associations to the set of operation parameters and parameter groups used by this operation method. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONMETHODTYPE_TYPE = build_OPERATIONMETHODTYPE_TYPE();

    private static ComplexType build_OPERATIONMETHODTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "methodID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "methodFormula"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "sourceDimensions"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "targetDimensions"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGENERALOPERATIONPARAMETERREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesParameter"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationMethodType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        OPERATIONMETHODBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationMethodRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a concrete general-purpose operation method, either referencing or containing the definition of that method. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:OperationMethod"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONMETHODREFTYPE_TYPE =
            build_OPERATIONMETHODREFTYPE_TYPE();

    private static ComplexType build_OPERATIONMETHODREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONMETHODTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "OperationMethod"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationMethodRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeneralParameterValueType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Abstract parameter value or group of parameter values.
     *
     *  This abstract complexType is expected to be extended and restricted for well-known operation methods with many instances, in Application Schemas that define operation-method-specialized element names and contents. Specific parameter value elements are directly contained in concrete subtypes, not in this abstract type. All concrete types derived from this type shall extend this type to include one "...Value" element with an appropriate type, which should be one of the element types allowed in the ParameterValueType. In addition, all derived concrete types shall extend this type to include a "valueOfParameter" element that references one element substitutable for the "OperationParameter" element. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALPARAMETERVALUETYPE_TYPE =
            build_ABSTRACTGENERALPARAMETERVALUETYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALPARAMETERVALUETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractGeneralParameterValueType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MeasureListType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of numbers with a uniform scale.
     *        The value of uom (Units Of Measure) attribute is a reference to
     *        a Reference System for the amount, either a ratio or position scale. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:doubleList"&gt;
     *              &lt;attribute name="uom" type="anyURI" use="required"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MEASURELISTTYPE_TYPE = build_MEASURELISTTYPE_TYPE();

    private static ComplexType build_MEASURELISTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "uom"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MeasureListType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOUBLELIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="OperationParameterBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for operation parameter objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractGeneralOperationParameterType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:parameterName"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:minimumOccurs"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERBASETYPE_TYPE =
            build_OPERATIONPARAMETERBASETYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "parameterName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minimumOccurs"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationParameterBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationParameterType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The definition of a parameter used by an operation method. Most parameter values are numeric, but other types of parameter values are possible. This complexType is expected to be used or extended for all operation methods, without defining operation-method-specialized element names.  &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:OperationParameterBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:parameterID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this operation parameter. The first parameterID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this operation parameter, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERTYPE_TYPE =
            build_OPERATIONPARAMETERTYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "parameterID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationParameterType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        OPERATIONPARAMETERBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationParameterRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an operation parameter, either referencing or containing the definition of that parameter. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:OperationParameter"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERREFTYPE_TYPE =
            build_OPERATIONPARAMETERREFTYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONPARAMETERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "OperationParameter"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationParameterRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ParameterValueType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A parameter value, ordered sequence of values, or reference to a file of parameter values. This concrete complexType can be used for operation methods without using an Application Schema that defines operation-method-specialized element names and contents, especially for methods with only one instance. This complexType can be used, extended, or restricted for well-known operation methods, especially for methods with many instances. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeneralParameterValueType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;element ref="gml:value"/&gt;
     *                      &lt;element ref="gml:dmsAngleValue"/&gt;
     *                      &lt;element ref="gml:stringValue"/&gt;
     *                      &lt;element ref="gml:integerValue"/&gt;
     *                      &lt;element ref="gml:booleanValue"/&gt;
     *                      &lt;element ref="gml:valueList"/&gt;
     *                      &lt;element ref="gml:integerValueList"/&gt;
     *                      &lt;element ref="gml:valueFile"/&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element ref="gml:valueOfParameter"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType PARAMETERVALUETYPE_TYPE = build_PARAMETERVALUETYPE_TYPE();

    private static ComplexType build_PARAMETERVALUETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "value"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DMSANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dmsAngleValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "stringValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "integerValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "booleanValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURELISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "valueList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "integerValueList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "valueFile"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONPARAMETERREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "valueOfParameter"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ParameterValueType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALPARAMETERVALUETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TransformationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A concrete operation on coordinates that usually includes a change of datum. The parameters of a coordinate transformation are empirically derived from data containing the coordinates of a series of points in both coordinate reference systems. This computational process is usually "over-determined", allowing derivation of error (or accuracy) estimates for the transformation. Also, the stochastic nature of the parameters may result in multiple (different) versions of the same coordinate transformation.
     *
     *  This concrete complexType can be used for all operation methods, without using an Application Schema that defines operation-method-specialized element names and contents, especially for methods with only one Transformation instance. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeneralTransformationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesMethod"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:usesValue"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Unordered set of composition associations to the set of parameter values used by this transformation operation. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TRANSFORMATIONTYPE_TYPE = build_TRANSFORMATIONTYPE_TYPE();

    private static ComplexType build_TRANSFORMATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONMETHODREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesMethod"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        PARAMETERVALUETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesValue"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TransformationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALTRANSFORMATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TransformationRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a transformation, either referencing or containing the definition of that transformation. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Transformation"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TRANSFORMATIONREFTYPE_TYPE = build_TRANSFORMATIONREFTYPE_TYPE();

    private static ComplexType build_TRANSFORMATIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TRANSFORMATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Transformation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TransformationRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinateReferenceSystemRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_CoordinateReferenceSystem"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATEREFERENCESYSTEMREFTYPE_TYPE =
            build_COORDINATEREFERENCESYSTEMREFTYPE_TYPE();

    private static ComplexType build_COORDINATEREFERENCESYSTEMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_CoordinateReferenceSystem"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "CoordinateReferenceSystemRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeneralConversionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstract operation on coordinates that does not include any change of datum. The best-known example of a coordinate conversion is a map projection. The parameters describing coordinate conversions are defined rather than empirically derived. Note that some conversions have no parameters.
     *
     *  This abstract complexType is expected to be extended for well-known operation methods with many Conversion instances, in Application Schemas that define operation-method-specialized element names and contents. This conversion uses an operation method, usually with associated parameter values. However, operation methods and parameter values are directly associated with concrete subtypes, not with this abstract type. All concrete types derived from this type shall extend this type to include a "usesMethod" element that references the "OperationMethod" element. Similarly, all concrete types derived from this type shall extend this type to include zero or more elements each named "uses...Value" that each use the type of an element substitutable for the "_generalParameterValue" element. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractCoordinateOperationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:coordinateOperationName"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:coordinateOperationID"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:_positionalAccuracy"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALCONVERSIONTYPE_TYPE =
            build_ABSTRACTGENERALCONVERSIONTYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALCONVERSIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinateOperationID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTPOSITIONALACCURACYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_positionalAccuracy"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractGeneralConversionType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeneralConversionRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a general conversion, either referencing or containing the definition of that conversion. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_GeneralConversion"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GENERALCONVERSIONREFTYPE_TYPE =
            build_GENERALCONVERSIONREFTYPE_TYPE();

    private static ComplexType build_GENERALCONVERSIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGENERALCONVERSIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_GeneralConversion"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeneralConversionRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractGeneralDerivedCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A coordinate reference system that is defined by its coordinate conversion from another coordinate reference system (not by a datum). This abstract complexType shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:baseCRS"/&gt;
     *                  &lt;element ref="gml:definedByConversion"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGENERALDERIVEDCRSTYPE_TYPE =
            build_ABSTRACTGENERALDERIVEDCRSTYPE_TYPE();

    private static ComplexType build_ABSTRACTGENERALDERIVEDCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATEREFERENCESYSTEMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "baseCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GENERALCONVERSIONREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "definedByConversion"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractGeneralDerivedCRSType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DerivedCRSTypeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Type of a derived coordinate reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:CodeType"&gt;
     *              &lt;attribute name="codeSpace" type="anyURI" use="required"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;Reference to a source of information specifying the values and meanings of all the allowed string values for this DerivedCRSTypeType. &lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/restriction&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DERIVEDCRSTYPETYPE_TYPE = build_DERIVEDCRSTYPETYPE_TYPE();

    private static ComplexType build_DERIVEDCRSTYPETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DerivedCRSTypeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        CODETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinateSystemRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a coordinate system, either referencing or containing the definition of that coordinate system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_CoordinateSystem"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATESYSTEMREFTYPE_TYPE =
            build_COORDINATESYSTEMREFTYPE_TYPE();

    private static ComplexType build_COORDINATESYSTEMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTCOORDINATESYSTEMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_CoordinateSystem"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinateSystemRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DerivedCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A coordinate reference system that is defined by its coordinate conversion from another coordinate reference system but is not a projected coordinate reference system. This category includes coordinate reference systems derived from a projected coordinate reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeneralDerivedCRSType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:derivedCRSType"/&gt;
     *                  &lt;element ref="gml:usesCS"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DERIVEDCRSTYPE_TYPE = build_DERIVEDCRSTYPE_TYPE();

    private static ComplexType build_DERIVEDCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DERIVEDCRSTYPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "derivedCRSType"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESYSTEMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesCS"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DerivedCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALDERIVEDCRSTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DerivedCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a non-projected derived coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:DerivedCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DERIVEDCRSREFTYPE_TYPE = build_DERIVEDCRSREFTYPE_TYPE();

    private static ComplexType build_DERIVEDCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DERIVEDCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DerivedCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DerivedCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimeReferenceSystemType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;A value in the time domain is measured relative to a temporal reference system. Common
     *          types of reference systems include calendars, ordinal temporal reference systems, and
     *          temporal coordinate systems (time elapsed since some epoch, e.g. UNIX time).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="domainOfValidity" type="string"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE =
            build_ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "domainOfValidity"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractTimeReferenceSystemType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimePeriodPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimePeriod"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEPERIODPROPERTYTYPE_TYPE =
            build_TIMEPERIODPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMEPERIODPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPERIODTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimePeriod"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimePeriodPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeCalendarEraType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;In every calendar, years are numbered relative to the date of a
     *        reference event that defines a calendar era.
     *        In this implementation, we omit the back-pointer "datingSystem".&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="referenceEvent" type="gml:StringOrRefType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Name or description of a mythical or historic event which fixes the position of the base scale of the calendar era.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element default="0001-01-01" minOccurs="0"
     *                      name="referenceDate" type="date"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Date of the referenceEvent expressed as a date in the given calendar.
     *                In most calendars, this date is the origin (i.e., the first day) of the scale, but this is not always true.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="julianReference" type="decimal"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Julian date that corresponds to the reference date.
     *                The Julian day numbering system is a temporal coordinate system that has an
     *                origin earlier than any known calendar,
     *                at noon on 1 January 4713 BC in the Julian proleptic calendar.
     *                The Julian day number is an integer value;
     *                the Julian date is a decimal value that allows greater resolution.
     *                Transforming calendar dates to and from Julian dates provides a
     *                relatively simple basis for transforming dates from one calendar to another.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="epochOfUse" type="gml:TimePeriodPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Period for which the calendar era was used as a basis for dating.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECALENDARERATYPE_TYPE = build_TIMECALENDARERATYPE_TYPE();

    private static ComplexType build_TIMECALENDARERATYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "referenceEvent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DATE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "referenceDate"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DECIMAL_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "julianReference"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPERIODPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "epochOfUse"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendarEraType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeCalendarEraPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeCalendarEra"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECALENDARERAPROPERTYTYPE_TYPE =
            build_TIMECALENDARERAPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMECALENDARERAPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMECALENDARERATYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendarEra"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendarEraPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeCalendarType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;A calendar is a discrete temporal reference system
     *        that provides a basis for defining temporal position to a resolution of one day.
     *        A single calendar may reference more than one calendar era.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" name="referenceFrame" type="gml:TimeCalendarEraPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Link to the CalendarEras that it uses as a reference for dating.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECALENDARTYPE_TYPE = build_TIMECALENDARTYPE_TYPE();

    private static ComplexType build_TIMECALENDARTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMECALENDARERAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "referenceFrame"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendarType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeCalendarPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeCalendar"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECALENDARPROPERTYTYPE_TYPE =
            build_TIMECALENDARPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMECALENDARPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMECALENDARTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendar"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeCalendarPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType final="#all" name="TimeClockType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;A clock provides a basis for defining temporal position within a day.
     *        A clock must be used with a calendar in order to provide a complete description of a temporal position
     *        within a specific day.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="referenceEvent" type="gml:StringOrRefType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Name or description of an event, such as solar noon or sunrise,
     *                which fixes the position of the base scale of the clock.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="referenceTime" type="time"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;time of day associated with the reference event expressed as
     *                a time of day in the given clock. The reference time is usually the origin of the clock scale.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="utcReference" type="time"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;24 hour local or UTC time that corresponds to the reference time.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="dateBasis" type="gml:TimeCalendarPropertyType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECLOCKTYPE_TYPE = build_TIMECLOCKTYPE_TYPE();

    private static ComplexType build_TIMECLOCKTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "referenceEvent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.TIME_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "referenceTime"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.TIME_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "utcReference"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMECALENDARPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dateBasis"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeClockType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeClockPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeClock"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMECLOCKPROPERTYTYPE_TYPE = build_TIMECLOCKPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMECLOCKPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMECLOCKTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeClock"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeClockPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SurfacePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a surface as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Surface"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SURFACEPROPERTYTYPE_TYPE = build_SURFACEPROPERTYTYPE_TYPE();

    private static AttributeType build_SURFACEPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SurfacePropertyType"),
                        org.locationtech.jts.geom.Polygon.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SurfaceArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A container for an array of surfaces. The elements are always contained in the array property, referencing geometry elements or arrays of geometry elements is not supported.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:_Surface"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SURFACEARRAYPROPERTYTYPE_TYPE =
            build_SURFACEARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_SURFACEARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTSURFACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Surface"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SurfaceArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A MultiSurface is defined by one or more Surfaces, referenced through surfaceMember elements.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricAggregateType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The members of the geometric aggregate can be specified either using the "standard" property or the array property style. It is also valid to use both the "standard" and the array property style in the same collection.
     *  NOTE: Array properties cannot reference remote geometry elements.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:surfaceMember"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:surfaceMembers"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTISURFACETYPE_TYPE = build_MULTISURFACETYPE_TYPE();

    private static AttributeType build_MULTISURFACETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSurfaceType"),
                        org.locationtech.jts.geom.MultiPolygon.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICAGGREGATETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSurfaceDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:MultiSurface"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTISURFACEDOMAINTYPE_TYPE =
            build_MULTISURFACEDOMAINTYPE_TYPE();

    private static ComplexType build_MULTISURFACEDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MULTISURFACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "MultiSurface"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSurfaceDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSurfaceCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A discrete coverage type whose domain is defined by a collection of surface patches (includes polygons, triangles, rectangles, etc).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:multiSurfaceDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTISURFACECOVERAGETYPE_TYPE =
            build_MULTISURFACECOVERAGETYPE_TYPE();

    private static ComplexType build_MULTISURFACECOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MULTISURFACEDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "multiSurfaceDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSurfaceCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RelativeInternalPositionalAccuracyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Closeness of the relative positions of two or more positions to their respective relative positions accepted as or being true. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractPositionalAccuracyType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:result"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RELATIVEINTERNALPOSITIONALACCURACYTYPE_TYPE =
            build_RELATIVEINTERNALPOSITIONALACCURACYTYPE_TYPE();

    private static ComplexType build_RELATIVEINTERNALPOSITIONALACCURACYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "result"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml",
                                "RelativeInternalPositionalAccuracyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTPOSITIONALACCURACYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractSurfacePatchType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A surface patch defines a homogenuous portion of a surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTSURFACEPATCHTYPE_TYPE =
            build_ABSTRACTSURFACEPATCHTYPE_TYPE();

    private static ComplexType build_ABSTRACTSURFACEPATCHTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractSurfacePatchType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractParametricCurveSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfacePatchType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTPARAMETRICCURVESURFACETYPE_TYPE =
            build_ABSTRACTPARAMETRICCURVESURFACETYPE_TYPE();

    private static ComplexType build_ABSTRACTPARAMETRICCURVESURFACETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractParametricCurveSurfaceType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACEPATCHTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractGriddedSurfaceType_row"&gt;
     *      &lt;sequence&gt;
     *          &lt;group ref="gml:geometricPositionListGroup"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGRIDDEDSURFACETYPE_ROW_TYPE =
            build_ABSTRACTGRIDDEDSURFACETYPE_ROW_TYPE();

    private static ComplexType build_ABSTRACTGRIDDEDSURFACETYPE_ROW_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractGriddedSurfaceType_row"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AbstractGriddedSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A gridded surface is a parametric curve
     *     surface derived from a rectangular grid in the parameter
     *     space. The rows from this grid are control points for
     *     horizontal surface curves; the columns are control points
     *     for vertical surface curves. The working assumption is that
     *     for a pair of parametric co-ordinates (s, t) that the
     *     horizontal curves for each integer offset are calculated
     *     and evaluated at "s". The defines a sequence of control
     *     points:
     *
     *     cn(s) : s  1 .....columns
     *
     *     From this sequence a vertical curve is calculated for "s",
     *     and evaluated at "t". In most cases, the order of
     *     calculation (horizontal-vertical vs. vertical-horizontal)
     *     does not make a difference. Where it does, the horizontal-
     *     vertical order shall be the one used.
     *
     *     Logically, any pair of curve interpolation types can lead
     *     to a subtype of GriddedSurface. The following clauses
     *     define some most commonly encountered surfaces that can
     *     be represented in this manner.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractParametricCurveSurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:PointGrid"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This is the double indexed sequence
     *         of control points, given in row major form.
     *         NOTE! There in no assumption made about the shape
     *         of the grid.
     *         For example, the positions need not effect a "21/2D"
     *         surface, consecutive points may be equal in any or all
     *         of the ordinates. Further, the curves in either or both
     *         directions may close.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/group&gt;
     *                  &lt;element minOccurs="0" name="rows" type="integer"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute rows gives the number
     *           of rows in the parameter grid.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" name="columns" type="integer"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute columns gives the number
     *          of columns in the parameter grid.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTGRIDDEDSURFACETYPE_TYPE =
            build_ABSTRACTGRIDDEDSURFACETYPE_TYPE();

    private static ComplexType build_ABSTRACTGRIDDEDSURFACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGRIDDEDSURFACETYPE_ROW_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "row"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rows"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "columns"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractGriddedSurfaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTPARAMETRICCURVESURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SphereType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A sphere is a gridded surface given as a
     *     family of circles whose positions vary linearly along the
     *     axis of the sphere, and whise radius varies in proportions to
     *     the cosine function of the central angle. The horizontal
     *     circles resemble lines of constant latitude, and the vertical
     *     arcs resemble lines of constant longitude.
     *     NOTE! If the control points are sorted in terms of increasing
     *     longitude, and increasing latitude, the upNormal of a sphere
     *     is the outward normal.
     *     EXAMPLE If we take a gridded set of latitudes and longitudes
     *     in degrees,(u,v) such as
     *
     *  	(-90,-180)  (-90,-90)  (-90,0)  (-90,  90) (-90, 180)
     *  	(-45,-180)  (-45,-90)  (-45,0)  (-45,  90) (-45, 180)
     *  	(  0,-180)  (  0,-90)  (  0,0)  (  0,  90) (  0, 180)
     *  	( 45,-180)  ( 45,-90)  ( 45,0)  ( 45, -90) ( 45, 180)
     *  	( 90,-180)  ( 90,-90)  ( 90,0)  ( 90, -90) ( 90, 180)
     *
     *     And map these points to 3D using the usual equations (where R
     *     is the radius of the required sphere).
     *
     *      z = R sin u
     *      x = (R cos u)(sin v)
     *      y = (R cos u)(cos v)
     *
     *     We have a sphere of Radius R, centred at (0,0), as a gridded
     *     surface. Notice that the entire first row and the entire last
     *     row of the control points map to a single point in each 3D
     *     Euclidean space, North and South poles respectively, and that
     *     each horizontal curve closes back on itself forming a
     *     geometric cycle. This gives us a metrically bounded (of finite
     *     size), topologically unbounded (not having a boundary, a
     *     cycle) surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGriddedSurfaceType"&gt;
     *              &lt;attribute fixed="circularArc3Points"
     *                  name="horizontalCurveType" type="gml:CurveInterpolationType"/&gt;
     *              &lt;attribute fixed="circularArc3Points"
     *                  name="verticalCurveType" type="gml:CurveInterpolationType"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SPHERETYPE_TYPE = build_SPHERETYPE_TYPE();

    private static ComplexType build_SPHERETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "horizontalCurveType"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "verticalCurveType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SphereType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGRIDDEDSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractCurveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An abstraction of a curve to support the different levels of complexity. The curve can always be viewed as a geometric
     *  			primitive, i.e. is continuous.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricPrimitiveType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTCURVETYPE_TYPE = build_ABSTRACTCURVETYPE_TYPE();

    private static ComplexType build_ABSTRACTCURVETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractCurveType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LineStringType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A LineString is a special curve that consists of a single segment with linear interpolation. It is defined by two or more coordinate
     *  			tuples, with linear interpolation between them. It is backwards compatible with the LineString of GML 2, GM_LineString of ISO 19107 is
     *  			implemented by LineStringSegment.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a line string. 1. A sequence of "pos"
     *  							(DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part
     *  							of this curve, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference
     *  							another point defined outside of this curve (reuse of existing points). 2. The "posList" element allows for a compact way to
     *  							specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong
     *  							to this curve only. The number of direct positions in the list must be at least two.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="2"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility
     *  									with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                          &lt;element ref="gml:coord"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.0. Use "pos" instead. The "coord" element is included for backwards
     *  									compatibility with GML 2.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType LINESTRINGTYPE_TYPE = build_LINESTRINGTYPE_TYPE();

    private static AttributeType build_LINESTRINGTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LineStringType"),
                        org.locationtech.jts.geom.LineString.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LineStringPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This type is deprecated with GML 3 and shall not be used. It is included for backwards compatibility with GML 2. Use
     *  			CurvePropertyType instead. A property that has a line string as its value domain can either be an appropriate geometry element encapsulated
     *  			in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere
     *  			in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:LineString"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources
     *  				(including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes.
     *  				The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to
     *  				be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  				A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by
     *  				including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType LINESTRINGPROPERTYTYPE_TYPE =
            build_LINESTRINGPROPERTYTYPE_TYPE();

    private static AttributeType build_LINESTRINGPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LineStringPropertyType"),
                        org.locationtech.jts.geom.LineString.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiLineStringType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A MultiLineString is defined by one or more LineStrings, referenced through lineStringMember elements. Deprecated with GML version 3.0. Use MultiCurveType instead.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricAggregateType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:lineStringMember"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTILINESTRINGTYPE_TYPE = build_MULTILINESTRINGTYPE_TYPE();

    private static AttributeType build_MULTILINESTRINGTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiLineStringType"),
                        org.locationtech.jts.geom.MultiLineString.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICAGGREGATETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiLineStringPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This type is deprecated with GML 3 and shall not be used. It is included for backwards compatibility with GML 2. Use MultiCurvePropertyType instead.
     *  A property that has a collection of line strings as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:MultiLineString"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTILINESTRINGPROPERTYTYPE_TYPE =
            build_MULTILINESTRINGPROPERTYTYPE_TYPE();

    private static AttributeType build_MULTILINESTRINGPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiLineStringPropertyType"),
                        org.locationtech.jts.geom.MultiLineString.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A CompositeSurface is defined by a set of orientable surfaces. A composite surface is geometry type with all the geometric properties of a (primitive) surface. Essentially, a composite surface is a collection of surfaces that join in pairs on common boundary curves and which, when considered as a whole, form a single surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:surfaceMember"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This element references or contains one surface in the composite surface. The surfaces are contiguous.
     *  NOTE: This definition allows for a nested structure, i.e. a CompositeSurface may use, for example, another CompositeSurface as a member.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITESURFACETYPE_TYPE = build_COMPOSITESURFACETYPE_TYPE();

    private static ComplexType build_COMPOSITESURFACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "surfaceMember"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeSurfaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeSurfacePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:CompositeSurface"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITESURFACEPROPERTYTYPE_TYPE =
            build_COMPOSITESURFACEPROPERTYTYPE_TYPE();

    private static ComplexType build_COMPOSITESURFACEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOSITESURFACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompositeSurface"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeSurfacePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="UnitDefinitionType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Definition of a unit of measure (or uom). The definition includes a quantityType property, which indicates the phenomenon to which the units apply, and a catalogSymbol, which gives the short symbol used for this unit. This element is used when the relationship of this unit to other units or units systems is unknown.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:quantityType"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:catalogSymbol"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType UNITDEFINITIONTYPE_TYPE = build_UNITDEFINITIONTYPE_TYPE();

    private static ComplexType build_UNITDEFINITIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "quantityType"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "catalogSymbol"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "UnitDefinitionType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ReferenceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A pattern or base for derived types used to specify complex types corresponding to a UML aggregation association.  An instance of this type serves as a pointer to a remote Object.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType REFERENCETYPE_TYPE = build_REFERENCETYPE_TYPE();

    private static ComplexType build_REFERENCETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ReferenceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BaseUnitType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Definition of a unit of measure which is a base unit from the system of units.  A base unit cannot be derived by combination of other base units within this system.  Sometimes known as "fundamental unit".&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:UnitDefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="unitsSystem" type="gml:ReferenceType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BASEUNITTYPE_TYPE = build_BASEUNITTYPE_TYPE();

    private static ComplexType build_BASEUNITTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        REFERENCETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "unitsSystem"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BaseUnitType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        UNITDEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CurvePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a curve as its value domain can either be an appropriate geometry element encapsulated in an
     *  			element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere
     *  			in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Curve"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote
     *  				resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific
     *  				set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium.
     *  				XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used
     *  				to reference remote properties. A simple link element can be used to implement pointer functionality, and this functionality has been built
     *  				into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType CURVEPROPERTYTYPE_TYPE = build_CURVEPROPERTYTYPE_TYPE();

    private static AttributeType build_CURVEPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CurvePropertyType"),
                        CurvedGeometry.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="SignType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Utility type used in various places
     *        - e.g. to indicate the direction of topological objects;
     *        "+" for forwards, or "-" for backwards.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="-"/&gt;
     *          &lt;enumeration value="+"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SIGNTYPE_TYPE = build_SIGNTYPE_TYPE();

    private static AttributeType build_SIGNTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SignType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OrientableCurveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;OrientableCurve consists of a curve and an orientation. If the orientation is "+", then the OrientableCurve is identical to the baseCurve. If the orientation is "-", then the OrientableCurve is related to another _Curve with a parameterization that reverses the sense of the curve traversal.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:baseCurve"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;References or contains the base curve (positive orientation).
     *  NOTE: This definition allows for a nested structure, i.e. an OrientableCurve may use another OrientableCurve as its base curve.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute default="+" name="orientation" type="gml:SignType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;If the orientation is "+", then the OrientableCurve is identical to the baseCurve. If the orientation is "-", then the OrientableCurve is related to another _Curve with a parameterization that reverses the sense of the curve traversal. "+" is the default value.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ORIENTABLECURVETYPE_TYPE = build_ORIENTABLECURVETYPE_TYPE();

    private static ComplexType build_ORIENTABLECURVETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "baseCurve"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SIGNTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "orientation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OrientableCurveType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ValuePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;GML property which refers to, or contains, a Value&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;group ref="gml:Value"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VALUEPROPERTYTYPE_TYPE = build_VALUEPROPERTYTYPE_TYPE();

    private static ComplexType build_VALUEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Boolean"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Category"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Quantity"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Count"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOOLEANORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "BooleanList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODEORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CategoryList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASUREORNULLLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "QuantityList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INTEGERORNULLLIST_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CountList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CATEGORYEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CategoryExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        QUANTITYEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "QuantityExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COUNTEXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CountExtent"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOSITEVALUETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompositeValue"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Object"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        NULLTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Null"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ValuePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ScalarValuePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Property whose content is a scalar value.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:ValuePropertyType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;!-- &lt;element ref="gml:_ScalarValue"/&gt; --&gt;
     *                  &lt;group ref="gml:ScalarValue"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SCALARVALUEPROPERTYTYPE_TYPE =
            build_SCALARVALUEPROPERTYTYPE_TYPE();

    private static ComplexType build_SCALARVALUEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Boolean"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Category"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Quantity"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Count"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ScalarValuePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        VALUEPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSurfacePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a collection of surfaces as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:MultiSurface"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTISURFACEPROPERTYTYPE_TYPE =
            build_MULTISURFACEPROPERTYTYPE_TYPE();

    private static AttributeType build_MULTISURFACEPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSurfacePropertyType"),
                        org.locationtech.jts.geom.MultiPolygon.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimePrimitivePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_TimePrimitive"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEPRIMITIVEPROPERTYTYPE_TYPE =
            build_TIMEPRIMITIVEPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMEPRIMITIVEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTTIMEPRIMITIVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_TimePrimitive"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimePrimitivePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="FeaturePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Container for a feature - follow gml:AssociationType pattern.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Feature"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType FEATUREPROPERTYTYPE_TYPE = build_FEATUREPROPERTYTYPE_TYPE();

    private static ComplexType build_FEATUREPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTFEATURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Feature"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FeaturePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TargetPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Container for an object representing the target or subject of an observation.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:_Feature"/&gt;
     *              &lt;element ref="gml:_Geometry"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TARGETPROPERTYTYPE_TYPE = build_TARGETPROPERTYTYPE_TYPE();

    private static ComplexType build_TARGETPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTFEATURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Feature"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGEOMETRYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Geometry"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TargetPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AssociationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A pattern or base for derived types used to specify complex types corresponding to an  unspecified UML association - either composition or aggregation.  Restricts the cardinality of Objects contained in the association to a maximum of one.  An instance of this type can contain an element representing an Object, or serve as a pointer to a remote Object.
     *
     *  Descendents of this type can be restricted in an application schema to
     *  * allow only specified classes as valid participants in the aggregation
     *  * allow only association by reference (i.e. empty the content model) or by value (i.e. remove the xlinks).
     *
     *  When used for association by reference, the value of the gml:remoteSchema attribute can be used to locate a schema fragment that constrains the target instance.
     *
     *  In many cases it is desirable to impose the constraint prohibiting the occurence of both reference and value in the same instance, as that would be ambiguous.  This is accomplished by adding a directive in the annotation element of the element declaration.  This directive can be in the form of normative prose, or can use a Schematron pattern to automatically constrain co-occurrence - see the declaration for _strictAssociation below.
     *
     *  If co-occurence is not prohibited, then both a link and content may be present.  If this occurs in an instance, then the rule for interpretation is that the instance found by traversing the href provides the normative value of the property, and should be used when possible.  The value(s) included as content may be used if the remote instance cannot be resolved.  This may be considered to be a "cached" version of the value(s).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Object"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ASSOCIATIONTYPE_TYPE = build_ASSOCIATIONTYPE_TYPE();

    private static ComplexType build_ASSOCIATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Object"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AssociationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ObservationType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractFeatureType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:validTime"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:using"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:target"/&gt;
     *                  &lt;element ref="gml:resultOf"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OBSERVATIONTYPE_TYPE = build_OBSERVATIONTYPE_TYPE();

    private static ComplexType build_OBSERVATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPRIMITIVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validTime"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        FEATUREPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "using"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TARGETPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "target"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ASSOCIATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "resultOf"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ObservationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTFEATURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectionVectorType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Direction expressed as a vector, either using components, or using angles.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:vector"/&gt;
     *          &lt;sequence&gt;
     *              &lt;element name="horizontalAngle" type="gml:AngleType"/&gt;
     *              &lt;element name="verticalAngle" type="gml:AngleType"/&gt;
     *          &lt;/sequence&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTIONVECTORTYPE_TYPE = build_DIRECTIONVECTORTYPE_TYPE();

    private static ComplexType build_DIRECTIONVECTORTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "vector"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "horizontalAngle"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "verticalAngle"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectionVectorType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="CompassPointEnumeration"&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="N"/&gt;
     *          &lt;enumeration value="NNE"/&gt;
     *          &lt;enumeration value="NE"/&gt;
     *          &lt;enumeration value="ENE"/&gt;
     *          &lt;enumeration value="E"/&gt;
     *          &lt;enumeration value="ESE"/&gt;
     *          &lt;enumeration value="SE"/&gt;
     *          &lt;enumeration value="SSE"/&gt;
     *          &lt;enumeration value="S"/&gt;
     *          &lt;enumeration value="SSW"/&gt;
     *          &lt;enumeration value="SW"/&gt;
     *          &lt;enumeration value="WSW"/&gt;
     *          &lt;enumeration value="W"/&gt;
     *          &lt;enumeration value="WNW"/&gt;
     *          &lt;enumeration value="NW"/&gt;
     *          &lt;enumeration value="NNW"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType COMPASSPOINTENUMERATION_TYPE =
            build_COMPASSPOINTENUMERATION_TYPE();

    private static AttributeType build_COMPASSPOINTENUMERATION_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompassPointEnumeration"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectionPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:DirectionVector"/&gt;
     *          &lt;element ref="gml:CompassPoint"/&gt;
     *          &lt;element name="DirectionKeyword" type="gml:CodeType"/&gt;
     *          &lt;element name="DirectionString" type="gml:StringOrRefType"/&gt;
     *      &lt;/choice&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTIONPROPERTYTYPE_TYPE = build_DIRECTIONPROPERTYTYPE_TYPE();

    private static ComplexType build_DIRECTIONPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTIONVECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DirectionVector"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COMPASSPOINTENUMERATION_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompassPoint"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DirectionKeyword"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DirectionString"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectionPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectedObservationType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:ObservationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:direction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTEDOBSERVATIONTYPE_TYPE =
            build_DIRECTEDOBSERVATIONTYPE_TYPE();

    private static ComplexType build_DIRECTEDOBSERVATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTIONPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "direction"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectedObservationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        OBSERVATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectedObservationAtDistanceType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DirectedObservationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="distance" type="gml:MeasureType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTEDOBSERVATIONATDISTANCETYPE_TYPE =
            build_DIRECTEDOBSERVATIONATDISTANCETYPE_TYPE();

    private static ComplexType build_DIRECTEDOBSERVATIONATDISTANCETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MEASURETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "distance"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "DirectedObservationAtDistanceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DIRECTEDOBSERVATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompoundCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A coordinate reference system describing the position of points through two or more independent coordinate reference systems. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="2" ref="gml:includesCRS"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Ordered sequence of associations to all the component coordinate reference systems included in this compound coordinate reference system. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOUNDCRSTYPE_TYPE = build_COMPOUNDCRSTYPE_TYPE();

    private static ComplexType build_COMPOUNDCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATEREFERENCESYSTEMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "includesCRS"),
                        2,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompoundCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompoundCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a compound coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:CompoundCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOUNDCRSREFTYPE_TYPE = build_COMPOUNDCRSREFTYPE_TYPE();

    private static ComplexType build_COMPOUNDCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOUNDCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompoundCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompoundCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="CalDate"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Calendar dates may be indicated with varying degrees of precision,
     *        using year, year-month, date.
     *        When used with non-Gregorian calendars based on years, months, days,
     *        the same lexical representation should still be used, with leading zeros added if the
     *        year value would otherwise have fewer than four digits.
     *        time is used for a position that recurs daily (see clause 5.4.4.2 of ISO 19108:2002).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="date gYearMonth gYear"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType CALDATE_TYPE = build_CALDATE_TYPE();

    private static AttributeType build_CALDATE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CalDate"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CoordinateOperationRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a coordinate operation, either referencing or containing the definition of that coordinate operation. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_CoordinateOperation"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COORDINATEOPERATIONREFTYPE_TYPE =
            build_COORDINATEOPERATIONREFTYPE_TYPE();

    private static ComplexType build_COORDINATEOPERATIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_CoordinateOperation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CoordinateOperationRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RingType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Ring is used to represent a single connected component of a surface boundary. It consists of a sequence of curves connected in a cycle (an object whose boundary is empty).
     *  A Ring is structurally similar to a composite curve in that the endPoint of each curve in the sequence is the startPoint of the next curve in the Sequence. Since the sequence is circular, there is no exception to this rule. Each ring, like all boundaries, is a cycle and each ring is simple.
     *  NOTE: Even though each Ring is simple, the boundary need not be simple. The easiest case of this is where one of the interior rings of a surface is tangent to its exterior ring.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractRingType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:curveMember"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This element references or contains one curve in the composite curve. The curves are contiguous, the collection of curves is ordered.
     *  NOTE: This definition allows for a nested structure, i.e. a CompositeCurve may use, for example, another CompositeCurve as a curve member.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RINGTYPE_TYPE = build_RINGTYPE_TYPE();

    private static ComplexType build_RINGTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "curveMember"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RingType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTRINGTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RingPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Encapsulates a ring to represent properties in features or geometry collections.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:Ring"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RINGPROPERTYTYPE_TYPE = build_RINGPROPERTYTYPE_TYPE();

    private static ComplexType build_RINGPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        RINGTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Ring"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RingPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiPointDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:MultiPoint"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTIPOINTDOMAINTYPE_TYPE = build_MULTIPOINTDOMAINTYPE_TYPE();

    private static ComplexType build_MULTIPOINTDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MULTIPOINTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "MultiPoint"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiPointDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiPointCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A discrete coverage type whose domain is defined by a collection of point&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:multiPointDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTIPOINTCOVERAGETYPE_TYPE =
            build_MULTIPOINTCOVERAGETYPE_TYPE();

    private static ComplexType build_MULTIPOINTCOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MULTIPOINTDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "multiPointDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiPointCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CountPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Property whose content is a Count.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:ValuePropertyType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:Count"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COUNTPROPERTYTYPE_TYPE = build_COUNTPROPERTYTYPE_TYPE();

    private static ComplexType build_COUNTPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Count"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CountPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        VALUEPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ConeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A cone is a gridded surface given as a
     *     family of conic sections whose control points vary linearly.
     *     NOTE! A 5-point ellipse with all defining positions identical
     *     is a point. Thus, a truncated elliptical cone can be given as a
     *     2x5 set of control points
     *     ((P1, P1, P1, P1, P1), (P2, P3, P4, P5, P6)). P1 is the apex
     *     of the cone. P2, P3,P4, P5 and P6 are any five distinct points
     *     around the base ellipse of the cone. If the horizontal curves
     *     are circles as opposed to ellipses, the a circular cone can
     *     be constructed using ((P1, P1, P1),(P2, P3, P4)). The apex most
     *     not coinside with the other plane.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGriddedSurfaceType"&gt;
     *              &lt;attribute fixed="circularArc3Points"
     *                  name="horizontalCurveType" type="gml:CurveInterpolationType"/&gt;
     *              &lt;attribute fixed="linear" name="verticalCurveType" type="gml:CurveInterpolationType"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CONETYPE_TYPE = build_CONETYPE_TYPE();

    private static ComplexType build_CONETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "horizontalCurveType"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "verticalCurveType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ConeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGRIDDEDSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EnvelopeWithTimePeriodType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Envelope that includes also a temporal extent.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:EnvelopeType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="2" minOccurs="2" ref="gml:timePosition"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute default="#ISO-8601" name="frame" type="anyURI" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENVELOPEWITHTIMEPERIODTYPE_TYPE =
            build_ENVELOPEWITHTIMEPERIODTYPE_TYPE();

    private static ComplexType build_ENVELOPEWITHTIMEPERIODTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "timePosition"),
                        2,
                        2,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "frame"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EnvelopeWithTimePeriodType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ENVELOPETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CategoryPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Property whose content is a Category.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:ValuePropertyType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:Category"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CATEGORYPROPERTYTYPE_TYPE = build_CATEGORYPROPERTYTYPE_TYPE();

    private static ComplexType build_CATEGORYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Category"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CategoryPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        VALUEPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SurfacePatchArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A container for an array of surface patches.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence maxOccurs="unbounded" minOccurs="0"&gt;
     *          &lt;element ref="gml:_SurfacePatch"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SURFACEPATCHARRAYPROPERTYTYPE_TYPE =
            build_SURFACEPATCHARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_SURFACEPATCHARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTSURFACEPATCHTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_SurfacePatch"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SurfacePatchArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Surface is a 2-dimensional primitive and is composed of one or more surface patches. The surface patches are connected to one another.
     *  				The orientation of the surface is positive ("up"). The orientation of a surface chooses an "up" direction through the choice of the upward normal, which, if the surface is not a cycle, is the side of the surface from which the exterior boundary appears counterclockwise. Reversal of the surface orientation reverses the curve orientation of each boundary component, and interchanges the conceptual "up" and "down" direction of the surface. If the surface is the boundary of a solid, the "up" direction is usually outward. For closed surfaces, which have no boundary, the up direction is that of the surface patches, which must be consistent with one another. Its included surface patches describe the interior structure of the Surface.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:patches"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This element encapsulates the patches of the surface.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SURFACETYPE_TYPE = build_SURFACETYPE_TYPE();

    private static AttributeType build_SURFACETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SurfaceType"),
                        org.locationtech.jts.geom.Polygon.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="SurfaceInterpolationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an
     *  application schema.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="none"/&gt;
     *          &lt;enumeration value="planar"/&gt;
     *          &lt;enumeration value="spherical"/&gt;
     *          &lt;enumeration value="elliptical"/&gt;
     *          &lt;enumeration value="conic"/&gt;
     *          &lt;enumeration value="tin"/&gt;
     *          &lt;enumeration value="parametricCurve"/&gt;
     *          &lt;enumeration value="polynomialSpline"/&gt;
     *          &lt;enumeration value="rationalSpline"/&gt;
     *          &lt;enumeration value="triangulatedSpline"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SURFACEINTERPOLATIONTYPE_TYPE =
            build_SURFACEINTERPOLATIONTYPE_TYPE();

    private static AttributeType build_SURFACEINTERPOLATIONTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SurfaceInterpolationType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PolygonPatchType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A PolygonPatch is a surface patch that is defined by a set of boundary curves and an underlying surface to which these curves adhere. The curves are coplanar and the polygon uses planar interpolation in its interior. Implements GM_Polygon of ISO 19107.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfacePatchType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:exterior"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:interior"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="planar" name="interpolation" type="gml:SurfaceInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the interpolation mechanism used for this surface patch. Currently only planar surface patches are defined in GML 3, the attribute is fixed to "planar", i.e. the interpolation method shall return points on a single plane. The boundary of the patch shall be contained within that plane.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType POLYGONPATCHTYPE_TYPE = build_POLYGONPATCHTYPE_TYPE();

    private static ComplexType build_POLYGONPATCHTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTRINGPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "exterior"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTRINGPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interior"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PolygonPatchType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACEPATCHTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PolygonPatchArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This type defines a container for an array of
     *     polygon patches.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:SurfacePatchArrayPropertyType"&gt;
     *              &lt;sequence maxOccurs="unbounded" minOccurs="0"&gt;
     *                  &lt;element ref="gml:PolygonPatch"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType POLYGONPATCHARRAYPROPERTYTYPE_TYPE =
            build_POLYGONPATCHARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_POLYGONPATCHARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        POLYGONPATCHTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "PolygonPatch"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PolygonPatchArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        SURFACEPATCHARRAYPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="PolyhedralSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A polyhedral surface is a surface composed
     *     of polygon surfaces connected along their common boundary
     *     curves. This differs from the surface type only in the
     *     restriction on the types of surface patches acceptable.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:SurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element ref="gml:polygonPatches"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This property encapsulates the patches of
     *        the polyhedral surface.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType POLYHEDRALSURFACETYPE_TYPE = build_POLYHEDRALSURFACETYPE_TYPE();

    private static ComplexType build_POLYHEDRALSURFACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POLYGONPATCHARRAYPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "polygonPatches"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "PolyhedralSurfaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        SURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SingleOperationRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a single operation, either referencing or containing the definition of that single operation. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_SingleOperation"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SINGLEOPERATIONREFTYPE_TYPE =
            build_SINGLEOPERATIONREFTYPE_TYPE();

    private static ComplexType build_SINGLEOPERATIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_SingleOperation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SingleOperationRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ConcatenatedOperationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An ordered sequence of two or more single coordinate operations. The sequence of operations is constrained by the requirement that the source coordinate reference system of step (n+1) must be the same as the target coordinate reference system of step (n). The source coordinate reference system of the first step and the target coordinate reference system of the last step are the source and target coordinate reference system associated with the concatenated operation. Instead of a forward operation, an inverse operation may be used for one or more of the operation steps mentioned above, if the inverse operation is uniquely defined by the forward operation.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateOperationType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="2" ref="gml:usesSingleOperation"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Ordered sequence of associations to the two or more single operations used by this concatenated operation. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CONCATENATEDOPERATIONTYPE_TYPE =
            build_CONCATENATEDOPERATIONTYPE_TYPE();

    private static ComplexType build_CONCATENATEDOPERATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SINGLEOPERATIONREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesSingleOperation"),
                        2,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ConcatenatedOperationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ConcatenatedOperationRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a concatenated operation, either referencing or containing the definition of that concatenated operation. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:ConcatenatedOperation"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CONCATENATEDOPERATIONREFTYPE_TYPE =
            build_CONCATENATEDOPERATIONREFTYPE_TYPE();

    private static ComplexType build_CONCATENATEDOPERATIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CONCATENATEDOPERATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "ConcatenatedOperation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ConcatenatedOperationRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeCurveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A CompositeCurve is defined by a sequence of (orientable) curves such that the each curve in the sequence terminates at the start point of the subsequent curve in the list.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:curveMember"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This element references or contains one curve in the composite curve. The curves are contiguous, the collection of curves is ordered.
     *  NOTE: This definition allows for a nested structure, i.e. a CompositeCurve may use, for example, another CompositeCurve as a curve member.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITECURVETYPE_TYPE = build_COMPOSITECURVETYPE_TYPE();

    private static ComplexType build_COMPOSITECURVETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "curveMember"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeCurveType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CompositeCurvePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:CompositeCurve"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType COMPOSITECURVEPROPERTYTYPE_TYPE =
            build_COMPOSITECURVEPROPERTYTYPE_TYPE();

    private static ComplexType build_COMPOSITECURVEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COMPOSITECURVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "CompositeCurve"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CompositeCurvePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimeComplexType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The abstract supertype for temporal complexes.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeObjectType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMECOMPLEXTYPE_TYPE =
            build_ABSTRACTTIMECOMPLEXTYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMECOMPLEXTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractTimeComplexType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEOBJECTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTimeTopologyPrimitiveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;The element "complex" carries a reference to the complex containing this primitive.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimePrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="complex" type="gml:ReferenceType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE =
            build_ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE();

    private static ComplexType build_ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        REFERENCETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "complex"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "AbstractTimeTopologyPrimitiveType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeTopologyPrimitivePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A time topology primitive property can either hold any time topology complex element
     *  			 eor carry an XLink reference to a remote time topology complex element
     *  			 (where remote includes elements located elsewhere in the same document).
     *  			 Note that either the reference or the contained element must be given, but not both or none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_TimeTopologyPrimitive"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMETOPOLOGYPRIMITIVEPROPERTYTYPE_TYPE =
            build_TIMETOPOLOGYPRIMITIVEPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMETOPOLOGYPRIMITIVEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_TimeTopologyPrimitive"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "TimeTopologyPrimitivePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeTopologyComplexType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;A temporal topology complex.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeComplexType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" name="primitive" type="gml:TimeTopologyPrimitivePropertyType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMETOPOLOGYCOMPLEXTYPE_TYPE =
            build_TIMETOPOLOGYCOMPLEXTYPE_TYPE();

    private static ComplexType build_TIMETOPOLOGYCOMPLEXTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMETOPOLOGYPRIMITIVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "primitive"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeTopologyComplexType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMECOMPLEXTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeTopologyComplexPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A time topology complex property can either be any time topology complex element
     *  			 encapsulated in an element of this type or an XLink reference to a remote time topology complex element
     *  			 (where remote includes elements located elsewhere in the same document).
     *  			 Note that either the reference or the contained element must be given, but not both or none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeTopologyComplex"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMETOPOLOGYCOMPLEXPROPERTYTYPE_TYPE =
            build_TIMETOPOLOGYCOMPLEXPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMETOPOLOGYCOMPLEXPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMETOPOLOGYCOMPLEXTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeTopologyComplex"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "TimeTopologyComplexPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="doubleOrNull"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Union of the XML Schema double type and the GML Nulltype.  An element which uses this type may have content which is either a double or a value from Nulltype&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="gml:NullEnumeration double anyURI"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DOUBLEORNULL_TYPE = build_DOUBLEORNULL_TYPE();

    private static AttributeType build_DOUBLEORNULL_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "doubleOrNull"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTopologyType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTOPOLOGYTYPE_TYPE = build_ABSTRACTTOPOLOGYTYPE_TYPE();

    private static ComplexType build_ABSTRACTTOPOLOGYTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractTopologyType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractTopoPrimitiveType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopologyType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element ref="gml:isolated" minOccurs="0" maxOccurs="unbounded"/&gt;
     *  					&lt;element ref="gml:container" minOccurs="0"/--&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTTOPOPRIMITIVETYPE_TYPE =
            build_ABSTRACTTOPOPRIMITIVETYPE_TYPE();

    private static ComplexType build_ABSTRACTTOPOPRIMITIVETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractTopoPrimitiveType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOLOGYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="FaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;. The topological boundary of a face consists of a set of directed edges. Note that all edges associated with a Face, including dangling and interior edges, appear in the boundary.  Dangling and interior edges are each referenced by pairs of directedEdges with opposing orientations.  The optional coboundary of a face is a pair of directed solids which are bounded by this face. If present, there is precisely one positively directed and one negatively directed solid in the coboundary of every face. The positively directed solid corresponds to the solid which lies in the direction of the positively directed normal to the face in any geometric realisation.  A face may optionally be realised by a 2-dimensional (surface) geometric primitive.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopoPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element ref="gml:directedEdge" maxOccurs="unbounded"/--&gt;
     *                  &lt;!--element ref="gml:directedTopoSolid" minOccurs="0" maxOccurs="2"/--&gt;
     *                  &lt;element minOccurs="0" ref="gml:surfaceProperty"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType FACETYPE_TYPE = build_FACETYPE_TYPE();

    private static ComplexType build_FACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "surfaceProperty"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectedFacePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Face"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute default="+" name="orientation" type="gml:SignType"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTEDFACEPROPERTYTYPE_TYPE =
            build_DIRECTEDFACEPROPERTYTYPE_TYPE();

    private static ComplexType build_DIRECTEDFACEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        FACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Face"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SIGNTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "orientation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectedFacePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoSolidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The topological boundary of a TopoSolid consists of a set of directed faces. Note that all faces associated with the TopoSolid, including dangling faces, appear in the boundary. The coboundary of a TopoSolid is empty and hence requires no representation.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopoPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:directedFace"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOSOLIDTYPE_TYPE = build_TOPOSOLIDTYPE_TYPE();

    private static ComplexType build_TOPOSOLIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedFace"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoSolidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ContainerPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;choice&gt;
     *              &lt;element ref="gml:Face"/&gt;
     *              &lt;element ref="gml:TopoSolid"/&gt;
     *          &lt;/choice&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CONTAINERPROPERTYTYPE_TYPE = build_CONTAINERPROPERTYTYPE_TYPE();

    private static ComplexType build_CONTAINERPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        FACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Face"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOSOLIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TopoSolid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ContainerPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CubicSplineType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Cubic splines are similar to line strings in that they are a sequence of segments each with its own defining function. A cubic spline uses the control points and a set of derivative parameters to define a piecewise 3rd degree polynomial interpolation. Unlike line-strings, the parameterization by arc length is not necessarily still a polynomial.
     *  				The function describing the curve must be C2, that is, have a continuous 1st and 2nd derivative at all points, and pass through the controlPoints in the order given. Between the control points, the curve segment is defined by a cubic polynomial. At each control point, the polynomial changes in such a manner that the 1st and 2nd derivative vectors are the same from either side. The control parameters record must contain vectorAtStart, and vectorAtEnd which are the unit tangent vectors at controlPoint[1] and controlPoint[n] where n = controlPoint.count.
     *  				Note: only the direction of the vectors is relevant, not their length.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only. The number of direct positions in the list must be at least three.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="2"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element name="vectorAtStart" type="gml:VectorType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;"vectorAtStart" is the unit tangent vector at the start point of the spline.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="vectorAtEnd" type="gml:VectorType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;"vectorAtEnd" is the unit tangent vector at the end point of the spline.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="cubicSpline" name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For a CubicSpline the interpolation is fixed as "cubicSpline".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute fixed="3" name="degree" type="integer"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The degree for a cubic spline is "3".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CUBICSPLINETYPE_TYPE = build_CUBICSPLINETYPE_TYPE();

    private static ComplexType build_CUBICSPLINETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "vectorAtStart"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VECTORTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "vectorAtEnd"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.INTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "degree"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CubicSplineType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="stringOrNull"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Union of the XML Schema string type and the GML Nulltype.  An element which uses this type may have content which is either a string or a value from Nulltype.  Note that a "string" may contain whitespace.  &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="gml:NullEnumeration string anyURI"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType STRINGORNULL_TYPE = build_STRINGORNULL_TYPE();

    private static AttributeType build_STRINGORNULL_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "stringOrNull"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="AbstractStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The value of the top-level property. It is an abstract element. Used as the head element of the substitution group for extensibility purposes.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ABSTRACTSTYLETYPE_TYPE = build_ABSTRACTSTYLETYPE_TYPE();

    private static ComplexType build_ABSTRACTSTYLETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AbstractStyleType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="SymbolTypeEnumeration"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Used to specify the type of the symbol used.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="svg"/&gt;
     *          &lt;enumeration value="xpath"/&gt;
     *          &lt;enumeration value="other"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType SYMBOLTYPEENUMERATION_TYPE =
            build_SYMBOLTYPEENUMERATION_TYPE();

    private static AttributeType build_SYMBOLTYPEENUMERATION_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SymbolTypeEnumeration"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SymbolType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The symbol property. Allows for remote referencing of symbols.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;any maxOccurs="unbounded" minOccurs="0" processContents="skip"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="symbolType" type="gml:SymbolTypeEnumeration" use="required"/&gt;
     *      &lt;attribute ref="gml:transform" use="optional"/&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SYMBOLTYPE_TYPE = build_SYMBOLTYPE_TYPE();

    private static ComplexType build_SYMBOLTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SYMBOLTYPEENUMERATION_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "symbolType"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "transform"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SymbolType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ScaleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a scale factor (or ratio) that has no physical unit. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a scale factor, such as percent, permil, or parts-per-million.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SCALETYPE_TYPE = build_SCALETYPE_TYPE();

    private static ComplexType build_SCALETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ScaleType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="StyleVariationType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Used to vary individual graphic parameters and attributes of the style, symbol or text.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="string"&gt;
     *              &lt;attribute name="styleProperty" type="string" use="required"/&gt;
     *              &lt;attribute name="featurePropertyRange" type="string" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType STYLEVARIATIONTYPE_TYPE = build_STYLEVARIATIONTYPE_TYPE();

    private static ComplexType build_STYLEVARIATIONTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "styleProperty"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "featurePropertyRange"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "StyleVariationType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BaseStyleDescriptorType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Base complex type for geometry, topology, label and graph styles.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="spatialResolution" type="gml:ScaleType"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="styleVariation" type="gml:StyleVariationType"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="smil20:animate"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="smil20:animateMotion"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="smil20:animateColor"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="smil20:set"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BASESTYLEDESCRIPTORTYPE_TYPE =
            build_BASESTYLEDESCRIPTORTYPE_TYPE();

    private static ComplexType build_BASESTYLEDESCRIPTORTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SCALETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "spatialResolution"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STYLEVARIATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "styleVariation"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SMIL20LANGSchema.ANIMATETYPE_TYPE,
                        new NameImpl("http://www.w3.org/2001/SMIL20/", "animate"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SMIL20LANGSchema.ANIMATEMOTIONTYPE_TYPE,
                        new NameImpl("http://www.w3.org/2001/SMIL20/", "animateMotion"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SMIL20LANGSchema.ANIMATECOLORTYPE_TYPE,
                        new NameImpl("http://www.w3.org/2001/SMIL20/", "animateColor"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SMIL20LANGSchema.SETTYPE_TYPE,
                        new NameImpl("http://www.w3.org/2001/SMIL20/", "set"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BaseStyleDescriptorType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType mixed="true" name="LabelType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Label is mixed -- composed of text and XPath expressions used to extract the useful information from the feature.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0"
     *              name="LabelExpression" type="string"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute ref="gml:transform" use="optional"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LABELTYPE_TYPE = build_LABELTYPE_TYPE();

    private static ComplexType build_LABELTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "LabelExpression"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "transform"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LabelType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LabelStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The style descriptor for labels of a feature, geometry or topology.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:BaseStyleDescriptorType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element name="style" type="string"/&gt;
     *                  &lt;element name="label" type="gml:LabelType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LABELSTYLETYPE_TYPE = build_LABELSTYLETYPE_TYPE();

    private static ComplexType build_LABELSTYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "style"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LABELTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "label"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LabelStyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        BASESTYLEDESCRIPTORTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LabelStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:LabelStyle"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LABELSTYLEPROPERTYTYPE_TYPE =
            build_LABELSTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_LABELSTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        LABELSTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "LabelStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LabelStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeometryStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The style descriptor for geometries of a feature.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:BaseStyleDescriptorType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;element ref="gml:symbol"/&gt;
     *                      &lt;element name="style" type="string"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                              &lt;documentation&gt;Deprecated in GML version 3.1.0. Use symbol with inline content instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element minOccurs="0" ref="gml:labelStyle"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute name="geometryProperty" type="string"/&gt;
     *              &lt;attribute name="geometryType" type="string"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEOMETRYSTYLETYPE_TYPE = build_GEOMETRYSTYLETYPE_TYPE();

    private static ComplexType build_GEOMETRYSTYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SYMBOLTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "symbol"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "style"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LABELSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "labelStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "geometryProperty"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "geometryType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeometryStyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        BASESTYLEDESCRIPTORTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeometryStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:GeometryStyle"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEOMETRYSTYLEPROPERTYTYPE_TYPE =
            build_GEOMETRYSTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_GEOMETRYSTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GEOMETRYSTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GeometryStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeometryStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopologyStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The style descriptor for topologies of a feature. Describes individual topology elements styles.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:BaseStyleDescriptorType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;element ref="gml:symbol"/&gt;
     *                      &lt;element name="style" type="string"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                              &lt;documentation&gt;Deprecated in GML version 3.1.0. Use symbol with inline content instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element minOccurs="0" ref="gml:labelStyle"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute name="topologyProperty" type="string"/&gt;
     *              &lt;attribute name="topologyType" type="string"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOLOGYSTYLETYPE_TYPE = build_TOPOLOGYSTYLETYPE_TYPE();

    private static ComplexType build_TOPOLOGYSTYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SYMBOLTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "symbol"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "style"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LABELSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "labelStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "topologyProperty"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "topologyType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopologyStyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        BASESTYLEDESCRIPTORTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopologyStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:TopologyStyle"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOLOGYSTYLEPROPERTYTYPE_TYPE =
            build_TOPOLOGYSTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_TOPOLOGYSTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOLOGYSTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TopologyStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopologyStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="QueryGrammarEnumeration"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Used to specify the grammar of the feature query mechanism.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="xpath"/&gt;
     *          &lt;enumeration value="xquery"/&gt;
     *          &lt;enumeration value="other"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType QUERYGRAMMARENUMERATION_TYPE =
            build_QUERYGRAMMARENUMERATION_TYPE();

    private static AttributeType build_QUERYGRAMMARENUMERATION_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "QueryGrammarEnumeration"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="FeatureStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The style descriptor for features.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGMLType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="featureConstraint" type="string"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:geometryStyle"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:topologyStyle"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:labelStyle"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute name="featureType" type="string" use="optional"/&gt;
     *              &lt;attribute name="baseType" type="string" use="optional"/&gt;
     *              &lt;attribute name="queryGrammar" type="gml:QueryGrammarEnumeration"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType FEATURESTYLETYPE_TYPE = build_FEATURESTYLETYPE_TYPE();

    private static ComplexType build_FEATURESTYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "featureConstraint"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GEOMETRYSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "geometryStyle"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOLOGYSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "topologyStyle"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LABELSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "labelStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "featureType"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "baseType"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        QUERYGRAMMARENUMERATION_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "queryGrammar"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FeatureStyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGMLTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="FeatureStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:FeatureStyle"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType FEATURESTYLEPROPERTYTYPE_TYPE =
            build_FEATURESTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_FEATURESTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        FEATURESTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "FeatureStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "FeatureStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="GraphTypeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Graph-specific styling property.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="TREE"/&gt;
     *          &lt;enumeration value="BICONNECTED"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType GRAPHTYPETYPE_TYPE = build_GRAPHTYPETYPE_TYPE();

    private static AttributeType build_GRAPHTYPETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GraphTypeType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="DrawingTypeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Graph-specific styling property.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="POLYLINE"/&gt;
     *          &lt;enumeration value="ORTHOGONAL"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType DRAWINGTYPETYPE_TYPE = build_DRAWINGTYPETYPE_TYPE();

    private static AttributeType build_DRAWINGTYPETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DrawingTypeType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="LineTypeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Graph-specific styling property.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="STRAIGHT"/&gt;
     *          &lt;enumeration value="BENT"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType LINETYPETYPE_TYPE = build_LINETYPETYPE_TYPE();

    private static AttributeType build_LINETYPETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LineTypeType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="AesheticCriteriaType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Graph-specific styling property.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="MIN_CROSSINGS"/&gt;
     *          &lt;enumeration value="MIN_AREA"/&gt;
     *          &lt;enumeration value="MIN_BENDS"/&gt;
     *          &lt;enumeration value="MAX_BENDS"/&gt;
     *          &lt;enumeration value="UNIFORM_BENDS"/&gt;
     *          &lt;enumeration value="MIN_SLOPES"/&gt;
     *          &lt;enumeration value="MIN_EDGE_LENGTH"/&gt;
     *          &lt;enumeration value="MAX_EDGE_LENGTH"/&gt;
     *          &lt;enumeration value="UNIFORM_EDGE_LENGTH"/&gt;
     *          &lt;enumeration value="MAX_ANGULAR_RESOLUTION"/&gt;
     *          &lt;enumeration value="MIN_ASPECT_RATIO"/&gt;
     *          &lt;enumeration value="MAX_SYMMETRIES"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType AESHETICCRITERIATYPE_TYPE = build_AESHETICCRITERIATYPE_TYPE();

    private static AttributeType build_AESHETICCRITERIATYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AesheticCriteriaType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GraphStyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] The style descriptor for a graph consisting of a number of features. Describes graph-specific style attributes.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:BaseStyleDescriptorType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="planar" type="boolean"/&gt;
     *                  &lt;element minOccurs="0" name="directed" type="boolean"/&gt;
     *                  &lt;element minOccurs="0" name="grid" type="boolean"/&gt;
     *                  &lt;element minOccurs="0" name="minDistance" type="double"/&gt;
     *                  &lt;element minOccurs="0" name="minAngle" type="double"/&gt;
     *                  &lt;element minOccurs="0" name="graphType" type="gml:GraphTypeType"/&gt;
     *                  &lt;element minOccurs="0" name="drawingType" type="gml:DrawingTypeType"/&gt;
     *                  &lt;element minOccurs="0" name="lineType" type="gml:LineTypeType"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="aestheticCriteria" type="gml:AesheticCriteriaType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRAPHSTYLETYPE_TYPE = build_GRAPHSTYLETYPE_TYPE();

    private static ComplexType build_GRAPHSTYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "planar"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directed"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "grid"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minDistance"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minAngle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GRAPHTYPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "graphType"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DRAWINGTYPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "drawingType"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LINETYPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "lineType"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        AESHETICCRITERIATYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "aestheticCriteria"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GraphStyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        BASESTYLEDESCRIPTORTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GraphStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation/&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:GraphStyle"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRAPHSTYLEPROPERTYTYPE_TYPE =
            build_GRAPHSTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_GRAPHSTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        GRAPHSTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "GraphStyle"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GraphStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="StyleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] Predefined concrete value of the top-level property. Encapsulates all other styling information.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractStyleType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:featureStyle"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:graphStyle"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType STYLETYPE_TYPE = build_STYLETYPE_TYPE();

    private static ComplexType build_STYLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        FEATURESTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "featureStyle"),
                        1,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        GRAPHSTYLEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "graphStyle"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "StyleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSTYLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeodesicStringType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A GeodesicString consists of sequence of
     *     geodesic segments. The type essentially combines a sequence of
     *     Geodesic into a single object.
     *     The GeodesicString is computed from two or more positions and an
     *     interpolation using geodesics defined from the geoid (or
     *     ellipsoid) of the co-ordinate reference system being used.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;choice&gt;
     *                  &lt;element ref="gml:posList"/&gt;
     *                  &lt;group maxOccurs="unbounded" minOccurs="2" ref="gml:geometricPositionGroup"/&gt;
     *              &lt;/choice&gt;
     *              &lt;attribute fixed="geodesic" name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the
     *       curve interpolation mechanism used for this segment. This
     *       mechanism uses the control points and control parameters to
     *       determine the position of this curve segment. For an
     *       GeodesicString the interpolation is fixed as "geodesic".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEODESICSTRINGTYPE_TYPE = build_GEODESICSTRINGTYPE_TYPE();

    private static ComplexType build_GEODESICSTRINGTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeodesicStringType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GeodesicType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A Geodesic consists of two distinct
     *     positions joined by a geodesic curve. The control points of
     *     a Geodesic shall lie on the geodesic between its start
     *     point and end points. Between these two points, a geodesic
     *     curve defined from ellipsoid or geoid model used by the
     *     co-ordinate reference systems may be used to interpolate
     *     other positions. Any other point in the controlPoint array
     *     must fall on this geodesic.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:GeodesicStringType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GEODESICTYPE_TYPE = build_GEODESICTYPE_TYPE();

    private static ComplexType build_GEODESICTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GeodesicType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        GEODESICSTRINGTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RelatedTimeType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:TimePrimitivePropertyType"&gt;
     *              &lt;attribute name="relativePosition"&gt;
     *                  &lt;simpleType&gt;
     *                      &lt;restriction base="string"&gt;
     *                          &lt;enumeration value="Before"/&gt;
     *                          &lt;enumeration value="After"/&gt;
     *                          &lt;enumeration value="Begins"/&gt;
     *                          &lt;enumeration value="Ends"/&gt;
     *                          &lt;enumeration value="During"/&gt;
     *                          &lt;enumeration value="Equals"/&gt;
     *                          &lt;enumeration value="Contains"/&gt;
     *                          &lt;enumeration value="Overlaps"/&gt;
     *                          &lt;enumeration value="Meets"/&gt;
     *                          &lt;enumeration value="OverlappedBy"/&gt;
     *                          &lt;enumeration value="MetBy"/&gt;
     *                          &lt;enumeration value="BegunBy"/&gt;
     *                          &lt;enumeration value="EndedBy"/&gt;
     *                      &lt;/restriction&gt;
     *                  &lt;/simpleType&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RELATEDTIMETYPE_TYPE = build_RELATEDTIMETYPE_TYPE();

    private static ComplexType build_RELATEDTIMETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RelatedTimeType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        TIMEPRIMITIVEPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeEdgeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Type declaration of the element "TimeEdge".&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeTopologyPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element name="start" type="gml:TimeNodePropertyType"/&gt;
     *  					&lt;element name="end" type="gml:TimeNodePropertyType"/--&gt;
     *                  &lt;element minOccurs="0" name="extent" type="gml:TimePeriodPropertyType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEEDGETYPE_TYPE = build_TIMEEDGETYPE_TYPE();

    private static ComplexType build_TIMEEDGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPERIODPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "extent"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeEdgeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeEdgePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A time edge property can either be any time edge element encapsulated in an element of this type
     *  			or an XLink reference to a remote time edge element (where remote includes elements located elsewhere in the same document).
     *  			Note that either the reference or the contained element must be given, but not both or none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeEdge"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEEDGEPROPERTYTYPE_TYPE = build_TIMEEDGEPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMEEDGEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEEDGETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeEdge"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeEdgePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeNodeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Type declaration of the element "TimeNode".&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeTopologyPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="previousEdge" type="gml:TimeEdgePropertyType"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="nextEdge" type="gml:TimeEdgePropertyType"/&gt;
     *                  &lt;element minOccurs="0" name="position" type="gml:TimeInstantPropertyType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMENODETYPE_TYPE = build_TIMENODETYPE_TYPE();

    private static ComplexType build_TIMENODETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEEDGEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "previousEdge"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEEDGEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "nextEdge"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEINSTANTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "position"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeNodeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMETOPOLOGYPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeNodePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A time node property can either be any time node element encapsulated in an element of this type
     *  			or an XLink reference to a remote time node element (where remote includes elements located elsewhere in the same document).
     *  			Note that either the reference or the contained element must be given, but not both or none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeNode"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMENODEPROPERTYTYPE_TYPE = build_TIMENODEPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMENODEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMENODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeNode"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeNodePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeOrdinalEraType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;Ordinal temporal reference systems are often hierarchically structured
     *        such that an ordinal era at a given level of the hierarchy includes a
     *        sequence of shorter, coterminous ordinal eras. This captured using the member/group properties.
     *
     *        Note that in this schema, TIme Ordinal Era is patterned on TimeEdge, which is a variation from ISO 19108.
     *        This is in order to fulfill the requirements of ordinal reference systems based on eras delimited by
     *        named points or nodes, which are common in geology, archeology, etc.
     *
     *        This change is subject of a change proposal to ISO&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="relatedTime" type="gml:RelatedTimeType"/&gt;
     *                  &lt;element name="start" type="gml:TimeNodePropertyType"/&gt;
     *                  &lt;element name="end" type="gml:TimeNodePropertyType"/&gt;
     *                  &lt;element minOccurs="0" name="extent" type="gml:TimePeriodPropertyType"/&gt;
     *                  &lt;!--element name="member" type="gml:TimeOrdinalEraPropertyType" minOccurs="0" maxOccurs="unbounded"&gt;
     *  						&lt;annotation&gt;
     *  							&lt;documentation&gt;An Era may be composed of several member Eras. The "member" element implements the association to the Era at the next level down the hierarchy.  "member" follows the standard GML property pattern whereby its (complex) value may be either described fully inline, or may be the target of a link carried on the member element and described fully elsewhere, either in the same document or from another service.&lt;/documentation&gt;
     *  						&lt;/annotation&gt;
     *  					&lt;/element--&gt;
     *                  &lt;element minOccurs="0" name="group" type="gml:ReferenceType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;In a particular Time System, an Era may be a member of a group.  The "group" element implements the back-pointer to the Era at the next level up in the hierarchy.
     *
     *  If the hierarchy is represented by describing the nested components fully in the their nested position inside "member" elements, then the parent can be easily inferred, so the group property is unnecessary.
     *
     *  However, if the hierarchy is represented by links carried on the "member" property elements, pointing to Eras described fully elsewhere, then it may be useful for a child (member) era to carry an explicit pointer back to its parent (group) Era.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEORDINALERATYPE_TYPE = build_TIMEORDINALERATYPE_TYPE();

    private static ComplexType build_TIMEORDINALERATYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        RELATEDTIMETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "relatedTime"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMENODEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "start"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMENODEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "end"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEPERIODPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "extent"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        REFERENCETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "group"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeOrdinalEraType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeOrdinalEraPropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TimeOrdinalEra"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEORDINALERAPROPERTYTYPE_TYPE =
            build_TIMEORDINALERAPROPERTYTYPE_TYPE();

    private static ComplexType build_TIMEORDINALERAPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEORDINALERATYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TimeOrdinalEra"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TimeOrdinalEraPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TimeOrdinalReferenceSystemType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation xml:lang="en"&gt;In an ordinal reference system the order of events in time can be well
     *        established, but the magnitude of the intervals between them can not be
     *        accurately determined (e.g. a stratigraphic sequence).&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTimeReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" name="component" type="gml:TimeOrdinalEraPropertyType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TIMEORDINALREFERENCESYSTEMTYPE_TYPE =
            build_TIMEORDINALREFERENCESYSTEMTYPE_TYPE();

    private static ComplexType build_TIMEORDINALREFERENCESYSTEMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TIMEORDINALERAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "component"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "TimeOrdinalReferenceSystemType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTIMEREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalCSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A one-dimensional coordinate system used to record the heights (or depths) of points. Such a coordinate system is usually dependent on the Earth's gravity field, perhaps loosely as when atmospheric pressure is the basis for the vertical coordinate system axis. A VerticalCS shall have one usesAxis association. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateSystemType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALCSTYPE_TYPE = build_VERTICALCSTYPE_TYPE();

    private static ComplexType build_VERTICALCSTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalCSType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalCSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a vertical coordinate system, either referencing or containing the definition of that coordinate system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:VerticalCS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALCSREFTYPE_TYPE = build_VERTICALCSREFTYPE_TYPE();

    private static ComplexType build_VERTICALCSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALCSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "VerticalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalCSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalDatumTypeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Type of a vertical datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:CodeType"&gt;
     *              &lt;attribute name="codeSpace" type="anyURI" use="required"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;Reference to a source of information specifying the values and meanings of all the allowed string values for this VerticalDatumTypeType. &lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/restriction&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALDATUMTYPETYPE_TYPE = build_VERTICALDATUMTYPETYPE_TYPE();

    private static ComplexType build_VERTICALDATUMTYPETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalDatumTypeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        CODETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalDatumType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A textual description and/or a set of parameters identifying a particular reference level surface used as a zero-height surface, including its position with respect to the Earth for any of the height types recognized by this standard. There are several types of Vertical Datums, and each may place constraints on the Coordinate Axis with which it is combined to create a Vertical CRS. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractDatumType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" ref="gml:verticalDatumType"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALDATUMTYPE_TYPE = build_VERTICALDATUMTYPE_TYPE();

    private static ComplexType build_VERTICALDATUMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALDATUMTYPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "verticalDatumType"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalDatumType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDATUMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalDatumRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a vertical datum, either referencing or containing the definition of that datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:VerticalDatum"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALDATUMREFTYPE_TYPE = build_VERTICALDATUMREFTYPE_TYPE();

    private static ComplexType build_VERTICALDATUMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALDATUMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "VerticalDatum"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalDatumRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A 1D coordinate reference system used for recording heights or depths. Vertical CRSs make use of the direction of gravity to define the concept of height or depth, but the relationship with gravity may not be straightforward. By implication, ellipsoidal heights (h) cannot be captured in a vertical coordinate reference system. Ellipsoidal heights cannot exist independently, but only as an inseparable part of a 3D coordinate tuple defined in a geographic 3D coordinate reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesVerticalCS"/&gt;
     *                  &lt;element ref="gml:usesVerticalDatum"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALCRSTYPE_TYPE = build_VERTICALCRSTYPE_TYPE();

    private static ComplexType build_VERTICALCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALCSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesVerticalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALDATUMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesVerticalDatum"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VerticalCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a vertical coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:VerticalCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VERTICALCRSREFTYPE_TYPE = build_VERTICALCRSREFTYPE_TYPE();

    private static ComplexType build_VERTICALCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        VERTICALCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "VerticalCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VerticalCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="OperationParameterGroupBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Basic encoding for operation parameter group objects, simplifying and restricting the DefinitionType as needed. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractGeneralOperationParameterType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:groupName"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:minimumOccurs"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERGROUPBASETYPE_TYPE =
            build_OPERATIONPARAMETERGROUPBASETYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERGROUPBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "groupName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "minimumOccurs"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "OperationParameterGroupBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALOPERATIONPARAMETERTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationParameterGroupType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The definition of a group of parameters used by an operation method. This complexType is expected to be used or extended for all applicable operation methods, without defining operation-method-specialized element names.  &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:OperationParameterGroupBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:groupID"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Set of alternative identifications of this operation parameter group. The first groupID, if any, is normally the primary identification code, and any others are aliases. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:remarks"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Comments on or information about this operation parameter group, including source information. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element minOccurs="0" ref="gml:maximumOccurs"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="2" ref="gml:includesParameter"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Unordered list of associations to the set of operation parameters that are members of this group. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERGROUPTYPE_TYPE =
            build_OPERATIONPARAMETERGROUPTYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERGROUPTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "groupID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remarks"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.POSITIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "maximumOccurs"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGENERALOPERATIONPARAMETERREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "includesParameter"),
                        2,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "OperationParameterGroupType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        OPERATIONPARAMETERGROUPBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationParameterGroupRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an operation parameter, either referencing or containing the definition of that parameter. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:OperationParameterGroup"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONPARAMETERGROUPREFTYPE_TYPE =
            build_OPERATIONPARAMETERGROUPREFTYPE_TYPE();

    private static ComplexType build_OPERATIONPARAMETERGROUPREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONPARAMETERGROUPTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "OperationParameterGroup"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "OperationParameterGroupRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ParameterValueGroupType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A group of related parameter values. The same group can be repeated more than once in a Conversion, Transformation, or higher level parameterValueGroup, if those instances contain different values of one or more parameterValues which suitably distinquish among those groups. This concrete complexType can be used for operation methods without using an Application Schema that defines operation-method-specialized element names and contents, especially for methods with only one instance. This complexType can be used, extended, or restricted for well-known operation methods, especially for methods with many instances. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeneralParameterValueType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="2" ref="gml:includesValue"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Unordered set of composition associations to the parameter values and groups of values included in this group. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element ref="gml:valuesOfGroup"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType PARAMETERVALUEGROUPTYPE_TYPE =
            build_PARAMETERVALUEGROUPTYPE_TYPE();

    private static ComplexType build_PARAMETERVALUEGROUPTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTGENERALPARAMETERVALUETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "includesValue"),
                        2,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        OPERATIONPARAMETERGROUPREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "valuesOfGroup"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ParameterValueGroupType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGENERALPARAMETERVALUETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="integerOrNull"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Union of the XML Schema integer type and the GML Nulltype.  An element which uses this type may have content which is either an integer or a value from Nulltype&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union memberTypes="gml:NullEnumeration integer anyURI"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType INTEGERORNULL_TYPE = build_INTEGERORNULL_TYPE();

    private static AttributeType build_INTEGERORNULL_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "integerOrNull"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiGeometryPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A property that has a geometric aggregate as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_GeometricAggregate"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
     *  A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.&lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTIGEOMETRYPROPERTYTYPE_TYPE =
            build_MULTIGEOMETRYPROPERTYTYPE_TYPE();

    private static AttributeType build_MULTIGEOMETRYPROPERTYTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiGeometryPropertyType"),
                        org.locationtech.jts.geom.GeometryCollection.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="RectangleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Represents a rectangle as a surface with an outer boundary consisting of a linear ring. Note that this is a polygon (subtype) with no inner boundaries. The number of points in the linear ring must be five.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfacePatchType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:exterior"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Constraint: The Ring shall be a LinearRing and must form a rectangle; the first and the last position must be co-incident.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="planar" name="interpolation" type="gml:SurfaceInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the interpolation mechanism used for this surface patch. Currently only planar surface patches are defined in GML 3, the attribute is fixed to "planar", i.e. the interpolation method shall return points on a single plane. The boundary of the patch shall be contained within that plane.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType RECTANGLETYPE_TYPE = build_RECTANGLETYPE_TYPE();

    private static ComplexType build_RECTANGLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTRINGPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "exterior"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "RectangleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACEPATCHTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DefaultStylePropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;[complexType of] Top-level property. Used in application schemas to "attach" the styling information to GML data. The link between the data and the style should be established through this property only.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element minOccurs="0" ref="gml:_Style"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute name="about" type="anyURI" use="optional"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DEFAULTSTYLEPROPERTYTYPE_TYPE =
            build_DEFAULTSTYLEPROPERTYTYPE_TYPE();

    private static ComplexType build_DEFAULTSTYLEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTSTYLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Style"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "about"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DefaultStylePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EdgeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;There is precisely one positively directed and one negatively directed node in the boundary of every edge. The negatively and positively directed nodes correspond to the start and end nodes respectively. The optional coboundary of an edge is a circular sequence of directed faces which are incident on this edge in document order. Faces which use a particular boundary edge in its positive orientation appear with positive orientation on the coboundary of the same edge. In the 2D case, the orientation of the face on the left of the edge is "+"; the orientation of the face on the right on its right is "-". An edge may optionally be realised by a 1-dimensional (curve) geometric primitive.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopoPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;!--element ref="gml:directedNode" minOccurs="2" maxOccurs="2"/--&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:directedFace"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:curveProperty"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType EDGETYPE_TYPE = build_EDGETYPE_TYPE();

    private static ComplexType build_EDGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedFace"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "curveProperty"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EdgeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectedEdgePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Edge"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute default="+" name="orientation" type="gml:SignType"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTEDEDGEPROPERTYTYPE_TYPE =
            build_DIRECTEDEDGEPROPERTYTYPE_TYPE();

    private static ComplexType build_DIRECTEDEDGEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        EDGETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Edge"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SIGNTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "orientation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectedEdgePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoCurveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The end Node of each directedEdge of a TopoCurveType
     *  is the start Node of the next directedEdge of the TopoCurveType in document order.  The TopoCurve type and element represent a homogeneous topological expression, a list of directed edges, which if realised are isomorphic to a geometric curve primitive. The intended use of TopoCurve is to appear within a line feature instance to express the structural and geometric relationships of this line to other features via the shared edge definitions.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopologyType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:directedEdge"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOCURVETYPE_TYPE = build_TOPOCURVETYPE_TYPE();

    private static ComplexType build_TOPOCURVETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDEDGEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedEdge"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoCurveType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOLOGYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoCurvePropertyType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:TopoCurve"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOCURVEPROPERTYTYPE_TYPE = build_TOPOCURVEPROPERTYTYPE_TYPE();

    private static ComplexType build_TOPOCURVEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOCURVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TopoCurve"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoCurvePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="VolumeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a spatial volume quantity, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for a volume, such as cubic metres or cubic feet.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType VOLUMETYPE_TYPE = build_VOLUMETYPE_TYPE();

    private static ComplexType build_VOLUMETYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "VolumeType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SolidArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A container for an array of solids. The elements are always contained in the array property, referencing geometry elements or arrays of geometry elements is not supported.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence maxOccurs="unbounded" minOccurs="0"&gt;
     *          &lt;element ref="gml:_Solid"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SOLIDARRAYPROPERTYTYPE_TYPE =
            build_SOLIDARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_SOLIDARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTSOLIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Solid"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SolidArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSolidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A MultiSolid is defined by one or more Solids, referenced through solidMember elements.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricAggregateType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The members of the geometric aggregate can be specified either using the "standard" property or the array property style. It is also valid to use both the "standard" and the array property style in the same collection.
     *  NOTE: Array properties cannot reference remote geometry elements.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:solidMember"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:solidMembers"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTISOLIDTYPE_TYPE = build_MULTISOLIDTYPE_TYPE();

    private static ComplexType build_MULTISOLIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SOLIDPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "solidMember"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SOLIDARRAYPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "solidMembers"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSolidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICAGGREGATETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSolidDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:MultiSolid"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTISOLIDDOMAINTYPE_TYPE = build_MULTISOLIDDOMAINTYPE_TYPE();

    private static ComplexType build_MULTISOLIDDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MULTISOLIDTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "MultiSolid"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSolidDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiSolidCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A discrete coverage type whose domain is defined by a collection of Solids.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:multiSolidDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTISOLIDCOVERAGETYPE_TYPE =
            build_MULTISOLIDCOVERAGETYPE_TYPE();

    private static ComplexType build_MULTISOLIDCOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MULTISOLIDDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "multiSolidDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiSolidCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DictionaryEntryType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An entry in a dictionary of definitions. An instance of this type contains or refers to a definition object.
     *
     *  The number of definitions contained in this dictionaryEntry is restricted to one, but a DefinitionCollection or Dictionary that contains multiple definitions can be substituted if needed. Specialized descendents of this dictionaryEntry might be restricted in an application schema to allow only including specified types of definitions as valid entries in a dictionary. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Definition"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;This element in a dictionary entry contains the actual definition. &lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"&gt;
     *          &lt;annotation&gt;
     *              &lt;documentation&gt;A non-identified reference to a remote entry in this dictionary, to be used when this entry need not be identified to allow external references to this specific entry. The remote entry referenced will usually be in a dictionary in the same XML document. This element will usually be used in dictionaries that are inside of another dictionary. &lt;/documentation&gt;
     *          &lt;/annotation&gt;
     *      &lt;/attributeGroup&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DICTIONARYENTRYTYPE_TYPE = build_DICTIONARYENTRYTYPE_TYPE();

    private static ComplexType build_DICTIONARYENTRYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DEFINITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Definition"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DictionaryEntryType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DefinitionProxyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A proxy entry in a dictionary of definitions. An element of this type contains a reference to a remote definition object. This entry is expected to be convenient in allowing multiple elements in one XML document to contain short (abbreviated XPointer) references, which are resolved to an external definition provided in a Dictionary element in the same XML document. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:definitionRef"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;A reference to a remote entry in this dictionary, used when this dictionary entry is identified to allow external references to this specific entry. The remote entry referenced can be in a dictionary in the same or different XML document. &lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DEFINITIONPROXYTYPE_TYPE = build_DEFINITIONPROXYTYPE_TYPE();

    private static ComplexType build_DEFINITIONPROXYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        REFERENCETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "definitionRef"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DefinitionProxyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="IndirectEntryType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An entry in a dictionary of definitions that contains a GML object which references a remote definition object. This entry is expected to be convenient in allowing multiple elements in one XML document to contain short (abbreviated XPointer) references, which are resolved to an external definition provided in a Dictionary element in the same XML document. Specialized descendents of this dictionaryEntry might be restricted in an application schema to allow only including specified types of definitions as valid entries in a dictionary. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:DefinitionProxy"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType INDIRECTENTRYTYPE_TYPE = build_INDIRECTENTRYTYPE_TYPE();

    private static ComplexType build_INDIRECTENTRYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DEFINITIONPROXYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "DefinitionProxy"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "IndirectEntryType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DictionaryType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A non-abstract bag that is specialized for use as a dictionary which contains a set of definitions. These definitions are referenced from other places, in the same and different XML documents. In this restricted type, the inherited optional "description" element can be used for a description of this dictionary. The inherited optional "name" element can be used for the name(s) of this dictionary. The inherited "metaDataProperty" elements can be used to reference or contain more information about this dictionary. The inherited required gml:id attribute allows the dictionary to be referenced using this handle. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:DefinitionType"&gt;
     *              &lt;sequence maxOccurs="unbounded" minOccurs="0"&gt;
     *                  &lt;choice&gt;
     *                      &lt;element ref="gml:dictionaryEntry"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;An entry in this dictionary. The content of an entry can itself be a lower level dictionary or definition collection. This element follows the standard GML property model, so the value may be provided directly or by reference. Note that if the value is provided by reference, this definition does not carry a handle (gml:id) in this context, so does not allow external references to this specific entry in this context. When used in this way the referenced definition will usually be in a dictionary in the same XML document. &lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                      &lt;element ref="gml:indirectEntry"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;An identified reference to a remote entry in this dictionary, to be used when this entry should be identified to allow external references to this specific entry. &lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DICTIONARYTYPE_TYPE = build_DICTIONARYTYPE_TYPE();

    private static ComplexType build_DICTIONARYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DICTIONARYENTRYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "dictionaryEntry"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        INDIRECTENTRYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "indirectEntry"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DictionaryType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DEFINITIONTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="KnotType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A knot is a breakpoint on a piecewise spline curve.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="value" type="double"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The property "value" is the value of the parameter at the knot of the spline. The sequence of knots shall be a non-decreasing sequence. That is, each knot's value in the sequence shall be equal to or greater than the previous knot's value. The use of equal consecutive knots is normally handled using the multiplicity.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element name="multiplicity" type="nonNegativeInteger"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The property "multiplicity" is the multiplicity of this knot used in the definition of the spline (with the same weight).&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *          &lt;element name="weight" type="double"&gt;
     *              &lt;annotation&gt;
     *                  &lt;documentation&gt;The property "weight" is the value of the averaging weight used for this knot of the spline.&lt;/documentation&gt;
     *              &lt;/annotation&gt;
     *          &lt;/element&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType KNOTTYPE_TYPE = build_KNOTTYPE_TYPE();

    private static ComplexType build_KNOTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "value"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "multiplicity"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DOUBLE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "weight"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "KnotType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="KnotPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Encapsulates a knot to use it in a geometric type.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element name="Knot" type="gml:KnotType"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType KNOTPROPERTYTYPE_TYPE = build_KNOTPROPERTYTYPE_TYPE();

    private static ComplexType build_KNOTPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        KNOTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Knot"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "KnotPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="KnotTypesType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Defines allowed values for the knots` type. Uniform knots implies that all knots are of multiplicity 1 and they differ by a positive constant from the preceding knot. Knots are quasi-uniform iff they are of multiplicity (degree + 1) at the ends, of multiplicity 1 elsewhere, and they differ by a positive constant from the preceding knot.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;restriction base="string"&gt;
     *          &lt;enumeration value="uniform"/&gt;
     *          &lt;enumeration value="quasiUniform"/&gt;
     *          &lt;enumeration value="piecewiseBezier"/&gt;
     *      &lt;/restriction&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType KNOTTYPESTYPE_TYPE = build_KNOTTYPESTYPE_TYPE();

    private static AttributeType build_KNOTTYPESTYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "KnotTypesType"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.STRING_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BSplineType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A B-Spline is a piecewise parametric polynomial or rational curve described in terms of control points and basis functions. Knots are breakpoints on the curve that connect its pieces. They are given as a non-decreasing sequence of real numbers. If the weights in the knots are equal then it is a polynomial spline. The degree is the algebraic degree of the basis functions.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element name="degree" type="nonNegativeInteger"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute "degree" shall be the degree of the polynomial used for interpolation in this spline.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="2" name="knot" type="gml:KnotPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The property "knot" shall be the sequence of distinct knots used to define the spline basis functions.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute default="polynomialSpline" name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For a BSpline the interpolation can be either "polynomialSpline" or "rationalSpline", default is "polynomialSpline".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute name="isPolynomial" type="boolean" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute isPolynomial is set to true if this is a polynomial spline.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute name="knotType" type="gml:KnotTypesType" use="optional"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "knotType" gives the type of knot distribution used in defining this spline. This is for information only
     *  and is set according to the different construction-functions.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BSPLINETYPE_TYPE = build_BSPLINETYPE_TYPE();

    private static ComplexType build_BSPLINETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "degree"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        KNOTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "knot"),
                        2,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "isPolynomial"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        KNOTTYPESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "knotType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BSplineType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BezierType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Bezier curves are polynomial splines that use Bezier or Bernstein polynomials for interpolation purposes. It is a special case of the B-Spline curve with two knots.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:BSplineType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *                  &lt;element name="degree" type="nonNegativeInteger"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The attribute "degree" shall be the degree of the polynomial used for interpolation in this spline.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="2" minOccurs="2" name="knot" type="gml:KnotPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The property "knot" shall be the sequence of distinct knots used to define the spline basis functions.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="polynomialSpline" name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For a Bezier the interpolation is fixed as "polynomialSpline".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute fixed="true" name="isPolynomial" type="boolean"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute isPolynomial is set to true as this is a polynomial spline.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *              &lt;attribute name="knotType" type="gml:KnotTypesType" use="prohibited"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The property "knotType" is not relevant for Bezier curve segments.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BEZIERTYPE_TYPE = build_BEZIERTYPE_TYPE();

    private static ComplexType build_BEZIERTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.NONNEGATIVEINTEGER_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "degree"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        KNOTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "knot"),
                        2,
                        2,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "isPolynomial"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        KNOTTYPESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "knotType"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BezierType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        BSPLINETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DatumRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a datum, either referencing or containing the definition of that datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Datum"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DATUMREFTYPE_TYPE = build_DATUMREFTYPE_TYPE();

    private static ComplexType build_DATUMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTDATUMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Datum"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DatumRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalCSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A one-dimensional coordinate system containing a single time axis, used to describe the temporal position of a point in the specified time units from a specified time origin. A TemporalCS shall have one usesAxis association. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCoordinateSystemType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALCSTYPE_TYPE = build_TEMPORALCSTYPE_TYPE();

    private static ComplexType build_TEMPORALCSTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalCSType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCOORDINATESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalCSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a temporal coordinate system, either referencing or containing the definition of that coordinate system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TemporalCS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALCSREFTYPE_TYPE = build_TEMPORALCSREFTYPE_TYPE();

    private static ComplexType build_TEMPORALCSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TEMPORALCSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TemporalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalCSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="TemporalDatumBaseType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Partially defines the origin of a temporal coordinate reference system. This type restricts the AbstractDatumType to remove the "anchorPoint" and "realizationEpoch" elements. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDatumType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:metaDataProperty"/&gt;
     *                  &lt;element ref="gml:datumName"/&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:datumID"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:validArea"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:scope"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute ref="gml:id" use="required"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALDATUMBASETYPE_TYPE = build_TEMPORALDATUMBASETYPE_TYPE();

    private static ComplexType build_TEMPORALDATUMBASETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "datumName"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        IDENTIFIERTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "datumID"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EXTENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "validArea"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "scope"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ID_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "id"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalDatumBaseType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDATUMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalDatumType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Defines the origin of a temporal coordinate reference system. This type extends the TemporalDatumRestrictionType to add the "origin" element with the dateTime type. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:TemporalDatumBaseType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:origin"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALDATUMTYPE_TYPE = build_TEMPORALDATUMTYPE_TYPE();

    private static ComplexType build_TEMPORALDATUMTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.DATETIME_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "origin"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalDatumType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        TEMPORALDATUMBASETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalDatumRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a temporal datum, either referencing or containing the definition of that datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TemporalDatum"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALDATUMREFTYPE_TYPE = build_TEMPORALDATUMREFTYPE_TYPE();

    private static ComplexType build_TEMPORALDATUMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TEMPORALDATUMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TemporalDatum"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalDatumRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A 1D coordinate reference system used for the recording of time. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesTemporalCS"/&gt;
     *                  &lt;element ref="gml:usesTemporalDatum"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALCRSTYPE_TYPE = build_TEMPORALCRSTYPE_TYPE();

    private static ComplexType build_TEMPORALCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TEMPORALCSREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesTemporalCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TEMPORALDATUMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesTemporalDatum"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TemporalCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a temporal coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:TemporalCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TEMPORALCRSREFTYPE_TYPE = build_TEMPORALCRSREFTYPE_TYPE();

    private static ComplexType build_TEMPORALCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TEMPORALCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TemporalCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TemporalCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The TopoSurface type and element represent a homogeneous topological expression, a set of directed faces, which if realised are isomorphic to a geometric surface primitive. The intended use of TopoSurface is to appear within a surface feature instance to express the structural and possibly geometric relationships of this surface to other features via the shared face definitions.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopologyType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" ref="gml:directedFace"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOSURFACETYPE_TYPE = build_TOPOSURFACETYPE_TYPE();

    private static ComplexType build_TOPOSURFACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedFace"),
                        1,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoSurfaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOLOGYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoSurfacePropertyType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:TopoSurface"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOSURFACEPROPERTYTYPE_TYPE =
            build_TOPOSURFACEPROPERTYTYPE_TYPE();

    private static ComplexType build_TOPOSURFACEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOSURFACETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TopoSurface"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoSurfacePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="ReferenceSystemRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to a reference system, either referencing or containing the definition of that reference system.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_ReferenceSystem"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType REFERENCESYSTEMREFTYPE_TYPE =
            build_REFERENCESYSTEMREFTYPE_TYPE();

    private static ComplexType build_REFERENCESYSTEMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_ReferenceSystem"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "ReferenceSystemRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="AreaType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a spatial area quantity, with its units. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for an area, such as square metres or square miles.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType AREATYPE_TYPE = build_AREATYPE_TYPE();

    private static ComplexType build_AREATYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "AreaType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EngineeringDatumType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;An engineering datum defines the origin of an engineering coordinate reference system, and is used in a region around that origin. This origin can be fixed with respect to the earth (such as a defined point at a construction site), or be a defined point on a moving vehicle (such as on a ship or satellite). &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractDatumType"/&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENGINEERINGDATUMTYPE_TYPE = build_ENGINEERINGDATUMTYPE_TYPE();

    private static ComplexType build_ENGINEERINGDATUMTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EngineeringDatumType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDATUMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EngineeringDatumRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an engineering datum, either referencing or containing the definition of that datum. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:EngineeringDatum"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENGINEERINGDATUMREFTYPE_TYPE =
            build_ENGINEERINGDATUMREFTYPE_TYPE();

    private static ComplexType build_ENGINEERINGDATUMREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ENGINEERINGDATUMTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "EngineeringDatum"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EngineeringDatumRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EngineeringCRSType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A contextually local coordinate reference system; which can be divided into two broad categories:
     *  - earth-fixed systems applied to engineering activities on or near the surface of the earth;
     *  - CRSs on moving platforms such as road vehicles, vessels, aircraft, or spacecraft.
     *  For further information, see OGC Abstract Specification Topic 2. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractReferenceSystemType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:usesCS"/&gt;
     *                  &lt;element ref="gml:usesEngineeringDatum"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENGINEERINGCRSTYPE_TYPE = build_ENGINEERINGCRSTYPE_TYPE();

    private static ComplexType build_ENGINEERINGCRSTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESYSTEMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesCS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        ENGINEERINGDATUMREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "usesEngineeringDatum"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EngineeringCRSType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTREFERENCESYSTEMTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="EngineeringCRSRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an engineering coordinate reference system, either referencing or containing the definition of that reference system. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:EngineeringCRS"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ENGINEERINGCRSREFTYPE_TYPE = build_ENGINEERINGCRSREFTYPE_TYPE();

    private static ComplexType build_ENGINEERINGCRSREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ENGINEERINGCRSTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "EngineeringCRS"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "EngineeringCRSRefType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="NodeType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Its optional co-boundary is a set of connected directedEdges.  The orientation of one of these dirEdges is "+" if the Node is the "to" node of the Edge, and "-" if it is the "from" node.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopoPrimitiveType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:directedEdge"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:pointProperty"/&gt;
     *                  &lt;!-- &lt;element name="geometry" type="gml:PointPropertyType" minOccurs="0"/&gt; --&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType NODETYPE_TYPE = build_NODETYPE_TYPE();

    private static ComplexType build_NODETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDEDGEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedEdge"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NodeType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOPRIMITIVETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="IsolatedPropertyType"&gt;
     *      &lt;choice minOccurs="0"&gt;
     *          &lt;element ref="gml:Node"/&gt;
     *          &lt;element ref="gml:Edge"/&gt;
     *      &lt;/choice&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType ISOLATEDPROPERTYTYPE_TYPE = build_ISOLATEDPROPERTYTYPE_TYPE();

    private static ComplexType build_ISOLATEDPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        NODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Node"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        EDGETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Edge"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "IsolatedPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="NullEnumeration"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt; Some common reasons for a null value:
     *
     *          innapplicable - the object does not have a value
     *          missing - The correct value is not readily available to the sender of this data.
     *                             Furthermore, a correct value may not exist.
     *          template - the value will be available later
     *          unknown - The correct value is not known to, and not computable by, the sender of this data.
     *                             However, a correct value probably exists.
     *          withheld - the value is not divulged
     *
     *          other:reason - as indicated by "reason" string
     *
     *          Specific communities may agree to assign more strict semantics when these terms are used in a particular context.
     *        &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;union&gt;
     *          &lt;simpleType&gt;
     *              &lt;restriction base="string"&gt;
     *                  &lt;enumeration value="inapplicable"/&gt;
     *                  &lt;enumeration value="missing"/&gt;
     *                  &lt;enumeration value="template"/&gt;
     *                  &lt;enumeration value="unknown"/&gt;
     *                  &lt;enumeration value="withheld"/&gt;
     *              &lt;/restriction&gt;
     *          &lt;/simpleType&gt;
     *          &lt;simpleType&gt;
     *              &lt;restriction base="string"&gt;
     *                  &lt;pattern value="other:\w{2,}"/&gt;
     *              &lt;/restriction&gt;
     *          &lt;/simpleType&gt;
     *      &lt;/union&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType NULLENUMERATION_TYPE = build_NULLENUMERATION_TYPE();

    private static AttributeType build_NULLENUMERATION_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NullEnumeration"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CurveArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A container for an array of curves. The elements are always contained in the array property, referencing geometry elements
     *  			or arrays of geometry elements is not supported.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:_Curve"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CURVEARRAYPROPERTYTYPE_TYPE =
            build_CURVEARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_CURVEARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTCURVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Curve"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CurveArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiCurveType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A MultiCurve is defined by one or more Curves, referenced through curveMember elements.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractGeometricAggregateType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The members of the geometric aggregate can be specified either using the "standard" property or the array property style. It is also valid to use both the "standard" and the array property style in the same collection.
     *  NOTE: Array properties cannot reference remote geometry elements.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:curveMember"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:curveMembers"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType MULTICURVETYPE_TYPE = build_MULTICURVETYPE_TYPE();

    private static AttributeType build_MULTICURVETYPE_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiCurveType"),
                        MultiCurvedGeometry.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTGEOMETRICAGGREGATETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiCurveDomainType"&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:DomainSetType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:MultiCurve"/&gt;
     *              &lt;/sequence&gt;
     *              &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTICURVEDOMAINTYPE_TYPE = build_MULTICURVEDOMAINTYPE_TYPE();

    private static ComplexType build_MULTICURVEDOMAINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        MULTICURVETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "MultiCurve"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiCurveDomainType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        DOMAINSETTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="MultiCurveCoverageType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A discrete coverage type whose domain is defined by a collection of curves.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractDiscreteCoverageType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:boundedBy"/&gt;
     *                  &lt;element ref="gml:multiCurveDomain"/&gt;
     *                  &lt;element ref="gml:rangeSet"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:coverageFunction"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType MULTICURVECOVERAGETYPE_TYPE =
            build_MULTICURVECOVERAGETYPE_TYPE();

    private static ComplexType build_MULTICURVECOVERAGETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        MULTICURVEDOMAINTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "multiCurveDomain"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        RANGESETTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "rangeSet"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COVERAGEFUNCTIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coverageFunction"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "MultiCurveCoverageType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTDISCRETECOVERAGETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;simpleType name="NameList"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;XML List based on XML Schema Name type.  An element of this type contains a space-separated list of Name values&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;list itemType="Name"/&gt;
     *  &lt;/simpleType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final AttributeType NAMELIST_TYPE = build_NAMELIST_TYPE();

    private static AttributeType build_NAMELIST_TYPE() {
        AttributeType builtType;
        builtType =
                new AttributeTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "NameList"),
                        java.lang.Object.class,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYSIMPLETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="CodeListType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;List of values on a uniform nominal scale.  List of text tokens.
     *        In a list context a token should not include any spaces, so xsd:Name is used instead of xsd:string.
     *        If a codeSpace attribute is present, then its value is a reference to
     *        a Reference System for the value, a dictionary or code list.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;extension base="gml:NameList"&gt;
     *              &lt;attribute name="codeSpace" type="anyURI" use="optional"/&gt;
     *          &lt;/extension&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType CODELISTTYPE_TYPE = build_CODELISTTYPE_TYPE();

    private static ComplexType build_CODELISTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "codeSpace"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "CodeListType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        NAMELIST_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="BooleanPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Property whose content is a Boolean value.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:ValuePropertyType"&gt;
     *              &lt;sequence minOccurs="0"&gt;
     *                  &lt;element ref="gml:Boolean"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BOOLEANPROPERTYTYPE_TYPE = build_BOOLEANPROPERTYTYPE_TYPE();

    private static ComplexType build_BOOLEANPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.BOOLEAN_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Boolean"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BooleanPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        VALUEPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TriangleType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Represents a triangle as a surface with an outer boundary consisting of a linear ring. Note that this is a polygon (subtype) with no inner boundaries. The number of points in the linear ring must be four.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSurfacePatchType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:exterior"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Constraint: The Ring shall be a LinearRing and must form a triangle, the first and the last position must be co-incident.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="planar" name="interpolation" type="gml:SurfaceInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the interpolation mechanism used for this surface patch. Currently only planar surface patches are defined in GML 3, the attribute is fixed to "planar", i.e. the interpolation method shall return points on a single plane. The boundary of the patch shall be contained within that plane.&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TRIANGLETYPE_TYPE = build_TRIANGLETYPE_TYPE();

    private static ComplexType build_TRIANGLETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTRINGPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "exterior"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TriangleType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSURFACEPATCHTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TrianglePatchArrayPropertyType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;This type defines a container for an array of
     *       triangle patches.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:SurfacePatchArrayPropertyType"&gt;
     *              &lt;sequence maxOccurs="unbounded" minOccurs="0"&gt;
     *                  &lt;element ref="gml:Triangle"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TRIANGLEPATCHARRAYPROPERTYTYPE_TYPE =
            build_TRIANGLEPATCHARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_TRIANGLEPATCHARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TRIANGLETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Triangle"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "TrianglePatchArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        SURFACEPATCHARRAYPROPERTYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TriangulatedSurfaceType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A triangulated surface is a polyhedral
     *     surface that is composed only of triangles. There is no
     *     restriction on how the triangulation is derived.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:SurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element ref="gml:trianglePatches"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;This property encapsulates the patches of
     *        the triangulated surface.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TRIANGULATEDSURFACETYPE_TYPE =
            build_TRIANGULATEDSURFACETYPE_TYPE();

    private static ComplexType build_TRIANGULATEDSURFACETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TRIANGLEPATCHARRAYPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "trianglePatches"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TriangulatedSurfaceType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        SURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LineStringSegmentType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A LineStringSegment is a curve segment that is defined by two or more coordinate tuples, with linear interpolation between them.
     *  				Note: LineStringSegment implements GM_LineString of ISO 19107.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractCurveSegmentType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;choice&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;GML supports two different ways to specify the control points of a curve segment.
     *  1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this curve segment, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this curve segment (reuse of existing points).
     *  2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this curve segment only. The number of direct positions in the list must be at least two.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;choice maxOccurs="unbounded" minOccurs="2"&gt;
     *                          &lt;element ref="gml:pos"/&gt;
     *                          &lt;element ref="gml:pointProperty"/&gt;
     *                          &lt;element ref="gml:pointRep"&gt;
     *                              &lt;annotation&gt;
     *                                  &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.&lt;/documentation&gt;
     *                              &lt;/annotation&gt;
     *                          &lt;/element&gt;
     *                      &lt;/choice&gt;
     *                      &lt;element ref="gml:posList"/&gt;
     *                      &lt;element ref="gml:coordinates"&gt;
     *                          &lt;annotation&gt;
     *                              &lt;documentation&gt;Deprecated with GML version 3.1.0. Use "posList" instead.&lt;/documentation&gt;
     *                          &lt;/annotation&gt;
     *                      &lt;/element&gt;
     *                  &lt;/choice&gt;
     *              &lt;/sequence&gt;
     *              &lt;attribute fixed="linear" name="interpolation" type="gml:CurveInterpolationType"&gt;
     *                  &lt;annotation&gt;
     *                      &lt;documentation&gt;The attribute "interpolation" specifies the curve interpolation mechanism used for this segment. This mechanism
     *  uses the control points and control parameters to determine the position of this curve segment. For a LineStringSegment the interpolation is fixed as "linear".&lt;/documentation&gt;
     *                  &lt;/annotation&gt;
     *              &lt;/attribute&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LINESTRINGSEGMENTTYPE_TYPE = build_LINESTRINGSEGMENTTYPE_TYPE();

    private static ComplexType build_LINESTRINGSEGMENTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointRep"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        COORDINATESTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "coordinates"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CURVEINTERPOLATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interpolation"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "LineStringSegmentType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTCURVESEGMENTTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="LineStringSegmentArrayPropertyType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element maxOccurs="unbounded" minOccurs="0" ref="gml:LineStringSegment"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType LINESTRINGSEGMENTARRAYPROPERTYTYPE_TYPE =
            build_LINESTRINGSEGMENTARRAYPROPERTYTYPE_TYPE();

    private static ComplexType build_LINESTRINGSEGMENTARRAYPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        LINESTRINGSEGMENTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "LineStringSegment"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl(
                                "http://www.opengis.net/gml", "LineStringSegmentArrayPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TinType_controlPoint"&gt;
     *      &lt;choice&gt;
     *          &lt;element ref="gml:posList"/&gt;
     *          &lt;group maxOccurs="unbounded" minOccurs="3" ref="gml:geometricPositionGroup"/&gt;
     *      &lt;/choice&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TINTYPE_CONTROLPOINT_TYPE = build_TINTYPE_CONTROLPOINT_TYPE();

    private static ComplexType build_TINTYPE_CONTROLPOINT_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONLISTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "posList"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTPOSITIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pos"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        POINTPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "pointProperty"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TinType_controlPoint"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TinType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A tin is a triangulated surface that uses
     *     the Delauny algorithm or a similar algorithm complemented with
     *     consideration of breaklines, stoplines, and maximum length of
     *     triangle sides. These networks satisfy the Delauny's criterion
     *     away from the modifications: Fore each triangle in the
     *     network, the circle passing through its vertices does not
     *     contain, in its interior, the vertex of any other triangle.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:TriangulatedSurfaceType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="stopLines" type="gml:LineStringSegmentArrayPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Stoplines are lines where the local
     *         continuity or regularity of the surface is questionable.
     *         In the area of these pathologies, triangles intersecting
     *         a stopline shall be removed from the tin surface, leaving
     *         holes in the surface. If coincidence occurs on surface
     *         boundary triangles, the result shall be a change of the
     *         surface boundary. Stoplines contains all these
     *         pathological segments as a set of line strings.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="breakLines" type="gml:LineStringSegmentArrayPropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Breaklines are lines of a critical
     *         nature to the shape of the surface, representing local
     *         ridges, or depressions (such as drainage lines) in the
     *         surface. As such their constituent segments must be
     *         included in the tin eve if doing so
     *         violates the Delauny criterion. Break lines contains these
     *         critical segments as a set of line strings.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="maxLength" type="gml:LengthType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;Areas of the surface where data is not
     *         sufficiently dense to assure reasonable calculation shall be
     *         removed by adding a retention criterion for triangles based
     *         on the length of their sides. For many triangle sides
     *         exceeding maximum length, the adjacent triangles to that
     *         triangle side shall be removed from the surface.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element name="controlPoint"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;documentation&gt;The corners of the triangles in the TIN
     *    are often referred to as pots. ControlPoint shall contain a
     *    set of the GM_Position used as posts for this TIN. Since each
     *    TIN contains triangles, there must be at least 3 posts. The
     *         order in which these points are given does not affect the
     *         surface that is represented. Application schemas may add
     *         information based on ordering of control points to facilitate
     *         the reconstruction of the TIN from the control points.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                      &lt;complexType name="TinType_controlPoint"&gt;
     *                          &lt;choice&gt;
     *                              &lt;element ref="gml:posList"/&gt;
     *                              &lt;group maxOccurs="unbounded" minOccurs="3" ref="gml:geometricPositionGroup"/&gt;
     *                          &lt;/choice&gt;
     *                      &lt;/complexType&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TINTYPE_TYPE = build_TINTYPE_TYPE();

    private static ComplexType build_TINTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        LINESTRINGSEGMENTARRAYPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "stopLines"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LINESTRINGSEGMENTARRAYPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "breakLines"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LENGTHTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "maxLength"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        TINTYPE_CONTROLPOINT_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "controlPoint"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TinType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        TRIANGULATEDSURFACETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="SolidType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;A solid is the basis for 3-dimensional geometry. The extent of a solid is defined by the boundary surfaces (shells). A shell is represented by a composite surface, where every  shell is used to represent a single connected component of the boundary of a solid. It consists of a composite surface (a list of orientable surfaces) connected in a topological cycle (an object whose boundary is empty). Unlike a Ring, a Shell's elements have no natural sort order. Like Rings, Shells are simple.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractSolidType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element minOccurs="0" name="exterior" type="gml:SurfacePropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;appinfo&gt;
     *                              &lt;sch:pattern name="Check either href or content not both"&gt;
     *                                  &lt;sch:rule context="gml:exterior"&gt;
     *                                      &lt;sch:extends rule="hrefOrContent"/&gt;
     *                                  &lt;/sch:rule&gt;
     *                              &lt;/sch:pattern&gt;
     *                          &lt;/appinfo&gt;
     *                          &lt;documentation&gt;Boundaries of solids are similar to surface boundaries. In normal 3-dimensional Euclidean space, one (composite) surface is distinguished as the exterior. In the more general case, this is not always possible.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *                  &lt;element maxOccurs="unbounded" minOccurs="0"
     *                      name="interior" type="gml:SurfacePropertyType"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;appinfo&gt;
     *                              &lt;sch:pattern name="Check either href or content not both"&gt;
     *                                  &lt;sch:rule context="gml:interior"&gt;
     *                                      &lt;sch:extends rule="hrefOrContent"/&gt;
     *                                  &lt;/sch:rule&gt;
     *                              &lt;/sch:pattern&gt;
     *                          &lt;/appinfo&gt;
     *                          &lt;documentation&gt;Boundaries of solids are similar to surface boundaries.&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType SOLIDTYPE_TYPE = build_SOLIDTYPE_TYPE();

    private static ComplexType build_SOLIDTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "exterior"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SURFACEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "interior"),
                        0,
                        2147483647,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "SolidType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTSOLIDTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="DirectedNodePropertyType"&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:Node"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attribute default="+" name="orientation" type="gml:SignType"/&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType DIRECTEDNODEPROPERTYTYPE_TYPE =
            build_DIRECTEDNODEPROPERTYTYPE_TYPE();

    private static ComplexType build_DIRECTEDNODEPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        NODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "Node"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        SIGNTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "orientation"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._ACTUATE_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "actuate"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "arcrole"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "href"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "remoteSchema"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.ANYURI_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "role"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XLINKSchema._SHOW_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "show"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "title"),
                        0,
                        1,
                        true,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        XSSchema.STRING_TYPE,
                        new NameImpl("http://www.w3.org/1999/xlink", "type"),
                        0,
                        1,
                        true,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "DirectedNodePropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoPointType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;The intended use of TopoPoint is to appear within a point feature to express the structural and possibly geometric relationships of this point to other features via shared node definitions. Note the orientation assigned to the directedNode has no meaning in this context. It is preserved for symmetry with the types and elements which follow.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;extension base="gml:AbstractTopologyType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;element ref="gml:directedNode"/&gt;
     *              &lt;/sequence&gt;
     *          &lt;/extension&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOPOINTTYPE_TYPE = build_TOPOPOINTTYPE_TYPE();

    private static ComplexType build_TOPOPOINTTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        DIRECTEDNODEPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "directedNode"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoPointType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        ABSTRACTTOPOLOGYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="TopoPointPropertyType"&gt;
     *      &lt;sequence&gt;
     *          &lt;element ref="gml:TopoPoint"/&gt;
     *      &lt;/sequence&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType TOPOPOINTPROPERTYTYPE_TYPE = build_TOPOPOINTPROPERTYTYPE_TYPE();

    private static ComplexType build_TOPOPOINTPROPERTYTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        TOPOPOINTTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "TopoPoint"),
                        1,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "TopoPointPropertyType"),
                        schema,
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        XSSchema.ANYTYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType abstract="true" name="BoundedFeatureType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Makes boundedBy mandatory&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;complexContent&gt;
     *          &lt;restriction base="gml:AbstractFeatureType"&gt;
     *              &lt;sequence&gt;
     *                  &lt;group ref="gml:StandardObjectProperties"/&gt;
     *                  &lt;element ref="gml:boundedBy"/&gt;
     *                  &lt;element minOccurs="0" ref="gml:location"&gt;
     *                      &lt;annotation&gt;
     *                          &lt;appinfo&gt;deprecated&lt;/appinfo&gt;
     *                          &lt;documentation&gt;deprecated in GML version 3.1&lt;/documentation&gt;
     *                      &lt;/annotation&gt;
     *                  &lt;/element&gt;
     *              &lt;/sequence&gt;
     *          &lt;/restriction&gt;
     *      &lt;/complexContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType BOUNDEDFEATURETYPE_TYPE = build_BOUNDEDFEATURETYPE_TYPE();

    private static ComplexType build_BOUNDEDFEATURETYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        METADATAPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "metaDataProperty"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        STRINGORREFTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "description"),
                        0,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        CODETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "name"),
                        0,
                        2147483647,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        BOUNDINGSHAPETYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "boundedBy"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescriptorImpl(
                        LOCATIONPROPERTYTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "location"),
                        0,
                        1,
                        false,
                        null));
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "BoundedFeatureType"),
                        schema,
                        false,
                        true,
                        Collections.<Filter>emptyList(),
                        ABSTRACTFEATURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="GridLengthType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Value of a length (or distance) quantity in a grid, where the grid spacing does not have any associated physical units, or does not have a constant physical spacing. This grid length will often be used in a digital image grid, where the base units are likely to be pixel spacings. Uses the MeasureType with the restriction that the unit of measure referenced by uom must be suitable for length along the axes of a grid, such as pixel spacings or grid spacings.&lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;simpleContent&gt;
     *          &lt;restriction base="gml:MeasureType"/&gt;
     *      &lt;/simpleContent&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType GRIDLENGTHTYPE_TYPE = build_GRIDLENGTHTYPE_TYPE();

    private static ComplexType build_GRIDLENGTHTYPE_TYPE() {
        ComplexType builtType;
        builtType =
                new ComplexTypeImpl(
                        new NameImpl("http://www.opengis.net/gml", "GridLengthType"),
                        Collections.<PropertyDescriptor>emptyList(),
                        false,
                        false,
                        Collections.<Filter>emptyList(),
                        MEASURETYPE_TYPE,
                        null);
        return builtType;
    }

    /**
     *
     *
     * <pre>
     *   <code>
     *  &lt;complexType name="OperationRefType"&gt;
     *      &lt;annotation&gt;
     *          &lt;documentation&gt;Association to an abstract operation, either referencing or containing the definition of that operation. &lt;/documentation&gt;
     *      &lt;/annotation&gt;
     *      &lt;sequence minOccurs="0"&gt;
     *          &lt;element ref="gml:_Operation"/&gt;
     *      &lt;/sequence&gt;
     *      &lt;attributeGroup ref="gml:AssociationAttributeGroup"/&gt;
     *  &lt;/complexType&gt;
     *
     *    </code>
     *   </pre>
     *
     * @generated
     */
    public static final ComplexType OPERATIONREFTYPE_TYPE = build_OPERATIONREFTYPE_TYPE();

    private static ComplexType build_OPERATIONREFTYPE_TYPE() {
        ComplexType builtType;
        List<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        schema.add(
                new AttributeDescriptorImpl(
                        ABSTRACTCOORDINATEOPERATIONTYPE_TYPE,
                        new NameImpl("http://www.opengis.net/gml", "_Operation"),
                        1,
                        1,
                        false,
                        null));
        schema.add(
                new AttributeDescript