/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.helpers.AttributesImpl;

public class GenericGeometryEncoder
extends GeometryEncoder<Geometry> {
    Encoder encoder;
    String gmlPrefix;

    public GenericGeometryEncoder(Encoder encoder) {
        super(encoder);
        this.encoder = encoder;
    }

    public GenericGeometryEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.encoder = encoder;
        this.gmlPrefix = gmlPrefix;
    }

    public void encode(Geometry geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        if (geometry instanceof LineString) {
            LineStringEncoder lineString = new LineStringEncoder(this.encoder, LineStringEncoder.LINE_STRING);
            lineString.encode((LineString)geometry, atts, handler);
        } else if (geometry instanceof Point) {
            PointEncoder pt = new PointEncoder(this.encoder, this.gmlPrefix == null ? "gml" : this.gmlPrefix);
            pt.encode((Point)geometry, atts, handler);
        } else if (geometry instanceof Polygon) {
            PolygonEncoder polygon = new PolygonEncoder(this.encoder, this.gmlPrefix == null ? "gml" : this.gmlPrefix);
            polygon.encode((Polygon)geometry, atts, handler);
        } else if (geometry instanceof MultiLineString) {
            MultiLineStringEncoder multiLineString = new MultiLineStringEncoder(this.encoder, this.gmlPrefix, true);
            multiLineString.encode((Geometry)((MultiLineString)geometry), atts, handler);
        } else if (geometry instanceof MultiPoint) {
            MultiPointEncoder multiPoint = new MultiPointEncoder(this.encoder, this.gmlPrefix);
            multiPoint.encode((MultiPoint)geometry, atts, handler);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygonEncoder multiPolygon = new MultiPolygonEncoder(this.encoder, this.gmlPrefix);
            multiPolygon.encode((MultiPolygon)geometry, atts, handler);
        } else if (geometry instanceof LinearRing) {
            LinearRingEncoder linearRing = new LinearRingEncoder(this.encoder, this.gmlPrefix);
            linearRing.encode((LineString)((LinearRing)geometry), atts, handler);
        } else if (geometry instanceof CircularString || geometry instanceof CompoundCurve || geometry instanceof CircularRing || geometry instanceof CompoundRing) {
            CurveEncoder curve = new CurveEncoder(this.encoder, this.gmlPrefix);
            curve.encode((LineString)geometry, atts, handler);
        } else {
            throw new Exception("Unsupported geometry " + geometry.toString());
        }
    }
}

