/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.OperationType;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wmts.WMTSSpecification;
import org.geotools.data.wmts.model.WMTSCapabilities;
import org.geotools.data.wmts.model.WMTSServiceType;
import org.geotools.data.wmts.request.GetTileRequest;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.tile.Tile;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WebMapTileServer
extends AbstractOpenWebService<WMTSCapabilities, Layer> {
    private WMTSServiceType type;
    private final Map<String, String> headers = new HashMap<String, String>();

    public WebMapTileServer(URL serverURL, HTTPClient httpClient, WMTSCapabilities capabilities, Map<String, Object> hints) throws ServiceException, IOException {
        super(serverURL, httpClient, (Capabilities)capabilities, hints);
        this.setType(capabilities.getType());
    }

    public WebMapTileServer(URL serverURL, HTTPClient httpClient, WMTSCapabilities capabilities) throws ServiceException, IOException {
        super(serverURL, httpClient, (Capabilities)capabilities);
        this.setType(((WMTSCapabilities)this.capabilities).getType());
    }

    public WebMapTileServer(URL serverURL) throws IOException, ServiceException {
        super(serverURL);
        this.setType(((WMTSCapabilities)this.capabilities).getType());
    }

    public WebMapTileServer(WMTSCapabilities capabilities) throws ServiceException, IOException {
        super((Capabilities)capabilities, capabilities.getRequest().getGetCapabilities().getGet());
        this.setType(capabilities.getType());
    }

    public WebMapTileServer(WebMapTileServer delegate) throws ServiceException, IOException {
        this(delegate.serverURL);
    }

    public WMTSCapabilities getCapabilities() {
        return (WMTSCapabilities)this.capabilities;
    }

    protected ServiceInfo createInfo() {
        return null;
    }

    protected ResourceInfo createInfo(Layer resource) {
        return null;
    }

    protected void setupSpecifications() {
        this.specs = new WMTSSpecification[1];
        this.specs[0] = new WMTSSpecification();
    }

    public Set<Tile> issueRequest(GetTileRequest tileRequest) throws ServiceException {
        return tileRequest.getTiles();
    }

    public GetTileRequest createGetTileRequest() {
        URL url = WMTSServiceType.KVP.equals((Object)this.type) ? this.findURL(this.getCapabilities().getRequest().getGetTile()) : this.serverURL;
        WMTSSpecification.GetTileRequest request = ((WMTSSpecification)this.specification).createGetTileRequest(url, null, (WMTSCapabilities)this.capabilities);
        request.getHeaders().putAll(this.headers);
        return request;
    }

    private URL findURL(OperationType operation) {
        if (WMTSServiceType.KVP.equals((Object)this.type)) {
            if (operation.getGet() != null) {
                return operation.getGet();
            }
            return this.serverURL;
        }
        return null;
    }

    public GetFeatureInfoRequest createGetFeatureInfoRequest(GetTileRequest getmap) {
        return null;
    }

    public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest request) {
        return null;
    }

    public void setType(WMTSServiceType type) {
        this.type = type;
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public GeneralEnvelope getEnvelope(Layer layer, CoordinateReferenceSystem crs) {
        Map boundingBoxes = layer.getBoundingBoxes();
        CRSEnvelope box = (CRSEnvelope)boundingBoxes.get(crs.getName().getCode());
        if (box != null) {
            return new GeneralEnvelope((Envelope)box);
        }
        for (String key : boundingBoxes.keySet()) {
            box = (CRSEnvelope)boundingBoxes.get(key);
            if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)box.getCoordinateReferenceSystem())) continue;
            return new GeneralEnvelope((Envelope)box);
        }
        return null;
    }
}

