/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wmts.v_1.CapabilitiesType;
import org.apache.commons.io.IOUtils;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wmts.model.WMTSCapabilities;
import org.geotools.ows.ServiceException;
import org.geotools.wmts.WMTSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMTSGetCapabilitiesResponse
extends GetCapabilitiesResponse {
    private static WMTSConfiguration WMTS_CONFIGURATION = new WMTSConfiguration();

    public WMTSGetCapabilitiesResponse(HTTPResponse response) throws ServiceException, IOException {
        this(response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMTSGetCapabilitiesResponse(HTTPResponse response, Map<String, Object> hints) throws ServiceException, IOException {
        super(response);
        try {
            Object object;
            InputStream inputStream = null;
            try {
                inputStream = response.getResponseStream();
                Parser parser = new Parser((Configuration)WMTS_CONFIGURATION);
                object = parser.parse(new InputSource(inputStream));
            }
            catch (ParserConfigurationException | SAXException e) {
                throw (ServiceException)new ServiceException("Error while parsing XML.").initCause((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            if (object instanceof ServiceException) {
                throw (ServiceException)((Object)object);
            }
            this.capabilities = new WMTSCapabilities((CapabilitiesType)object);
        }
        finally {
            response.dispose();
        }
    }
}

