/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wmts.client.WMTSTileFactory;
import org.geotools.data.wmts.client.WMTSTileService;
import org.geotools.data.wmts.model.TileMatrixLimits;
import org.geotools.data.wmts.model.TileMatrixSet;
import org.geotools.data.wmts.model.TileMatrixSetLink;
import org.geotools.data.wmts.model.WMTSCapabilities;
import org.geotools.data.wmts.model.WMTSLayer;
import org.geotools.data.wmts.model.WMTSServiceType;
import org.geotools.data.wmts.request.AbstractWMTSRequest;
import org.geotools.data.wmts.request.GetTileRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGetTileRequest
extends AbstractWMTSRequest
implements GetTileRequest {
    private static final int MAXTILES = 256;
    private static final double DPI = 90.7142857;
    static WMTSTileFactory factory = new WMTSTileFactory();
    public static final String LAYER = "Layer";
    public static final String STYLE = "Style";
    public static final String TILECOL = "TileCol";
    public static final String TILEROW = "TileRow";
    public static final String TILEMATRIX = "TileMatrix";
    public static final String TILEMATRIXSET = "TileMatrixSet";
    private WMTSLayer layer = null;
    private String styleName = "";
    private String srs;
    static final Logger LOGGER = Logging.getLogger(AbstractGetTileRequest.class);
    protected WMTSServiceType type;
    protected WMTSCapabilities capabilities;
    private ReferencedEnvelope requestedBBox;
    private int requestedHeight;
    private int requestedWidth;
    private String requestedTime;
    private CoordinateReferenceSystem crs;
    private final Map<String, String> headers = new HashMap<String, String>();

    public AbstractGetTileRequest(URL onlineResource, Properties properties) {
        super(onlineResource, properties);
    }

    protected abstract void initVersion();

    protected void initRequest() {
        this.setProperty("REQUEST", "GetTile");
    }

    public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
        return null;
    }

    @Override
    public void setLayer(WMTSLayer layer) {
        StyleImpl defaultStyle;
        this.layer = layer;
        if (this.styleName.isEmpty() && (defaultStyle = layer.getDefaultStyle()) != null) {
            this.styleName = defaultStyle.getName();
        }
    }

    @Override
    public void setStyle(String styleName) {
        this.styleName = styleName;
    }

    @Override
    public void setRequestedHeight(int height) {
        this.requestedHeight = height;
    }

    @Override
    public void setRequestedWidth(int width) {
        this.requestedWidth = width;
    }

    @Override
    public void setRequestedBBox(ReferencedEnvelope requestedBBox) {
        this.requestedBBox = requestedBBox;
    }

    @Override
    public void setRequestedTime(String requestedTime) {
        this.requestedTime = requestedTime;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public void setCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public Set<Tile> getTiles() throws ServiceException {
        if (this.layer == null) {
            throw new ServiceException("GetTiles called with no layer set");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getTiles: layer:" + (Object)((Object)this.layer));
        }
        String layerString = "";
        String styleString = "";
        try {
            layerString = URLEncoder.encode(this.layer.getName(), "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException | NullPointerException e) {
            layerString = layerString + this.layer.getName();
        }
        this.styleName = this.styleName == null ? "" : this.styleName;
        try {
            styleString = URLEncoder.encode(this.styleName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException | NullPointerException e1) {
            styleString = styleString + this.styleName;
        }
        this.setProperty(LAYER, layerString);
        this.setProperty(STYLE, styleString);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getTiles:  layer:" + (Object)((Object)this.layer) + " w:" + this.requestedWidth + " x h:" + this.requestedHeight);
        }
        TileMatrixSet matrixSet = this.selectMatrixSet();
        String requestUrl = this.onlineResource.toString();
        if (WMTSServiceType.REST.equals((Object)this.type)) {
            String format = (String)this.getProperties().get("Format");
            if (format == null || format.isEmpty()) {
                format = "image/png";
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Format not set, trying with " + format);
                }
            }
            if ((requestUrl = this.layer.getTemplate(format)) == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Template URL not available for format  " + format);
                }
                format = this.layer.getFormats().get(0);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Available formats: " + this.layer.getFormats() + " -- Selecting " + format);
                }
                requestUrl = this.layer.getTemplate(format);
            }
        }
        WMTSTileService wmtsService = new WMTSTileService(requestUrl, this.type, this.layer, styleString, matrixSet);
        wmtsService.getDimensions().put("time", this.requestedTime);
        ((Map)wmtsService.getExtrainfo().computeIfAbsent("HEADERS", extra -> new HashMap())).putAll(this.headers);
        int scale = 0;
        try {
            scale = (int)Math.round(RendererUtilities.calculateScale((ReferencedEnvelope)this.requestedBBox, (int)this.requestedWidth, (int)this.requestedHeight, (double)90.7142857));
        }
        catch (FactoryException | TransformException ex) {
            LOGGER.log(Level.WARNING, "Failed to calculate scale", ex);
            throw new ServiceException("Failed to calculate scale: " + ex.getMessage());
        }
        Set<Tile> tiles = wmtsService.findTilesInExtent(this.requestedBBox, scale, false, 256);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("found " + tiles.size() + " tiles in " + this.requestedBBox);
        }
        if (tiles.isEmpty()) {
            return tiles;
        }
        Tile first = tiles.iterator().next();
        int z = first.getTileIdentifier().getZ();
        TileMatrixSetLink tmsl = this.layer.getTileMatrixLinks().get(matrixSet.getIdentifier());
        TileMatrixLimits limit = WMTSTileFactory.getLimits(tmsl, matrixSet, z);
        ArrayList<Tile> tilesOutsideLimits = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            int x = tile.getTileIdentifier().getX();
            int y = tile.getTileIdentifier().getY();
            if ((long)x < limit.getMincol() || (long)x > limit.getMaxcol()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("col " + x + " outside limits " + limit.getMincol() + " " + limit.getMaxcol());
                }
                tilesOutsideLimits.add(tile);
                continue;
            }
            if ((long)y >= limit.getMinrow() && (long)y <= limit.getMaxrow()) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("row " + y + " outside limits " + limit.getMinrow() + " " + limit.getMaxrow());
            }
            tilesOutsideLimits.add(tile);
        }
        tiles.removeAll(tilesOutsideLimits);
        return tiles;
    }

    private TileMatrixSet selectMatrixSet() throws ServiceException, RuntimeException {
        TileMatrixSet retMatrixSet = null;
        Map<String, TileMatrixSetLink> links = this.layer.getTileMatrixLinks();
        CoordinateReferenceSystem requestCRS = this.getCrs();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("request CRS " + (requestCRS == null ? "NULL" : requestCRS.getName()));
        }
        if (requestCRS == null) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("request CRS decoding" + this.srs);
                }
                requestCRS = CRS.decode((String)this.srs);
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
                throw new RuntimeException(e);
            }
        }
        for (TileMatrixSet matrixSet : this.capabilities.getMatrixSets()) {
            CoordinateReferenceSystem matrixCRS = matrixSet.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)matrixCRS) || !links.containsKey(matrixSet.getIdentifier())) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("selected matrix set:" + matrixSet.getIdentifier());
            }
            this.setProperty(TILEMATRIXSET, matrixSet.getIdentifier());
            retMatrixSet = matrixSet;
            break;
        }
        if (retMatrixSet == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Failed to match the requested CRS (" + requestCRS.getName() + ") with any of the tile matrices!");
            }
            for (TileMatrixSet matrix : this.capabilities.getMatrixSets()) {
                if (!links.containsKey(matrix.getIdentifier())) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("defaulting matrix set:" + matrix.getIdentifier());
                }
                this.setProperty(TILEMATRIXSET, matrix.getIdentifier());
                retMatrixSet = matrix;
                break;
            }
        }
        if (retMatrixSet == null) {
            throw new ServiceException("Unable to find a matching TileMatrixSet for layer " + this.layer.getName() + " and SRS: " + requestCRS.getName());
        }
        return retMatrixSet;
    }
}

