/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts.client;

import org.geotools.data.wmts.client.WMTSTileService;
import org.geotools.data.wmts.model.TileMatrix;
import org.geotools.tile.impl.ZoomLevel;

class WMTSZoomLevel
extends ZoomLevel {
    private final WMTSTileService service;

    public WMTSZoomLevel(int zoomLevel, WMTSTileService service) {
        this.service = service;
        this.setZoomLevel(zoomLevel);
        this.maxTilePerRowNumber = this.calculateMaxTilePerRowNumber(zoomLevel);
        this.maxTilePerColNumber = this.calculateMaxTilePerColNumber(zoomLevel);
        this.maxTileNumber = this.calculateMaxTileNumber();
    }

    public int calculateMaxTilePerRowNumber(int zoomLevel) {
        TileMatrix matrix = this.service.getTileMatrix(zoomLevel);
        return matrix.getMatrixWidth();
    }

    public int calculateMaxTilePerColNumber(int zoomLevel) {
        TileMatrix matrix = this.service.getTileMatrix(zoomLevel);
        return matrix.getMatrixHeight();
    }

    public String toString() {
        return "ZoomLevel [z:" + this.getZoomLevel() + " col: " + this.getMaxTilePerColNumber() + " rows:" + this.getMaxTilePerRowNumber() + "]";
    }
}

