/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts.client;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.data.wmts.client.WMTSTile;
import org.geotools.data.wmts.client.WMTSTileIdentifier;
import org.geotools.data.wmts.client.WMTSTileService;
import org.geotools.data.wmts.client.WMTSZoomLevel;
import org.geotools.data.wmts.model.TileMatrix;
import org.geotools.data.wmts.model.TileMatrixLimits;
import org.geotools.data.wmts.model.TileMatrixSet;
import org.geotools.data.wmts.model.TileMatrixSetLink;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import si.uom.NonSI;
import si.uom.SI;

public class WMTSTileFactory
extends TileFactory {
    private static final double PixelSizeMeters = 2.8E-4;
    private static final Logger LOGGER = Logging.getLogger((String)WMTSTileFactory.class.getPackage().getName());

    public Tile findTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel, TileService service) {
        double tileMatrixMaxY;
        double tileMatrixMinX;
        WMTSZoomLevel zl = (WMTSZoomLevel)zoomLevel;
        TileMatrix tileMatrix = ((WMTSTileService)service).getMatrixSet().getMatrices().get(zl.getZoomLevel());
        double pixelSpan = WMTSTileFactory.getPixelSpan(tileMatrix);
        double tileSpanY = (double)tileMatrix.getTileHeight() * pixelSpan;
        double tileSpanX = (double)tileMatrix.getTileWidth() * pixelSpan;
        if (tileMatrix.getCrs().getCoordinateSystem().getAxis(0).getDirection().equals((Object)AxisDirection.EAST)) {
            tileMatrixMinX = tileMatrix.getTopLeft().getX();
            tileMatrixMaxY = tileMatrix.getTopLeft().getY();
        } else {
            tileMatrixMaxY = tileMatrix.getTopLeft().getX();
            tileMatrixMinX = tileMatrix.getTopLeft().getY();
        }
        double epsilon = 1.0E-6;
        long xTile = (int)Math.floor((lon - tileMatrixMinX) / tileSpanX + epsilon);
        long yTile = (int)Math.floor((tileMatrixMaxY - lat) / tileSpanY + epsilon);
        xTile = Math.max(0L, xTile);
        yTile = Math.max(0L, yTile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("findTile: (lon,lat)=(" + lon + "," + lat + ")  (col,row)=" + xTile + ", " + yTile + " zoom:" + zoomLevel.getZoomLevel());
        }
        return new WMTSTile((int)xTile, (int)yTile, zoomLevel, service);
    }

    public Tile findUpperLeftTile(double lon, double lat, WMTSZoomLevel zoomLevel, WMTSTileService service) {
        Tile matrixTile = this.findTileAtCoordinate(lon, lat, zoomLevel, service);
        return this.constrainToUpperLeftTile(matrixTile, zoomLevel, service);
    }

    public static TileMatrixLimits getLimits(TileMatrixSetLink tmsl, TileMatrixSet tms, int z) {
        TileMatrixLimits limits;
        List<TileMatrixLimits> limitsList = tmsl.getLimits();
        if (limitsList != null && z < limitsList.size()) {
            limits = limitsList.get(z);
        } else {
            TileMatrix tileMatrix = tms.getMatrices().get(z);
            limits = new TileMatrixLimits();
            limits.setMinCol(0L);
            limits.setMinRow(0L);
            limits.setMaxCol(tileMatrix.getMatrixWidth() - 1);
            limits.setMaxRow(tileMatrix.getMatrixHeight() - 1);
            limits.setTileMatix(tms.getIdentifier());
        }
        return limits;
    }

    public WMTSTile constrainToUpperLeftTile(Tile matrixTile, WMTSZoomLevel zl, WMTSTileService service) {
        TileMatrixLimits limits = WMTSTileFactory.getLimits(service.getMatrixSetLink(), service.getMatrixSet(), zl.getZoomLevel());
        long origxTile = matrixTile.getTileIdentifier().getX();
        long origyTile = matrixTile.getTileIdentifier().getY();
        long xTile = origxTile;
        long yTile = origyTile;
        if (xTile >= limits.getMaxcol()) {
            xTile = limits.getMaxcol() - 1L;
        }
        if (yTile >= limits.getMaxrow()) {
            yTile = limits.getMaxrow() - 1L;
        }
        if (xTile < limits.getMincol()) {
            xTile = limits.getMincol();
        }
        if (yTile < limits.getMinrow()) {
            yTile = limits.getMinrow();
        }
        if ((origxTile != xTile || origyTile != yTile) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("findUpperLeftTile: constraining tile within limits: (" + origxTile + "," + origyTile + ") -> (" + xTile + "," + yTile + ")");
        }
        return new WMTSTile((int)xTile, (int)yTile, zl, service);
    }

    public WMTSZoomLevel getZoomLevel(int zoomLevel, TileService service) {
        return new WMTSZoomLevel(zoomLevel, (WMTSTileService)service);
    }

    public Tile findRightNeighbour(Tile tile, TileService service) {
        WMTSTileIdentifier id = (WMTSTileIdentifier)tile.getTileIdentifier().getRightNeighbour();
        return id == null ? null : new WMTSTile(id, service);
    }

    public Tile findLowerNeighbour(Tile tile, TileService service) {
        WMTSTileIdentifier id = (WMTSTileIdentifier)tile.getTileIdentifier().getLowerNeighbour();
        return id == null ? null : new WMTSTile(id, service);
    }

    public static ReferencedEnvelope getExtentFromTileName(WMTSTileIdentifier tileIdentifier, TileService service) {
        double tileMatrixMaxY;
        double tileMatrixMinX;
        WMTSZoomLevel zl = new WMTSZoomLevel(tileIdentifier.getZ(), (WMTSTileService)service);
        TileMatrix tileMatrix = ((WMTSTileService)service).getMatrixSet().getMatrices().get(zl.getZoomLevel());
        CoordinateReferenceSystem crs = tileMatrix.getCrs();
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        double pixelSpan = WMTSTileFactory.getPixelSpan(tileMatrix);
        double tileSpanY = (double)tileMatrix.getTileHeight() * pixelSpan;
        double tileSpanX = (double)tileMatrix.getTileWidth() * pixelSpan;
        boolean longFirst = coordinateSystem.getAxis(0).getDirection().equals((Object)AxisDirection.EAST);
        if (longFirst) {
            tileMatrixMinX = tileMatrix.getTopLeft().getX();
            tileMatrixMaxY = tileMatrix.getTopLeft().getY();
        } else {
            tileMatrixMaxY = tileMatrix.getTopLeft().getX();
            tileMatrixMinX = tileMatrix.getTopLeft().getY();
        }
        ReferencedEnvelope ret = new ReferencedEnvelope(crs);
        double minX = (double)tileIdentifier.getX() * tileSpanX + tileMatrixMinX;
        double maxY = tileMatrixMaxY - (double)tileIdentifier.getY() * tileSpanY;
        double maxX = minX + tileSpanX;
        double minY = maxY - tileSpanY;
        if (longFirst) {
            ret.expandToInclude(minX, minY);
            ret.expandToInclude(maxX, maxY);
        } else {
            ret.expandToInclude(minY, minX);
            ret.expandToInclude(maxY, maxX);
        }
        return ret;
    }

    private static double getPixelSpan(TileMatrix tileMatrix) {
        CoordinateSystem coordinateSystem = tileMatrix.getCrs().getCoordinateSystem();
        Unit unit = coordinateSystem.getAxis(0).getUnit();
        double pixelSpan = tileMatrix.getDenominator() * 2.8E-4;
        if (unit.equals(NonSI.DEGREE_ANGLE)) {
            pixelSpan /= 111319.0;
        } else {
            UnitConverter metersperunit = unit.getConverterTo(SI.METRE);
            pixelSpan /= metersperunit.convert(1.0);
        }
        return pixelSpan;
    }
}

