/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wmts;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.geotools.data.ows.AbstractGetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.Specification;
import org.geotools.data.wmts.model.WMTSCapabilities;
import org.geotools.data.wmts.model.WMTSServiceType;
import org.geotools.data.wmts.request.AbstractGetTileRequest;
import org.geotools.data.wmts.response.GetTileResponse;
import org.geotools.data.wmts.response.WMTSGetCapabilitiesResponse;
import org.geotools.ows.ServiceException;

public class WMTSSpecification
extends Specification {
    public static final String WMTS_VERSION = "1.0.0";
    private WMTSServiceType type;

    public String getVersion() {
        return WMTS_VERSION;
    }

    public GetCapabilitiesRequest createGetCapabilitiesRequest(URL server) {
        return new GetCapsRequest(server);
    }

    public GetTileRequest createGetTileRequest(URL server, Properties props, WMTSCapabilities caps) {
        return new GetTileRequest(server, props, caps);
    }

    public static String processKey(String key) {
        return key.trim().toUpperCase();
    }

    public static class GetCapsRequest
    extends AbstractGetCapabilitiesRequest {
        public GetCapsRequest(URL urlGetCapabilities) {
            super(urlGetCapabilities);
        }

        protected void initService() {
            this.setProperty("SERVICE", "WMTS");
        }

        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        protected String processKey(String key) {
            return WMTSSpecification.processKey(key);
        }

        public WMTSGetCapabilitiesResponse createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new WMTSGetCapabilitiesResponse(httpResponse, this.hints);
        }
    }

    public static class GetTileRequest
    extends AbstractGetTileRequest {
        public GetTileRequest(URL onlineResource, Properties properties, WMTSCapabilities capabilities) {
            super(onlineResource, properties);
            this.type = capabilities.getType();
            this.capabilities = capabilities;
        }

        @Override
        public Response createResponse(HTTPResponse response) throws ServiceException, IOException {
            return new GetTileResponse(response, this.getType());
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        public WMTSServiceType getType() {
            return this.type;
        }

        public void setType(WMTSServiceType type) {
            this.type = type;
        }
    }
}

