/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.ows10.DCPType;
import net.opengis.ows10.DomainType;
import net.opengis.ows10.OperationType;
import net.opengis.ows10.OperationsMetadataType;
import net.opengis.ows10.RequestMethodType;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.FeatureTypeListType;
import net.opengis.wfs.FeatureTypeType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.OperationsType;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import net.opengis.wfs.WFSCapabilitiesType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.DescribeStoredQueriesRequest;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.ListStoredQueriesRequest;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.TransactionRequest;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSExtensions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.data.wfs.internal.v1_x.CapabilitiesServiceInfo;
import org.geotools.data.wfs.internal.v1_x.FeatureTypeInfoImpl;
import org.geotools.util.Version;
import org.geotools.xsd.Configuration;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.sort.SortBy;

public class StrictWFS_1_x_Strategy
extends AbstractWFSStrategy {
    private static final List<String> PREFFERRED_GETFEATURE_FORMATS = Collections.unmodifiableList(Arrays.asList("text/xml; subtype=gml/3.1.1", "text/xml; subtype=gml/3.1.1/profiles/gmlsf/0", "GML3"));
    private static final List<String> PREFFERRED_GETFEATURE_FORMATS_10 = Collections.unmodifiableList(Arrays.asList("GML2"));
    protected WFSCapabilitiesType capabilities;
    private final Map<QName, FeatureTypeType> typeInfos = new HashMap<QName, FeatureTypeType>();
    private Version serviceVersion;

    public StrictWFS_1_x_Strategy() {
        this(Versions.v1_0_0);
    }

    public StrictWFS_1_x_Strategy(Version defaultVersion) {
        this.serviceVersion = defaultVersion;
    }

    @Override
    protected QName getOperationName(WFSOperationType operation) {
        return new QName("http://www.opengis.net/wfs", operation.getName());
    }

    protected GetFeatureType createGetFeatureRequestPost(GetFeatureRequest query) throws IOException {
        SortBy[] sortByList;
        boolean retrieveAllProperties;
        String srsName;
        GetFeatureRequest.ResultType resultType;
        QName typeName = query.getTypeName();
        FeatureTypeInfo featureTypeInfo = this.getFeatureTypeInfo(typeName);
        WfsFactory factory = WfsFactory.eINSTANCE;
        GetFeatureType getFeature = factory.createGetFeatureType();
        getFeature.setService("WFS");
        getFeature.setVersion(this.getVersion());
        String outputFormat = query.getOutputFormat();
        getFeature.setOutputFormat(outputFormat);
        getFeature.setHandle(query.getHandle());
        Integer maxFeatures = query.getMaxFeatures();
        if (maxFeatures != null) {
            getFeature.setMaxFeatures(BigInteger.valueOf(maxFeatures.intValue()));
        }
        getFeature.setResultType(GetFeatureRequest.ResultType.RESULTS == (resultType = query.getResultType()) ? ResultTypeType.RESULTS_LITERAL : ResultTypeType.HITS_LITERAL);
        QueryType wfsQuery = factory.createQueryType();
        wfsQuery.setTypeName(Collections.singletonList(typeName));
        Filter filter = query.getFilter();
        Filter[] splitFilters = this.splitFilters(typeName, filter);
        Filter supportedFilter = splitFilters[0];
        Filter unsupportedFilter = splitFilters[1];
        query.setUnsupportedFilter(unsupportedFilter);
        if (!Filter.INCLUDE.equals(supportedFilter)) {
            wfsQuery.setFilter(supportedFilter);
        }
        if (null == (srsName = query.getSrsName())) {
            srsName = featureTypeInfo.getDefaultSRS();
        }
        try {
            wfsQuery.setSrsName(new URI(srsName));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't create a URI from the query CRS: " + srsName, e);
        }
        String[] propertyNames = query.getPropertyNames();
        boolean bl = retrieveAllProperties = propertyNames == null;
        if (!retrieveAllProperties) {
            EList propertyName = wfsQuery.getPropertyName();
            for (String string : propertyNames) {
                propertyName.add(string);
            }
        }
        if ((sortByList = query.getSortBy()) != null) {
            for (String string : sortByList) {
                wfsQuery.getSortBy().add((Object)string);
            }
        }
        getFeature.getQuery().add((Object)wfsQuery);
        return getFeature;
    }

    protected DescribeFeatureTypeType createDescribeFeatureTypeRequestPost(DescribeFeatureTypeRequest request) {
        WfsFactory factory = WfsFactory.eINSTANCE;
        DescribeFeatureTypeType dft = factory.createDescribeFeatureTypeType();
        Version version = this.getServiceVersion();
        dft.setService("WFS");
        dft.setVersion(version.toString());
        dft.setHandle(request.getHandle());
        if (Versions.v1_0_0.equals((Object)version)) {
            dft.setOutputFormat(null);
        }
        QName typeName = request.getTypeName();
        EList typeNames = dft.getTypeName();
        typeNames.add(typeName);
        return dft;
    }

    @Override
    protected EObject createListStoredQueriesRequestPost(ListStoredQueriesRequest request) throws IOException {
        throw new UnsupportedOperationException("WFS 1.0.0 / 1.1.0 does not support Stored Queries!");
    }

    @Override
    protected EObject createDescribeStoredQueriesRequestPost(DescribeStoredQueriesRequest request) throws IOException {
        throw new UnsupportedOperationException("WFS 1.0.0 / 1.1.0 does not support Stored Queries!");
    }

    @Override
    protected EObject createTransactionRequest(TransactionRequest request) throws IOException {
        WfsFactory factory = WfsFactory.eINSTANCE;
        TransactionType tx = factory.createTransactionType();
        tx.setService("WFS");
        tx.setHandle(request.getHandle());
        tx.setVersion(this.getVersion());
        List<TransactionRequest.TransactionElement> transactionElements = request.getTransactionElements();
        if (transactionElements.isEmpty()) {
            Loggers.requestInfo("Asked to perform transaction with no transaction elements");
            return tx;
        }
        EList inserts = tx.getInsert();
        EList updates = tx.getUpdate();
        EList deletes = tx.getDelete();
        try {
            for (TransactionRequest.TransactionElement elem : transactionElements) {
                if (elem instanceof TransactionRequest.Insert) {
                    InsertElementType insert = this.createInsert(factory, (TransactionRequest.Insert)elem);
                    inserts.add(insert);
                    continue;
                }
                if (elem instanceof TransactionRequest.Update) {
                    UpdateElementType update = this.createUpdate(factory, (TransactionRequest.Update)elem);
                    updates.add(update);
                    continue;
                }
                if (!(elem instanceof TransactionRequest.Delete)) continue;
                DeleteElementType delete = this.createDelete(factory, (TransactionRequest.Delete)elem);
                deletes.add(delete);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception other) {
            throw new RuntimeException(other);
        }
        return tx;
    }

    protected InsertElementType createInsert(WfsFactory factory, TransactionRequest.Insert elem) throws Exception {
        InsertElementType insert = factory.createInsertElementType();
        String srsName = this.getFeatureTypeInfo(elem.getTypeName()).getDefaultSRS();
        insert.setSrsName(new URI(srsName));
        List<SimpleFeature> features = elem.getFeatures();
        insert.getFeature().addAll(features);
        return insert;
    }

    protected UpdateElementType createUpdate(WfsFactory factory, TransactionRequest.Update elem) throws Exception {
        List<QName> propertyNames = elem.getPropertyNames();
        List<Object> newValues = elem.getNewValues();
        if (propertyNames.size() != newValues.size()) {
            throw new IllegalArgumentException("Got " + propertyNames.size() + " property names and " + newValues.size() + " values");
        }
        UpdateElementType update = factory.createUpdateElementType();
        QName typeName = elem.getTypeName();
        update.setTypeName(typeName);
        String srsName = this.getFeatureTypeInfo(typeName).getDefaultSRS();
        update.setSrsName(new URI(srsName));
        Filter filter = elem.getFilter();
        update.setFilter(filter);
        EList properties = update.getProperty();
        for (int i = 0; i < propertyNames.size(); ++i) {
            QName propName = propertyNames.get(i);
            Object value = newValues.get(i);
            PropertyType property = factory.createPropertyType();
            property.setName(propName);
            property.setValue(value);
            properties.add(property);
        }
        return update;
    }

    protected DeleteElementType createDelete(WfsFactory factory, TransactionRequest.Delete elem) throws Exception {
        DeleteElementType delete = factory.createDeleteElementType();
        QName typeName = elem.getTypeName();
        delete.setTypeName(typeName);
        Filter filter = elem.getFilter();
        delete.setFilter(filter);
        return delete;
    }

    @Override
    public boolean supportsTransaction(QName typeName) {
        this.getFeatureTypeInfo(typeName);
        if (!this.supportsOperation(WFSOperationType.TRANSACTION, HttpMethod.POST)) {
            return false;
        }
        OperationsType operations = this.capabilities.getFeatureTypeList().getOperations();
        if (operations == null) {
            return false;
        }
        EList operation = operations.getOperation();
        for (net.opengis.wfs.OperationType required : Arrays.asList(net.opengis.wfs.OperationType.INSERT_LITERAL, net.opengis.wfs.OperationType.UPDATE_LITERAL, net.opengis.wfs.OperationType.DELETE_LITERAL)) {
            if (operation.contains(required)) continue;
            Loggers.info("Transactions not supported since WFS didn't declare support for " + required.getName());
            return false;
        }
        return true;
    }

    @Override
    public Configuration getFilterConfiguration() {
        return Versions.v1_0_0.equals((Object)this.getServiceVersion()) ? FILTER_1_0_CONFIGURATION : FILTER_1_1_CONFIGURATION;
    }

    @Override
    public Configuration getWfsConfiguration() {
        return Versions.v1_0_0.equals((Object)this.getServiceVersion()) ? WFS_1_0_CONFIGURATION : WFS_1_1_CONFIGURATION;
    }

    @Override
    public void setCapabilities(WFSGetCapabilities capabilities) {
        WFSCapabilitiesType caps;
        this.capabilities = caps = (WFSCapabilitiesType)capabilities.getParsedCapabilities();
        String version = caps.getVersion();
        try {
            this.serviceVersion = Versions.find(version);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("Capabilities document didn't advertise a supported version (" + version + "). Defaulting to " + this.serviceVersion);
        }
        this.typeInfos.clear();
        FeatureTypeListType featureTypeList = this.capabilities.getFeatureTypeList();
        if (featureTypeList == null || featureTypeList.getFeatureType().isEmpty()) {
            Loggers.MODULE.info("WFS Server contains no FeatureTypes: " + this.getOperationURI(WFSOperationType.GET_CAPABILITIES, HttpMethod.GET));
            return;
        }
        EList featureTypes = featureTypeList.getFeatureType();
        for (FeatureTypeType typeInfo : featureTypes) {
            FeatureTypeType transTypeInfo = this.translateTypeInfo(typeInfo);
            QName name = transTypeInfo.getName();
            this.typeInfos.put(name, transTypeInfo);
        }
    }

    protected FeatureTypeType translateTypeInfo(FeatureTypeType typeInfo) {
        return typeInfo;
    }

    @Override
    public WFSServiceInfo getServiceInfo() {
        String schemaLocation = Versions.v1_1_0.equals((Object)this.getServiceVersion()) ? "http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd" : "http://schemas.opengis.net/wfs/1.1.0/wfs.xsd";
        URL getCapsUrl = this.getOperationURL(WFSOperationType.GET_CAPABILITIES, HttpMethod.GET);
        return new CapabilitiesServiceInfo(schemaLocation, getCapsUrl, this.capabilities);
    }

    @Override
    public boolean supports(GetFeatureRequest.ResultType resultType) {
        switch (resultType) {
            case RESULTS: {
                return true;
            }
            case HITS: {
                return !Versions.v1_0_0.equals((Object)this.getServiceVersion());
            }
        }
        return false;
    }

    @Override
    public Version getServiceVersion() {
        return this.serviceVersion;
    }

    @Override
    public Set<QName> getFeatureTypeNames() {
        return new HashSet<QName>(this.typeInfos.keySet());
    }

    @Override
    public FeatureTypeInfo getFeatureTypeInfo(QName typeName) {
        FeatureTypeType eType = this.typeInfos.get(typeName);
        if (null == eType) {
            throw new IllegalArgumentException("Type name not found: " + typeName);
        }
        return new FeatureTypeInfoImpl(eType, this.config);
    }

    @Override
    public FilterCapabilities getFilterCapabilities() {
        FilterCapabilities wfsFilterCapabilities = this.capabilities.getFilterCapabilities();
        return wfsFilterCapabilities;
    }

    @Override
    protected String getOperationURI(WFSOperationType operation, HttpMethod method) {
        Loggers.trace(new Object[]{"Looking operation URI for ", operation, "/", method});
        EList operations = this.capabilities.getOperationsMetadata().getOperation();
        for (OperationType op : operations) {
            EList dcpTypes;
            if (!operation.getName().equals(op.getName()) || null == (dcpTypes = op.getDCP())) continue;
            for (DCPType d : dcpTypes) {
                EList methods = HttpMethod.GET.equals((Object)method) ? d.getHTTP().getGet() : d.getHTTP().getPost();
                if (null == methods || methods.isEmpty()) continue;
                String href = ((RequestMethodType)methods.get(0)).getHref();
                Loggers.debug(new Object[]{"Returning operation URI for ", operation, "/", method, ": ", href});
                return href;
            }
        }
        Loggers.debug(new Object[]{"No operation URI found for ", operation, "/", method});
        return null;
    }

    @Override
    public Set<String> getServerSupportedOutputFormats(QName typeName, WFSOperationType operation) {
        HashSet<String> ftypeFormats = new HashSet<String>();
        Set<String> serviceOutputFormats = this.getServerSupportedOutputFormats(operation);
        ftypeFormats.addAll(serviceOutputFormats);
        if (WFSOperationType.GET_FEATURE.equals((Object)operation)) {
            FeatureTypeInfo typeInfo = this.getFeatureTypeInfo(typeName);
            Set<String> typeAdvertisedFormats = typeInfo.getOutputFormats();
            ftypeFormats.addAll(typeAdvertisedFormats);
        }
        return ftypeFormats;
    }

    @Override
    public Set<String> getServerSupportedOutputFormats(WFSOperationType operation) {
        String parameterName;
        Version serviceVersion = this.getServiceVersion();
        boolean wfs1_0 = Versions.v1_0_0.equals((Object)serviceVersion);
        switch (operation) {
            case GET_FEATURE: {
                parameterName = wfs1_0 ? "ResultFormat" : "outputFormat";
                break;
            }
            case DESCRIBE_FEATURETYPE: {
                parameterName = wfs1_0 ? "SchemaDescriptionLanguage" : "outputFormat";
                break;
            }
            case GET_FEATURE_WITH_LOCK: {
                parameterName = wfs1_0 ? "ResultFormat" : "outputFormat";
                break;
            }
            case TRANSACTION: {
                if (wfs1_0) {
                    operation = WFSOperationType.GET_FEATURE;
                    parameterName = "ResultFormat";
                    break;
                }
                parameterName = "inputFormat";
                break;
            }
            default: {
                throw new UnsupportedOperationException("not yet implemented for " + (Object)((Object)operation));
            }
        }
        OperationType operationMetadata = this.getOperationMetadata(operation);
        LOGGER.fine("requesting " + parameterName + " from " + operationMetadata);
        Set<String> serverSupportedFormats = this.findParameters(operationMetadata, parameterName);
        return serverSupportedFormats;
    }

    @Override
    public Set<String> getSupportedCRSIdentifiers(QName typeName) {
        boolean wfs1_1;
        FeatureTypeInfo featureTypeInfo = this.getFeatureTypeInfo(typeName);
        String defaultSRS = featureTypeInfo.getDefaultSRS();
        List<String> otherSRS = featureTypeInfo.getOtherSRS();
        HashSet<String> ftypeCrss = new HashSet<String>();
        ftypeCrss.add(defaultSRS);
        if (!this.config.isUseDefaultSrs()) {
            ftypeCrss.addAll(otherSRS);
        }
        if (wfs1_1 = Versions.v1_1_0.equals((Object)this.getServiceVersion())) {
            OperationType operationMetadata = this.getOperationMetadata(WFSOperationType.GET_FEATURE);
            String operationParameter = "SrsName";
            Set<String> globalSrsNames = this.findParameters(operationMetadata, "SrsName");
            ftypeCrss.addAll(globalSrsNames);
        }
        return ftypeCrss;
    }

    protected Set<String> findParameters(OperationType operationMetadata, String parameterName) {
        HashSet<String> outputFormats = new HashSet<String>();
        EList parameters = operationMetadata.getParameter();
        for (DomainType param : parameters) {
            String paramName = param.getName();
            if (!parameterName.equals(paramName)) continue;
            EList value = param.getValue();
            outputFormats.addAll((Collection<String>)value);
        }
        return outputFormats;
    }

    @Override
    public List<String> getClientSupportedOutputFormats(WFSOperationType operation) {
        List<WFSResponseFactory> operationResponseFactories = WFSExtensions.findResponseFactories(operation);
        LinkedList<String> outputFormats = new LinkedList<String>();
        for (WFSResponseFactory factory : operationResponseFactories) {
            List<String> factoryFormats = factory.getSupportedOutputFormats();
            outputFormats.addAll(factoryFormats);
        }
        boolean wfs1_0 = Versions.v1_0_0.equals((Object)this.serviceVersion);
        if (WFSOperationType.GET_FEATURE.equals((Object)operation)) {
            for (String preferred : wfs1_0 ? PREFFERRED_GETFEATURE_FORMATS_10 : PREFFERRED_GETFEATURE_FORMATS) {
                boolean hasFormat = outputFormats.remove(preferred);
                if (!hasFormat) continue;
                outputFormats.add(0, preferred);
                break;
            }
        }
        return outputFormats;
    }

    protected OperationType getOperationMetadata(WFSOperationType operation) {
        OperationsMetadataType operationsMetadata = this.capabilities.getOperationsMetadata();
        EList operations = operationsMetadata.getOperation();
        String expectedOperationName = operation.getName();
        for (OperationType operationType : operations) {
            String operationName = operationType.getName();
            if (!expectedOperationName.equalsIgnoreCase(operationName)) continue;
            return operationType;
        }
        throw new NoSuchElementException("Operation metadata not found for " + expectedOperationName + " in the capabilities document");
    }
}

