/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.v1_x.StrictWFS_1_x_Strategy;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GMLBoxTypeBinding;
import org.geotools.xsd.Configuration;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.picocontainer.MutablePicoContainer;

public class IonicStrategy
extends StrictWFS_1_x_Strategy {
    private static final Configuration Ionic_filter_1_0_0_Configuration = new OGCConfiguration(){

        protected void registerBindings(MutablePicoContainer container) {
            super.registerBindings(container);
            container.registerComponentImplementation((Object)GML.BoxType, IonicGML2BoxTypeBinding.class);
        }
    };

    @Override
    public boolean supportsOperation(WFSOperationType operation, HttpMethod method) {
        if (operation == WFSOperationType.GET_FEATURE && method == HttpMethod.POST) {
            return false;
        }
        return super.supportsOperation(operation, method);
    }

    @Override
    public String getDefaultOutputFormat(WFSOperationType op) {
        if (WFSOperationType.GET_FEATURE.equals((Object)op)) {
            return "GML3";
        }
        return super.getDefaultOutputFormat(op);
    }

    @Override
    public Configuration getFilterConfiguration() {
        return Ionic_filter_1_0_0_Configuration;
    }

    @Override
    protected Map<String, String> buildGetFeatureParametersForGET(GetFeatureRequest request) {
        Map<String, String> params = super.buildGetFeatureParametersForGET(request);
        String overrideSrs = "urn:opengis:def:crs:ogc::83";
        String srsName = params.get("SRSNAME");
        if ("urn:opengis:def:crs:ogc::83".equals(srsName)) {
            params.put("SRSNAME", "EPSG:4269");
        }
        return params;
    }

    private static class IonicGML2BoxTypeBinding
    extends GMLBoxTypeBinding {
        private IonicGML2BoxTypeBinding() {
        }

        public Object getProperty(Object object, QName name) throws Exception {
            Envelope e = (Envelope)object;
            if (GML.coordinates.equals(name)) {
                double[] seq = new double[]{e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY()};
                PackedCoordinateSequence.Double coords = new PackedCoordinateSequence.Double(seq, 2, 0);
                return coords;
            }
            return null;
        }
    }
}

