/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.DataSourceException;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gml3.GML;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Converters;
import org.geotools.wfs.WFS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlSimpleFeatureParser
implements GetFeatureParser {
    private static final Logger LOGGER = Loggers.RESPONSES;
    private GeometryFactory geomFac = new GeometryFactory();
    private InputStream inputStream;
    private XmlPullParser parser;
    private SimpleFeatureType targetType;
    private SimpleFeatureBuilder builder;
    final String featureNamespace;
    final String featureName;
    private final Map<String, AttributeDescriptor> expectedProperties;
    private int numberOfFeatures = -1;
    private final String axisOrder;

    public XmlSimpleFeatureParser(InputStream getFeatureResponseStream, SimpleFeatureType targetType, QName featureDescriptorName, String axisOrder) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureNamespace = featureDescriptorName.getNamespaceURI();
        this.featureName = featureDescriptorName.getLocalPart();
        this.targetType = targetType;
        this.builder = new SimpleFeatureBuilder(targetType);
        this.axisOrder = axisOrder;
        try {
            this.parser = new MXParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.inputStream, "UTF-8");
            this.parser.nextTag();
            this.parser.require(2, null, WFS.FeatureCollection.getLocalPart());
            String nof = this.parser.getAttributeValue(null, "numberOfFeatures");
            if (nof != null) {
                try {
                    this.numberOfFeatures = Integer.valueOf(nof);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Can't parse numberOfFeatures out of " + nof);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new DataSourceException((Throwable)e);
        }
        this.expectedProperties = new TreeMap<String, AttributeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (AttributeDescriptor desc : targetType.getAttributeDescriptors()) {
            this.expectedProperties.put(desc.getLocalName(), desc);
        }
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
        if (null != geometryFactory) {
            this.geomFac = geometryFactory;
        }
    }

    @Override
    public FeatureType getFeatureType() {
        return this.targetType;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.parser.setInput(null);
                this.parser = null;
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (XmlPullParserException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
    }

    @Override
    public SimpleFeature parse() throws IOException {
        String fid;
        try {
            fid = this.seekFeature();
            if (fid == null) {
                return null;
            }
            while (true) {
                int tagType;
                if (1 == (tagType = this.parser.next())) {
                    this.close();
                    return null;
                }
                String tagNs = this.parser.getNamespace();
                String tagName = this.parser.getName();
                if (3 != tagType || !this.featureNamespace.equals(tagNs) || !this.featureName.equals(tagName)) {
                    AttributeDescriptor descriptor;
                    if (2 != tagType || (descriptor = this.expectedProperties.get(tagName)) == null) continue;
                    Object attributeValue = this.parseAttributeValue();
                    this.builder.set(descriptor.getLocalName(), attributeValue);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            throw new DataSourceException((Throwable)e);
        }
        SimpleFeature feature = this.builder.buildFeature(fid);
        return feature;
    }

    private Object parseAttributeValue() throws XmlPullParserException, IOException {
        Object parsedValue;
        String name = this.parser.getName();
        AttributeDescriptor attribute = this.expectedProperties.get(name);
        AttributeType type = attribute.getType();
        if (type instanceof GeometryType) {
            this.parser.nextTag();
            try {
                parsedValue = this.parseGeom();
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new DataSourceException((Throwable)e);
            }
            catch (FactoryException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            String rawTextValue = this.parser.nextText();
            Class binding = type.getBinding();
            parsedValue = Converters.convert((Object)rawTextValue, (Class)binding);
        }
        return parsedValue;
    }

    private Geometry parseGeom() throws NoSuchAuthorityCodeException, FactoryException, XmlPullParserException, IOException {
        Point geom;
        QName startingGeometryTagName = new QName(this.parser.getNamespace(), this.parser.getName());
        int dimension = this.crsDimension(2);
        CoordinateReferenceSystem crs = this.crs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (GML.Point.equals(startingGeometryTagName)) {
            geom = this.parsePoint(dimension, crs);
        } else if (GML.LineString.equals(startingGeometryTagName)) {
            geom = this.parseLineString(dimension, crs);
        } else if (GML.Polygon.equals(startingGeometryTagName)) {
            geom = this.parsePolygon(dimension, crs);
        } else if (GML.MultiPoint.equals(startingGeometryTagName)) {
            geom = this.parseMultiPoint(dimension, crs);
        } else if (GML.MultiLineString.equals(startingGeometryTagName)) {
            geom = this.parseMultiLineString(dimension, crs);
        } else if (GML.MultiSurface.equals(startingGeometryTagName)) {
            geom = this.parseMultiSurface(dimension, crs);
        } else if (GML.MultiPolygon.equals(startingGeometryTagName)) {
            geom = this.parseMultiPolygon(dimension, crs);
        } else {
            throw new IllegalStateException("Unrecognized geometry element " + startingGeometryTagName);
        }
        this.parser.require(3, startingGeometryTagName.getNamespaceURI(), startingGeometryTagName.getLocalPart());
        return geom;
    }

    private Geometry parseMultiPoint(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.nextTag();
        QName memberTag = new QName(this.parser.getNamespace(), this.parser.getName());
        ArrayList<Point> points = new ArrayList<Point>(4);
        if (GML.pointMembers.equals(memberTag)) {
            while (true) {
                this.parser.nextTag();
                if (3 == this.parser.getEventType() && GML.pointMembers.getLocalPart().equals(this.parser.getName())) break;
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
            }
            this.parser.nextTag();
        } else if (GML.pointMember.equals(memberTag)) {
            do {
                this.parser.nextTag();
                this.parser.require(2, "http://www.opengis.net/gml", GML.Point.getLocalPart());
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", GML.pointMember.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType() || !GML.MultiPoint.getLocalPart().equals(this.parser.getName()));
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiPoint.getLocalPart());
        MultiPoint geom = this.geomFac.createMultiPoint(points.toArray(new Point[points.size()]));
        return geom;
    }

    private MultiLineString parseMultiLineString(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        while (true) {
            this.parser.nextTag();
            if (3 == this.parser.getEventType() && GML.MultiLineString.getLocalPart().equals(this.parser.getName())) break;
            this.parser.require(2, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
            LineString line = this.parseLineString(dimension, crs);
            lines.add(line);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        MultiLineString geom = this.geomFac.createMultiLineString(lines.toArray(new LineString[lines.size()]));
        return geom;
    }

    private Geometry parseMultiSurface(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiSurface.getLocalPart());
        this.parser.nextTag();
        QName memberTag = new QName(this.parser.getNamespace(), this.parser.getName());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        if (GML.surfaceMembers.equals(memberTag)) {
            while (true) {
                this.parser.nextTag();
                if (3 == this.parser.getEventType() && GML.surfaceMembers.getLocalPart().equals(this.parser.getName())) break;
                Polygon p = this.parsePolygon(dimension, crs);
                polygons.add(p);
            }
            this.parser.nextTag();
        } else if (GML.surfaceMember.equals(memberTag)) {
            do {
                this.parser.nextTag();
                Polygon p = this.parsePolygon(dimension, crs);
                polygons.add(p);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", GML.surfaceMember.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType() || !GML.MultiSurface.getLocalPart().equals(this.parser.getName()));
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiSurface.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Geometry parseMultiPolygon(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        this.parser.nextTag();
        do {
            this.parser.require(2, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
            Polygon p = this.parsePolygon(dimension, crs);
            polygons.add(p);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            this.parser.nextTag();
        } while (3 != this.parser.getEventType() || !GML.MultiPolygon.getLocalPart().equals(this.parser.getName()));
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Polygon parsePolygon(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        LinearRing shell;
        ArrayList<LinearRing> holes = null;
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", null);
        QName name = new QName(this.parser.getNamespace(), this.parser.getName());
        if (GML.exterior.equals(name)) {
            this.parser.nextTag();
            shell = this.parseLinearRing(dimension, crs);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.exterior.getLocalPart());
        } else if (GML.outerBoundaryIs.equals(name)) {
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
            shell = this.parseLinearRing(dimension, crs);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.outerBoundaryIs.getLocalPart());
        } else {
            throw new IllegalStateException("Unknown polygon boundary element: " + name);
        }
        this.parser.nextTag();
        name = new QName(this.parser.getNamespace(), this.parser.getName());
        if (2 == this.parser.getEventType() && (GML.interior.equals(name) || GML.innerBoundaryIs.equals(name))) {
            holes = new ArrayList<LinearRing>(2);
            do {
                this.parser.require(2, "http://www.opengis.net/gml", name.getLocalPart());
                this.parser.nextTag();
                this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
                LinearRing hole = this.parseLinearRing(dimension, crs);
                this.parser.require(3, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
                holes.add(hole);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", name.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType());
            this.parser.require(3, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        LinearRing[] holesArray = null;
        if (holes != null) {
            holesArray = holes.toArray(new LinearRing[holes.size()]);
        }
        Polygon geom = this.geomFac.createPolygon(shell, holesArray);
        geom.setUserData((Object)crs);
        return geom;
    }

    private LinearRing parseLinearRing(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        crs = this.crs(crs);
        Coordinate[] lineCoords = this.parseLineStringInternal(dimension, crs);
        this.parser.require(3, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        LinearRing linearRing = this.geomFac.createLinearRing(lineCoords);
        linearRing.setUserData((Object)crs);
        return linearRing;
    }

    private LineString parseLineString(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
        crs = this.crs(crs);
        Coordinate[] coordinates = this.parseLineStringInternal(dimension, crs);
        this.parser.require(3, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
        LineString geom = this.geomFac.createLineString(coordinates);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate[] parseLineStringInternal(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException {
        Coordinate[] lineCoords;
        QName lineElementName = new QName(this.parser.getNamespace(), this.parser.getName());
        this.parser.nextTag();
        QName coordsName = new QName(this.parser.getNamespace(), this.parser.getName());
        String tagName = this.parser.getName();
        if (GML.pos.equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate[] point = this.parseCoordList(dimension, crs);
                coords.add(point[0]);
                this.parser.nextTag();
                tagName = this.parser.getName();
            } while ((eventType = this.parser.getEventType()) == 2 && GML.pos.getLocalPart().equals(tagName));
            lineCoords = coords.toArray(new Coordinate[coords.size()]);
        } else if (GML.posList.equals(coordsName)) {
            lineCoords = this.parseCoordList(dimension, crs);
            this.parser.nextTag();
        } else if (GML.coordinates.equals(coordsName)) {
            lineCoords = this.parseCoordinates(dimension, crs);
            this.parser.nextTag();
        } else if (GML.coord.equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate point = this.parseCoord();
                coords.add(point);
                this.parser.nextTag();
                tagName = this.parser.getName();
            } while ((eventType = this.parser.getEventType()) == 2 && GML.coord.getLocalPart().equals(tagName));
            lineCoords = coords.toArray(new Coordinate[coords.size()]);
        } else {
            throw new IllegalStateException("Expected posList or pos inside LinearRing: " + tagName);
        }
        this.parser.require(3, lineElementName.getNamespaceURI(), lineElementName.getLocalPart());
        return lineCoords;
    }

    private Point parsePoint(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        Coordinate point;
        this.parser.require(2, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        crs = this.crs(crs);
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", null);
        if (GML.pos.getLocalPart().equals(this.parser.getName())) {
            Coordinate[] coords = this.parseCoordList(dimension, crs);
            point = coords[0];
            this.parser.nextTag();
        } else if (GML.coordinates.getLocalPart().equals(this.parser.getName())) {
            Coordinate[] coords = this.parseCoordinates(dimension, crs);
            point = coords[0];
            this.parser.nextTag();
        } else if (GML.coord.getLocalPart().equals(this.parser.getName())) {
            point = this.parseCoord();
            this.parser.nextTag();
        } else {
            throw new IllegalStateException("Unknown coordinate element for Point: " + this.parser.getName());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        Point geom = this.geomFac.createPoint(point);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate parseCoord() throws XmlPullParserException, IOException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.coord.getLocalPart());
        double z = 0.0;
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", "X");
        double x = Double.parseDouble(this.parser.nextText());
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", "Y");
        double y = Double.parseDouble(this.parser.nextText());
        this.parser.nextTag();
        if (2 == this.parser.getEventType()) {
            this.parser.require(2, "http://www.opengis.net/gml", "Z");
            z = Double.parseDouble(this.parser.nextText());
            this.parser.nextTag();
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.coord.getLocalPart());
        Coordinate point = new Coordinate(x, y, z);
        return point;
    }

    private CoordinateReferenceSystem crs(CoordinateReferenceSystem defaultValue) throws NoSuchAuthorityCodeException, FactoryException {
        String srsName = this.parser.getAttributeValue(null, "srsName");
        if (srsName == null) {
            return defaultValue;
        }
        if (srsName.startsWith("http://") && srsName.indexOf(35) != -1) {
            srsName = "EPSG:" + srsName.substring(1 + srsName.lastIndexOf(35));
        }
        CoordinateReferenceSystem crs = CRS.decode((String)srsName);
        return crs;
    }

    private int crsDimension(int defaultValue) {
        String srsDimension = this.parser.getAttributeValue(null, "srsDimension");
        if (srsDimension == null) {
            return defaultValue;
        }
        int dimension = Integer.valueOf(srsDimension);
        return dimension;
    }

    private Coordinate[] parseCoordList(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException {
        dimension = this.crsDimension(dimension);
        String rawTextValue = this.parser.nextText();
        Coordinate[] coords = this.toCoordList(rawTextValue, dimension, crs);
        return coords;
    }

    private Coordinate[] parseCoordinates(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException {
        String tupleSeparator;
        String coordSeparator;
        this.parser.require(2, "http://www.opengis.net/gml", GML.coordinates.getLocalPart());
        dimension = this.crsDimension(dimension);
        String decimalSeparator = this.parser.getAttributeValue("", "decimal");
        if (decimalSeparator == null) {
            decimalSeparator = ".";
        }
        if ((coordSeparator = this.parser.getAttributeValue("", "cs")) == null) {
            coordSeparator = ",";
        }
        if ((tupleSeparator = this.parser.getAttributeValue("", "ts")) == null) {
            tupleSeparator = " ";
        }
        String rawTextValue = this.parser.nextText();
        Coordinate[] coords = this.toCoordList(rawTextValue, decimalSeparator, coordSeparator, tupleSeparator, dimension, crs);
        this.parser.require(3, "http://www.opengis.net/gml", GML.coordinates.getLocalPart());
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, int dimension, CoordinateReferenceSystem crs) {
        rawTextValue = rawTextValue.trim();
        rawTextValue = rawTextValue.replaceAll("\n", " ");
        String[] split = (rawTextValue = rawTextValue.replaceAll("\r", " ")).trim().split(" +");
        int ordinatesLength = split.length;
        if (ordinatesLength % dimension != 0) {
            throw new IllegalArgumentException("Number of ordinates (" + ordinatesLength + ") does not match crs dimension: " + dimension);
        }
        boolean invertXY = WFSConfig.invertAxisNeeded(this.axisOrder, crs);
        int nCoords = ordinatesLength / dimension;
        Coordinate[] coords = new Coordinate[nCoords];
        int currCoordIdx = 0;
        for (int i = 0; i < ordinatesLength; i += dimension) {
            Coordinate coord;
            double x = Double.valueOf(split[i]);
            double y = Double.valueOf(split[i + 1]);
            if (dimension > 2) {
                double z = Double.valueOf(split[i + 2]);
                coord = invertXY ? new Coordinate(y, x, z) : new Coordinate(x, y, z);
            } else {
                coord = invertXY ? new Coordinate(y, x) : new Coordinate(x, y);
            }
            coords[currCoordIdx] = coord;
            ++currCoordIdx;
        }
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, String decimalSeparator, String coordSeparator, String tupleSeparator, int dimension, CoordinateReferenceSystem crs) {
        rawTextValue = rawTextValue.replaceAll("[\n\r]", " ").trim();
        String[] tuples = rawTextValue.split("\\" + tupleSeparator + "+");
        int nCoords = tuples.length;
        Coordinate[] coords = new Coordinate[nCoords];
        boolean invertXY = WFSConfig.invertAxisNeeded(this.axisOrder, crs);
        for (int i = 0; i < nCoords; ++i) {
            Coordinate coord;
            String tuple = tuples[i];
            String[] oridnates = tuple.split("\\" + coordSeparator + "+");
            double[] parsedOrdinates = new double[oridnates.length];
            for (int o = 0; o < oridnates.length; ++o) {
                String ordinate = oridnates[o];
                if (!".".equals(decimalSeparator)) {
                    String[] split = ordinate.split("\\" + decimalSeparator);
                    ordinate = split[0] + '.' + split[1];
                }
                parsedOrdinates[o] = Double.parseDouble(ordinate);
            }
            double x = parsedOrdinates[0];
            double y = parsedOrdinates[1];
            if (dimension > 2 && parsedOrdinates.length > 2) {
                double z = parsedOrdinates[2];
                coord = invertXY ? new Coordinate(y, x, z) : new Coordinate(x, y, z);
            } else {
                coord = invertXY ? new Coordinate(y, x) : new Coordinate(x, y);
            }
            coords[i] = coord;
        }
        return coords;
    }

    private String seekFeature() throws IOException, XmlPullParserException {
        while (true) {
            int tagType;
            if ((tagType = this.parser.next()) == 1) {
                this.close();
                return null;
            }
            if (2 != tagType || 2 != tagType) continue;
            String namespace = this.parser.getNamespace();
            String name = this.parser.getName();
            if (this.featureNamespace.equals(namespace) && this.featureName.equals(name)) break;
        }
        String featureId = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "fid");
        }
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "id");
        }
        return featureId;
    }
}

