/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import org.geotools.data.ows.Specification;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.util.Version;
import org.geotools.util.factory.GeoTools;
import org.geotools.xsd.Configuration;
import org.opengis.filter.Filter;
import org.opengis.filter.capability.FilterCapabilities;

public abstract class WFSStrategy
extends Specification {
    private Map<WFSOperationType, AtomicLong> requestHandleSequences = new HashMap<WFSOperationType, AtomicLong>();

    public WFSStrategy() {
        for (WFSOperationType operationType : WFSOperationType.values()) {
            this.requestHandleSequences.put(operationType, new AtomicLong());
        }
    }

    public abstract void setCapabilities(WFSGetCapabilities var1);

    public abstract void setConfig(WFSConfig var1);

    public abstract FeatureTypeInfo getFeatureTypeInfo(QName var1);

    public abstract WFSConfig getConfig();

    public abstract Version getServiceVersion();

    public abstract Set<String> getServerSupportedOutputFormats(WFSOperationType var1);

    public abstract Set<String> getServerSupportedOutputFormats(QName var1, WFSOperationType var2);

    public abstract List<String> getClientSupportedOutputFormats(WFSOperationType var1);

    public abstract Set<QName> getFeatureTypeNames();

    public abstract FilterCapabilities getFilterCapabilities();

    public abstract Filter[] splitFilters(QName var1, Filter var2);

    public abstract boolean supportsOperation(WFSOperationType var1, HttpMethod var2);

    public abstract boolean supports(GetFeatureRequest.ResultType var1);

    public abstract boolean supportsTransaction(QName var1);

    public abstract URL getOperationURL(WFSOperationType var1, HttpMethod var2);

    public abstract Set<String> getSupportedCRSIdentifiers(QName var1);

    public abstract void dispose();

    public abstract String getDefaultOutputFormat(WFSOperationType var1);

    public abstract URL buildUrlGET(WFSRequest var1);

    public abstract String getPostContentType(WFSRequest var1);

    public abstract InputStream getPostContents(WFSRequest var1) throws IOException;

    public abstract WFSServiceInfo getServiceInfo();

    public abstract Configuration getWfsConfiguration();

    public String newRequestHandle(WFSOperationType operation) {
        StringBuilder handle = new StringBuilder("GeoTools ").append((CharSequence)GeoTools.getVersion()).append("(").append(GeoTools.getBuildRevision()).append(") WFS ").append(this.getVersion()).append(" DataStore @");
        try {
            handle.append(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception ignore) {
            handle.append("<uknown host>");
        }
        AtomicLong reqHandleSeq = this.requestHandleSequences.get((Object)operation);
        handle.append('#').append(reqHandleSeq.incrementAndGet());
        return handle.toString();
    }

    public abstract Map<QName, Class<?>> getFieldTypeMappings();
}

