/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;
import org.geotools.ows.ServiceException;
import org.geotools.xsd.Configuration;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DescribeFeatureTypeResponse
extends WFSResponse {
    private FeatureType parsed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribeFeatureTypeResponse(DescribeFeatureTypeRequest request, HTTPResponse httpResponse) throws ServiceException, IOException {
        super(request, httpResponse);
        WFSStrategy strategy = request.getStrategy();
        Configuration wfsConfiguration = strategy.getWfsConfiguration();
        QName remoteTypeName = request.getTypeName();
        FeatureTypeInfo featureTypeInfo = strategy.getFeatureTypeInfo(remoteTypeName);
        CoordinateReferenceSystem defaultCrs = featureTypeInfo.getCRS();
        InputStream responseStream = httpResponse.getResponseStream();
        try {
            File tmpSchemaFile = File.createTempFile(remoteTypeName.getLocalPart(), ".xsd");
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tmpSchemaFile));
            try {
                IOUtils.copy((InputStream)responseStream, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).flush();
                IOUtils.closeQuietly((OutputStream)output);
            }
            try {
                URL schemaLocation = tmpSchemaFile.toURI().toURL();
                this.parsed = EmfAppSchemaParser.parse(wfsConfiguration, remoteTypeName, schemaLocation, defaultCrs, strategy.getFieldTypeMappings());
            }
            finally {
                tmpSchemaFile.delete();
            }
        }
        finally {
            responseStream.close();
            httpResponse.dispose();
        }
    }

    public FeatureType getFeatureType() {
        return this.parsed;
    }
}

