/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v1_x;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wfs.InsertResultsType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionSummaryType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.TransactionResponse;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.ows.ServiceException;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class TransactionResponseImpl
extends WFSResponse
implements TransactionResponse {
    private List<FeatureId> inserted = new ArrayList<FeatureId>();
    private int deletedCount;
    private int updatedCount;
    private int insertCount;

    public TransactionResponseImpl(WFSRequest originatingRequest, HTTPResponse response, InputStream in) throws ServiceException, IOException {
        super(originatingRequest, response);
        Object parsed;
        try {
            WFSStrategy strategy = originatingRequest.getStrategy();
            Configuration wfsConfiguration = strategy.getWfsConfiguration();
            Parser parser = new Parser(wfsConfiguration);
            EntityResolver resolver = strategy.getConfig().getEntityResolver();
            if (resolver != null) {
                parser.setEntityResolver(resolver);
            }
            parsed = parser.parse(in);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        finally {
            response.dispose();
        }
        if (parsed instanceof TransactionResponseType) {
            TransactionSummaryType ts;
            TransactionResponseType tr = (TransactionResponseType)parsed;
            InsertResultsType insertResults = tr.getInsertResults();
            if (insertResults != null) {
                EList inserted = insertResults.getFeature();
                for (InsertedFeatureType i : inserted) {
                    EList featureIds = i.getFeatureId();
                    if (null == featureIds) continue;
                    this.inserted.addAll((Collection<FeatureId>)featureIds);
                }
            }
            if ((ts = tr.getTransactionSummary()) != null) {
                BigInteger totalInserted = ts.getTotalInserted();
                BigInteger totalDeleted = ts.getTotalDeleted();
                BigInteger totalUpdated = ts.getTotalUpdated();
                this.updatedCount = totalUpdated == null ? -1 : totalUpdated.intValue();
                this.deletedCount = totalDeleted == null ? -1 : totalDeleted.intValue();
                this.insertCount = totalInserted == null ? -1 : totalInserted.intValue();
            }
        } else {
            throw new IOException();
        }
    }

    @Override
    public List<FeatureId> getInsertedFids() {
        return Collections.unmodifiableList(this.inserted);
    }

    @Override
    public int getUpdatedCount() {
        return this.updatedCount;
    }

    @Override
    public int getDeleteCount() {
        return this.deletedCount;
    }

    @Override
    public int getInsertCount() {
        return this.insertCount;
    }
}

