/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.parsers.AbstractGetFeatureResponseParserFactory;
import org.geotools.data.wfs.internal.parsers.XmlSimpleFeatureParser;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class GmlGetFeatureResponseParserFactory
extends AbstractGetFeatureResponseParserFactory {
    private static final List<String> SUPPORTED_FORMATS = Collections.unmodifiableList(Arrays.asList("text/xml; subtype=gml/3.1.1", "text/xml;subtype=gml/3.1.1", "text/xml; subtype=gml/3.1.1; charset=UTF-8", "text/xml; subtype=gml/3.1.1/profiles/gmlsf/0", "text/xml;subtype=gml/3.1.1/profiles/gmlsf/0", "application/gml+xml; subtype=gml/3.1.1", "application/gml+xml;subtype=gml/3.1.1", "application/gml+xml; subtype=gml/3.1.1/profiles/gmlsf/0", "application/gml+xml;subtype=gml/3.1.1/profiles/gmlsf/0", "GML3", "GML3L0", "text/xml", "text/xml; charset=UTF-8", "text/gml; subtype=gml/3.1.1", "GML2", "text/xml; subtype=gml/2.1.2", "application/xml"));
    private static final List<String> SUPPORTED_VERSIONS = Collections.unmodifiableList(Arrays.asList(Versions.v1_0_0.toString(), Versions.v1_1_0.toString()));

    @Override
    protected GetFeatureParser parser(GetFeatureRequest request, InputStream in) throws IOException {
        QName remoteFeatureName = request.getTypeName();
        FeatureType queryType = request.getQueryType();
        if (queryType == null) {
            queryType = request.getFullType();
        }
        if (!(queryType instanceof SimpleFeatureType)) {
            throw new UnsupportedOperationException();
        }
        SimpleFeatureType schema = (SimpleFeatureType)queryType;
        XmlSimpleFeatureParser featureReader = new XmlSimpleFeatureParser(in, schema, remoteFeatureName, request.getStrategy().getConfig().getAxisOrder());
        return featureReader;
    }

    @Override
    public List<String> getSupportedOutputFormats() {
        return SUPPORTED_FORMATS;
    }

    @Override
    protected List<String> getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }
}

