/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.wfs.internal.ExceptionDetails;

public class WFSException
extends IOException {
    private static final long serialVersionUID = -2828901359361793862L;
    private StringBuilder msg;
    private List<ExceptionDetails> exceptionDetails = new ArrayList<ExceptionDetails>();

    public WFSException(String msg) {
        this(msg, null);
    }

    public WFSException(String msg, Throwable cause) {
        super(msg);
        super.initCause(cause);
        this.msg = new StringBuilder();
        if (msg != null) {
            this.msg.append(msg);
        }
    }

    @Deprecated
    public void addExceptionReport(String report) {
        this.addExceptionMessage(report);
    }

    public void addExceptionMessage(String message) {
        this.msg.append("\n\t[").append(message).append("]");
    }

    public void addExceptionDetails(String code, String locator, List<String> texts) {
        this.addExceptionMessage(code + ": " + String.valueOf(texts));
        this.exceptionDetails.add(new ExceptionDetails(code, locator, texts));
    }

    @Override
    public String getMessage() {
        return this.msg.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.msg.toString();
    }

    public List<ExceptionDetails> getExceptionDetails() {
        return Collections.unmodifiableList(this.exceptionDetails);
    }
}

