/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.geotools.data.ServiceInfo;
import org.geotools.data.complex.config.EmfComplexFeatureReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.wfs.impl.WFSContentComplexFeatureSource;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.gml3.complex.GmlFeatureTypeRegistryConfiguration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.complex.FeatureTypeRegistryConfiguration;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaResolver;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;

public class WFSContentDataAccess
implements DataAccess<FeatureType, Feature> {
    private final WFSClient client;
    private EmfComplexFeatureReader schemaParser;
    private FeatureTypeRegistry typeRegistry;
    private File cacheLocation;
    private final Map<Name, QName> names;
    protected String namespaceURI;

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public WFSContentDataAccess(WFSClient client) {
        this.client = client;
        this.names = new ConcurrentHashMap<Name, QName>();
    }

    public ServiceInfo getInfo() {
        return this.client.getInfo();
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support createSchema.");
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support update schema.");
    }

    public List<Name> getNames() throws IOException {
        Set<QName> remoteTypeNames = this.client.getRemoteTypeNames();
        ArrayList<Name> namesList = new ArrayList<Name>(remoteTypeNames.size());
        for (QName remoteTypeName : remoteTypeNames) {
            NameImpl typeName = new NameImpl(remoteTypeName);
            namesList.add((Name)typeName);
            this.names.put((Name)typeName, remoteTypeName);
        }
        return namesList;
    }

    public QName getRemoteTypeName(Name localTypeName) throws IOException {
        QName qName;
        if (this.names.isEmpty()) {
            this.getNames();
        }
        if (null == (qName = this.names.get(localTypeName))) {
            throw new NoSuchElementException(localTypeName.toString());
        }
        return qName;
    }

    public FeatureType getSchema(Name name) throws IOException {
        if (this.names.size() == 0) {
            this.getNames();
        }
        DescribeFeatureTypeRequest describeFeatureTypeRequest = this.client.createDescribeFeatureTypeRequest();
        QName qname = this.names.get(name);
        describeFeatureTypeRequest.setTypeName(qname);
        URL describeRequestURL = describeFeatureTypeRequest.getFinalURL();
        FeatureTypeRegistry typeRegistry = this.getFeatureTypeRegistry();
        SchemaIndex schemaIndex = this.getSchemaParser().parse(describeRequestURL);
        typeRegistry.addSchemas(schemaIndex);
        AttributeDescriptor attributeDescriptor = typeRegistry.getDescriptor(name, null);
        return (FeatureType)attributeDescriptor.getType();
    }

    public void setCacheLocation(File cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name typeName) throws IOException {
        WFSContentComplexFeatureSource contentComplexFeatureSource = new WFSContentComplexFeatureSource(typeName, this.client, this);
        return contentComplexFeatureSource;
    }

    public void dispose() {
        this.schemaParser = null;
        this.typeRegistry = null;
    }

    private EmfComplexFeatureReader getSchemaParser() {
        if (this.schemaParser == null) {
            this.schemaParser = EmfComplexFeatureReader.newInstance();
            SchemaResolver appSchemaResolver = this.cacheLocation == null ? new SchemaResolver() : new SchemaResolver(new SchemaCache(this.cacheLocation, true, true));
            this.schemaParser.setResolver(appSchemaResolver);
        }
        return this.schemaParser;
    }

    private FeatureTypeRegistry getFeatureTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new FeatureTypeRegistry((FeatureTypeFactory)new ComplexFeatureTypeFactoryImpl(), (FeatureTypeRegistryConfiguration)new GmlFeatureTypeRegistryConfiguration(null));
        }
        return this.typeRegistry;
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException("WFSContentDataAccess does not support remove schema.");
    }
}

