/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFeatureSource;
import org.geotools.data.transform.TransformFeatureStore;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class TransformFactory {
    static final Logger LOGGER = Logging.getLogger(TransformFactory.class);

    public static SimpleFeatureSource transform(SimpleFeatureSource source, String name, List<Definition> definitions) throws IOException {
        return TransformFactory.transform(source, (Name)new NameImpl(((SimpleFeatureType)source.getSchema()).getName().getNamespaceURI(), name), definitions);
    }

    public static SimpleFeatureSource transform(SimpleFeatureSource source, Name name, List<Definition> definitions) throws IOException {
        if (source instanceof SimpleFeatureStore) {
            try {
                return new TransformFeatureStore((SimpleFeatureStore)source, name, definitions);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINEST, "Could not transform the provided store, will turn it into a read only SimpleFeatureSource instead (this is not a problem unless you actually needed to write on the store)", e);
            }
        }
        return new TransformFeatureSource(source, name, definitions);
    }
}

