/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.sort.SortedFeatureIterator;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.transform.MaxFeaturesIterator;
import org.geotools.data.transform.SimpleFeatureIteratorIterator;
import org.geotools.data.transform.TransformFeatureIteratorWrapper;
import org.geotools.data.transform.Transformer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.geometry.BoundingBox;

class TransformFeatureCollection
extends AbstractFeatureCollection {
    static final Logger LOGGER = Logging.getLogger(TransformFeatureCollection.class);
    SimpleFeatureSource source;
    Transformer transformer;
    Query query;

    public TransformFeatureCollection(SimpleFeatureSource source, Transformer transformer, Query query) {
        super(TransformFeatureCollection.retypeSchema((SimpleFeatureType)source.getSchema(), query));
        this.source = source;
        this.transformer = transformer;
        this.query = query;
    }

    static SimpleFeatureType retypeSchema(SimpleFeatureType schema, Query query) {
        if (query.getPropertyNames() == Query.ALL_NAMES) {
            return schema;
        }
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)schema, (String[])query.getPropertyNames());
    }

    protected Iterator<SimpleFeature> openIterator() {
        try {
            Query txQuery = this.transformer.transformQuery(this.query);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "The original query for feature extraction {0} has been transformed to {1}", new Object[]{this.query, txQuery});
            }
            SimpleFeatureIterator fi = this.transformer.getSource().getFeatures(txQuery).features();
            Object transformed = new TransformFeatureIteratorWrapper((FeatureIterator<SimpleFeature>)fi, this.transformer);
            if (this.query.getSortBy() != null && txQuery.getSortBy() == null) {
                transformed = new SortedFeatureIterator((SimpleFeatureIterator)transformed, this.getSchema(), this.query.getSortBy(), -1);
            }
            if (this.query.getStartIndex() != null && txQuery.getStartIndex() == null) {
                for (int i = 0; i < this.query.getStartIndex() && transformed.hasNext(); ++i) {
                    transformed.next();
                }
            }
            if (txQuery.getMaxFeatures() > this.query.getMaxFeatures()) {
                transformed = new MaxFeaturesIterator((SimpleFeatureIterator)transformed, this.query.getMaxFeatures());
            }
            return new SimpleFeatureIteratorIterator((SimpleFeatureIterator)transformed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n;
        block9: {
            Query txQuery = this.transformer.transformQuery(this.query);
            int size = this.source.getCount(this.query);
            if (size >= 0) {
                if (this.query.getStartIndex() != null && txQuery.getStartIndex() == null) {
                    size -= this.query.getStartIndex().intValue();
                }
                return Math.min(size, this.query.getMaxFeatures());
            }
            SimpleFeatureIterator fi = null;
            try {
                size = 0;
                fi = this.source.getFeatures(this.query).features();
                while (fi.hasNext()) {
                    fi.next();
                    ++size;
                }
                n = size;
                if (fi == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fi.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope referencedEnvelope;
        block9: {
            ReferencedEnvelope re = this.source.getBounds(this.query);
            if (re != null) {
                return re;
            }
            SimpleFeatureIterator fi = null;
            try {
                fi = this.source.getFeatures(this.query).features();
                while (fi.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fi.next();
                    BoundingBox bb = f.getBounds();
                    if (bb == null) continue;
                    ReferencedEnvelope ref = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)bb);
                    if (re == null) {
                        re = ref;
                        continue;
                    }
                    re.expandToInclude((Envelope)ref);
                }
                referencedEnvelope = re;
                if (fi == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fi.close();
        }
        return referencedEnvelope;
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        if (filter == Filter.EXCLUDE || this.query.getFilter() == Filter.EXCLUDE) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        Query q = new Query(this.query);
        if (this.query.getFilter() == Filter.INCLUDE) {
            q.setFilter(filter);
        } else {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            And combined = ff.and(filter, q.getFilter());
            q.setFilter((Filter)combined);
        }
        return new TransformFeatureCollection(this.source, this.transformer, q);
    }
}

