/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.process;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.geotools.data.Parameter;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.swing.JProgressWindow;
import org.geotools.swing.process.ProcessParameterPage;
import org.geotools.swing.process.ProcessSelectionPage;
import org.geotools.swing.wizard.JDoubleField;
import org.geotools.swing.wizard.JField;
import org.geotools.swing.wizard.JGeometryField;
import org.geotools.swing.wizard.JPage;
import org.geotools.swing.wizard.ParamField;
import org.geotools.text.Text;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

public class ProcessRunPage
extends JPage {
    ProcessFactory factory;
    Name name;
    Map<String, Object> paramMap;

    public ProcessRunPage(ProcessFactory factory) {
        this(factory, null);
    }

    public ProcessRunPage(ProcessFactory factory, Map<String, Object> params) {
        super("Run Process");
        this.factory = factory;
        this.paramMap = params;
    }

    @Override
    public String getBackPageIdentifier() {
        if (this.factory == null) {
            ProcessSelectionPage selectionPage = new ProcessSelectionPage();
            this.getJWizard().registerWizardPanel(selectionPage);
            return selectionPage.getPageIdentifier();
        }
        ProcessParameterPage inputPage = new ProcessParameterPage(this.factory);
        this.getJWizard().registerWizardPanel(inputPage);
        return inputPage.getPageIdentifier();
    }

    @Override
    public String getNextPageIdentifier() {
        return "Finish";
    }

    public void aboutToDisplayPanel() {
        JPanel page = this.getPanel();
        page.removeAll();
        page.setLayout(new GridLayout(0, 2));
        Process process = this.factory.create(this.name);
        JProgressWindow progress = new JProgressWindow(this.getJWizard());
        Map resultMap = process.execute(this.paramMap, (ProgressListener)progress);
        JLabel title = new JLabel(this.factory.getTitle().toString());
        page.add(title);
        JLabel description = new JLabel("Your process results are below:");
        page.add(description);
        for (Map.Entry entry : resultMap.entrySet()) {
            Parameter parameter = new Parameter((String)entry.getKey(), entry.getValue().getClass(), Text.text((String)"Result"), Text.text((String)"Result of process"));
            JLabel label = new JLabel((String)entry.getKey());
            page.add(label);
            ParamField widget = Double.class.isAssignableFrom(parameter.type) ? new JDoubleField(parameter) : (Geometry.class.isAssignableFrom(parameter.type) ? new JGeometryField(parameter) : new JField(parameter));
            JComponent field = ((ParamField)widget).doLayout();
            ((ParamField)widget).setValue(entry.getValue());
            page.add(field);
        }
    }
}

