/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.locale;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.geotools.swing.locale.PropertiesFileInfo;
import org.geotools.util.URLs;

public class PropertiesFileFinder {
    public List<PropertiesFileInfo> scan(String resourceDir) throws IOException {
        ArrayList<SingleFileInfo> infoList = new ArrayList<SingleFileInfo>();
        String path = this.getSelfPath();
        if (this.isJarPath(path)) {
            JarEntry entry;
            JarInputStream jarFile = this.getAsJarInputStream(path);
            while ((entry = jarFile.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith(resourceDir) || !name.endsWith("properties")) continue;
                infoList.add(this.parseEntry(resourceDir.length(), name));
            }
            jarFile.close();
        } else {
            File[] children;
            File localDir = this.getAsLocalDir(path);
            for (File child : children = localDir.listFiles()) {
                String name;
                if (child == null || !child.isFile() || !(name = child.getName()).endsWith(".properties")) continue;
                infoList.add(this.parseEntry(0, name));
            }
        }
        return this.createReturnList(infoList);
    }

    private String getSelfPath() {
        String className = this.getClass().getSimpleName() + ".class";
        URL url = this.getClass().getResource(className);
        if (url.getProtocol().equals("file")) {
            return URLs.urlToFile((URL)url).getPath();
        }
        return url.toString();
    }

    private boolean isJarPath(String path) {
        return path.contains(".jar!");
    }

    private JarInputStream getAsJarInputStream(String jarPath) throws IOException {
        JarInputStream jis = null;
        URL jarUrl = new URL(jarPath);
        InputStream is = jarUrl.openStream();
        jis = new JarInputStream(is);
        return jis;
    }

    private File getAsLocalDir(String dirPath) {
        int pos = dirPath.lastIndexOf(File.separatorChar);
        File file = new File(dirPath.substring(0, pos));
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory path: " + file);
        }
        return file;
    }

    private SingleFileInfo parseEntry(int prefixLength, String entry) {
        entry = entry.substring(prefixLength, entry.indexOf(".properties"));
        String[] parts = entry.split("_");
        String baseName = parts[0];
        String language = "";
        String country = "";
        String variant = "";
        if (parts.length > 1) {
            language = parts[1];
        }
        if (parts.length > 2) {
            country = parts[2];
        }
        if (parts.length > 3) {
            variant = parts[3];
        }
        Locale locale = parts.length == 1 ? Locale.ROOT : new Locale(language, country, variant);
        return new SingleFileInfo(baseName, locale);
    }

    private List<PropertiesFileInfo> createReturnList(List<SingleFileInfo> infoList) {
        ArrayList<PropertiesFileInfo> pfiList = new ArrayList<PropertiesFileInfo>();
        if (!infoList.isEmpty()) {
            Collections.sort(infoList, new Comparator<SingleFileInfo>(){

                @Override
                public int compare(SingleFileInfo o1, SingleFileInfo o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            String curName = infoList.get((int)0).name;
            ArrayList<Locale> locales = new ArrayList<Locale>();
            ListIterator<SingleFileInfo> iter = infoList.listIterator();
            while (iter.hasNext()) {
                SingleFileInfo sfi = iter.next();
                if (sfi.name.equals(curName)) {
                    locales.add(sfi.locale);
                    continue;
                }
                pfiList.add(new PropertiesFileInfo(curName, locales));
                curName = sfi.name;
                locales.clear();
                locales.add(sfi.locale);
            }
            pfiList.add(new PropertiesFileInfo(curName, locales));
        }
        return pfiList;
    }

    private static class SingleFileInfo {
        String name;
        Locale locale;

        public SingleFileInfo(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }
    }
}

