/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.InfoToolHelperUtils;
import org.geotools.swing.tool.InfoToolResult;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;

public class GridCoverageLayerHelper
extends InfoToolHelper {
    @Override
    public void setLayer(Layer layer) {
        if (!(layer instanceof GridCoverageLayer)) {
            throw new IllegalArgumentException("layer must be an instance of GridCoverageLayer");
        }
        super.setLayer(layer);
    }

    @Override
    public boolean isSupportedLayer(Layer layer) {
        return layer instanceof GridCoverageLayer;
    }

    @Override
    public InfoToolResult getInfo(DirectPosition2D pos) throws Exception {
        Object objArray;
        Number[] bandValues;
        DirectPosition2D trPos;
        GridCoverage2D source;
        ReferencedEnvelope env;
        InfoToolResult result = new InfoToolResult();
        if (this.isValid() && (env = new ReferencedEnvelope((BoundingBox)(source = ((GridCoverageLayer)this.getLayer()).getCoverage()).getEnvelope2D())).contains((DirectPosition)(trPos = InfoToolHelperUtils.getTransformed(pos, this.getContentToLayerTransform()))) && (bandValues = InfoToolHelperUtils.asNumberArray(objArray = source.evaluate((DirectPosition)trPos))) != null) {
            result.newFeature("Raw values");
            for (int i = 0; i < bandValues.length; ++i) {
                result.setFeatureValue("Band " + i, (Object)bandValues[i]);
            }
        }
        return result;
    }
}

