/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.index.rtree.EntryBoundsChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry<T>
implements Cloneable {
    private Envelope bounds;
    private T data;
    private EntryBoundsChangeListener listener;

    public Entry(Envelope e, T data) {
        this.bounds = e;
        this.data = data;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        Entry e = (Entry)obj;
        return this.bounds.equals((Object)e.getBounds()) && this.data.equals(e.getData());
    }

    void setBounds(Envelope envelope) {
        this.bounds = envelope;
        if (this.listener != null) {
            this.listener.boundsChanged(this);
        }
    }

    protected Object clone() {
        Entry<T> ret = new Entry<T>(new Envelope(this.bounds), this.data);
        ret.setListener(this.listener);
        return ret;
    }

    public String toString() {
        return "Entry --> " + this.bounds + " - key: " + this.data;
    }

    public void setListener(EntryBoundsChangeListener listener) {
        this.listener = listener;
    }
}

