/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixtureUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Properties properties;
        block6: {
            InputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(file));
                Properties properties2 = new Properties();
                properties2.load(input);
                properties = properties2;
                if (input == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return properties;
    }

    public static File getFixtureDirectory() {
        return new File(System.getProperty("user.home") + File.separator + ".geotools");
    }

    public static File getFixtureFile(File fixtureDirectory, String fixtureId) {
        return new File(fixtureDirectory, fixtureId.replace('.', File.separatorChar).concat(".properties"));
    }

    public static void printSkipNotice(String fixtureId, File fixtureFile) {
        try {
            System.out.println("Skipping " + fixtureId + " tests. Fixture file " + fixtureFile.getCanonicalPath() + " not found.");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    public static Properties loadFixture(String fixtureId) {
        File fixtureFile = FixtureUtilities.getFixtureFile(FixtureUtilities.getFixtureDirectory(), fixtureId);
        if (fixtureFile.exists()) {
            return FixtureUtilities.loadProperties(fixtureFile);
        }
        FixtureUtilities.printSkipNotice(fixtureId, fixtureFile);
        return null;
    }
}

